/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ByteBufferWriter;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.nested.DoubleFieldColumnWriter;
import org.apache.druid.segment.nested.GlobalDictionaryEncodedFieldColumnWriter;
import org.apache.druid.segment.nested.GlobalDictionaryIdLookup;
import org.apache.druid.segment.nested.LongFieldColumnWriter;
import org.apache.druid.segment.nested.NestedDataColumnMetadata;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.StringFieldColumnWriter;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataProcessor;
import org.apache.druid.segment.nested.VariantLiteralFieldColumnWriter;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class NestedDataColumnSerializer
implements GenericColumnSerializer<StructuredData> {
    private static final Logger log = new Logger(NestedDataColumnSerializer.class);
    public static final IntTypeStrategy INT_TYPE_STRATEGY = new IntTypeStrategy();
    public static final String STRING_DICTIONARY_FILE_NAME = "__stringDictionary";
    public static final String LONG_DICTIONARY_FILE_NAME = "__longDictionary";
    public static final String DOUBLE_DICTIONARY_FILE_NAME = "__doubleDictionary";
    public static final String RAW_FILE_NAME = "__raw";
    public static final String NULL_BITMAP_FILE_NAME = "__nullIndex";
    public static final String NESTED_FIELD_PREFIX = "__field_";
    private final String name;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final IndexSpec indexSpec;
    private final Closer closer;
    private final StructuredDataProcessor fieldProcessor = new StructuredDataProcessor(){

        @Override
        public int processLiteralField(ArrayList<NestedPathPart> fieldPath, Object fieldValue) {
            GlobalDictionaryEncodedFieldColumnWriter writer = (GlobalDictionaryEncodedFieldColumnWriter)NestedDataColumnSerializer.this.fieldWriters.get(NestedPathFinder.toNormalizedJsonPath(fieldPath));
            if (writer != null) {
                try {
                    ExprEval eval = ExprEval.bestEffortOf((Object)fieldValue);
                    writer.addValue(NestedDataColumnSerializer.this.rowCount, eval.value());
                    return 0;
                }
                catch (IOException e) {
                    throw new RuntimeException(":(");
                }
            }
            return 0;
        }
    };
    private byte[] metadataBytes;
    private GlobalDictionaryIdLookup globalDictionaryIdLookup;
    private SortedMap<String, NestedLiteralTypeInfo.MutableTypeSet> fields;
    private GenericIndexedWriter<String> fieldsWriter;
    private NestedLiteralTypeInfo.Writer fieldsInfoWriter;
    private DictionaryWriter<String> dictionaryWriter;
    private FixedIndexedWriter<Long> longDictionaryWriter;
    private FixedIndexedWriter<Double> doubleDictionaryWriter;
    private CompressedVariableSizedBlobColumnSerializer rawWriter;
    private ByteBufferWriter<ImmutableBitmap> nullBitmapWriter;
    private MutableBitmap nullRowsBitmap;
    private Map<String, GlobalDictionaryEncodedFieldColumnWriter<?>> fieldWriters;
    private int rowCount = 0;
    private boolean closedForWrite = false;

    public NestedDataColumnSerializer(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ProgressIndicator progressIndicator, Closer closer) {
        this.name = name;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.closer = closer;
        this.globalDictionaryIdLookup = new GlobalDictionaryIdLookup();
    }

    @Override
    public void open() throws IOException {
        this.fieldsWriter = new GenericIndexedWriter<String>(this.segmentWriteOutMedium, this.name, GenericIndexed.STRING_STRATEGY);
        this.fieldsWriter.open();
        this.fieldsInfoWriter = new NestedLiteralTypeInfo.Writer(this.segmentWriteOutMedium);
        this.fieldsInfoWriter.open();
        this.dictionaryWriter = StringEncodingStrategies.getStringDictionaryWriter(this.indexSpec.getStringDictionaryEncoding(), this.segmentWriteOutMedium, this.name);
        this.dictionaryWriter.open();
        this.longDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.LONG.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.longDictionaryWriter.open();
        this.doubleDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.DOUBLE.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.doubleDictionaryWriter.open();
        this.rawWriter = new CompressedVariableSizedBlobColumnSerializer(NestedDataColumnSerializer.getInternalFileName(this.name, RAW_FILE_NAME), this.segmentWriteOutMedium, this.indexSpec.getJsonCompression() != null ? this.indexSpec.getJsonCompression() : CompressionStrategy.LZ4);
        this.rawWriter.open();
        this.nullBitmapWriter = new ByteBufferWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.nullBitmapWriter.open();
        this.nullRowsBitmap = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
    }

    public void serializeFields(SortedMap<String, NestedLiteralTypeInfo.MutableTypeSet> fields) throws IOException {
        this.fields = fields;
        this.fieldWriters = Maps.newHashMapWithExpectedSize((int)fields.size());
        int ctr = 0;
        for (Map.Entry<String, NestedLiteralTypeInfo.MutableTypeSet> field : fields.entrySet()) {
            String fieldName = field.getKey();
            String fieldFileName = NESTED_FIELD_PREFIX + ctr++;
            this.fieldsWriter.write(fieldName);
            this.fieldsInfoWriter.write(field.getValue());
            ColumnType type = field.getValue().getSingleType();
            GlobalDictionaryEncodedFieldColumnWriter writer = type != null ? (Types.is((TypeSignature)type, (TypeDescriptor)ValueType.STRING) ? new StringFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.indexSpec, this.globalDictionaryIdLookup) : (Types.is((TypeSignature)type, (TypeDescriptor)ValueType.LONG) ? new LongFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.indexSpec, this.globalDictionaryIdLookup) : new DoubleFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.indexSpec, this.globalDictionaryIdLookup))) : new VariantLiteralFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.indexSpec, this.globalDictionaryIdLookup);
            writer.open();
            this.fieldWriters.put(fieldName, writer);
        }
    }

    public void serializeStringDictionary(Iterable<String> dictionaryValues) throws IOException {
        this.dictionaryWriter.write(null);
        this.globalDictionaryIdLookup.addString(null);
        for (String value : dictionaryValues) {
            if (NullHandling.emptyToNullIfNeeded((String)value) == null) continue;
            this.dictionaryWriter.write(value);
            value = NullHandling.emptyToNullIfNeeded((String)value);
            this.globalDictionaryIdLookup.addString(value);
        }
    }

    public void serializeLongDictionary(Iterable<Long> dictionaryValues) throws IOException {
        for (Long value : dictionaryValues) {
            if (value == null) continue;
            this.longDictionaryWriter.write(value);
            this.globalDictionaryIdLookup.addLong(value);
        }
    }

    public void serializeDoubleDictionary(Iterable<Double> dictionaryValues) throws IOException {
        for (Double value : dictionaryValues) {
            if (value == null) continue;
            this.doubleDictionaryWriter.write(value);
            this.globalDictionaryIdLookup.addDouble(value);
        }
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        StructuredData data = (StructuredData)selector.getObject();
        if (data == null) {
            this.nullRowsBitmap.add(this.rowCount);
        }
        this.rawWriter.addValue(NestedDataComplexTypeSerde.INSTANCE.toBytes(data));
        if (data != null) {
            this.fieldProcessor.processFields(data.getValue());
        }
        ++this.rowCount;
    }

    @Override
    public long getSerializedSize() throws IOException {
        if (!this.closedForWrite) {
            this.closedForWrite = true;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IndexMerger.SERIALIZER_UTILS.writeString((OutputStream)baos, NestedDataComplexTypeSerde.OBJECT_MAPPER.writeValueAsString((Object)new NestedDataColumnMetadata(ByteOrder.nativeOrder(), this.indexSpec.getBitmapSerdeFactory(), this.name, !this.nullRowsBitmap.isEmpty())));
            this.metadataBytes = baos.toByteArray();
            this.nullBitmapWriter.write(this.nullRowsBitmap);
        }
        long size = 1L;
        size += (long)this.metadataBytes.length;
        if (this.fieldsWriter != null) {
            size += this.fieldsWriter.getSerializedSize();
        }
        if (this.fieldsInfoWriter != null) {
            size += this.fieldsInfoWriter.getSerializedSize();
        }
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        Preconditions.checkArgument((boolean)this.dictionaryWriter.isSorted(), (Object)"Dictionary not sorted?!?");
        channel.write(ByteBuffer.wrap(new byte[]{4}));
        channel.write(ByteBuffer.wrap(this.metadataBytes));
        this.fieldsWriter.writeTo(channel, smoosher);
        this.fieldsInfoWriter.writeTo(channel, smoosher);
        this.writeInternal(smoosher, this.dictionaryWriter, STRING_DICTIONARY_FILE_NAME);
        this.writeInternal(smoosher, this.longDictionaryWriter, LONG_DICTIONARY_FILE_NAME);
        this.writeInternal(smoosher, this.doubleDictionaryWriter, DOUBLE_DICTIONARY_FILE_NAME);
        this.writeInternal(smoosher, this.rawWriter, RAW_FILE_NAME);
        if (!this.nullRowsBitmap.isEmpty()) {
            this.writeInternal(smoosher, this.nullBitmapWriter, NULL_BITMAP_FILE_NAME);
        }
        if (channel instanceof SmooshedWriter) {
            channel.close();
        }
        for (Map.Entry<String, NestedLiteralTypeInfo.MutableTypeSet> field : this.fields.entrySet()) {
            GlobalDictionaryEncodedFieldColumnWriter<?> writer = this.fieldWriters.remove(field.getKey());
            writer.writeTo(this.rowCount, smoosher);
        }
        log.info("Column [%s] serialized successfully with [%d] nested columns.", new Object[]{this.name, this.fields.size()});
    }

    private void writeInternal(FileSmoosher smoosher, Serializer serializer, String fileName) throws IOException {
        String internalName = NestedDataColumnSerializer.getInternalFileName(this.name, fileName);
        try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(internalName, serializer.getSerializedSize());){
            serializer.writeTo((WritableByteChannel)smooshChannel, smoosher);
        }
    }

    public static String getInternalFileName(String fileNameBase, String field) {
        return StringUtils.format((String)"%s.%s", (Object[])new Object[]{fileNameBase, field});
    }

    private static final class IntTypeStrategy
    implements TypeStrategy<Integer> {
        private IntTypeStrategy() {
        }

        public int estimateSizeBytes(Integer value) {
            return 4;
        }

        public Integer read(ByteBuffer buffer) {
            return buffer.getInt();
        }

        public Integer read(ByteBuffer buffer, int offset) {
            return buffer.getInt(offset);
        }

        public boolean readRetainsBufferReference() {
            return false;
        }

        public int write(ByteBuffer buffer, Integer value, int maxSizeBytes) {
            TypeStrategies.checkMaxSize((int)buffer.remaining(), (int)maxSizeBytes, (TypeSignature)ColumnType.LONG);
            int sizeBytes = 4;
            int remaining = maxSizeBytes - 4;
            if (remaining >= 0) {
                buffer.putInt(value);
                return 4;
            }
            return remaining;
        }

        public int compare(Integer o1, Integer o2) {
            return Integer.compare(o1, o2);
        }
    }
}

