/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.IntIndexView;

public class BlockCompressedPayloadReader
implements Closeable {
    private static final ByteBuffer NULL_CELL = ByteBuffer.wrap(new byte[0]);
    private final IntIndexView blockIndexView;
    private final ByteBuffer compressedBlocksByteBuffer;
    private final ByteBuffer uncompressedByteBuffer;
    private final Closer closer;
    private final int blockSize;
    private final long maxValidUncompressedOffset;
    private final CompressionStrategy.Decompressor decompressor;
    private int currentUncompressedBlockNumber = -1;

    private BlockCompressedPayloadReader(IntIndexView blockIndexView, ByteBuffer compressedBlocksByteBuffer, ByteBuffer uncompressedByteBuffer, CompressionStrategy.Decompressor decompressor, Closer closer) {
        this.blockIndexView = blockIndexView;
        this.compressedBlocksByteBuffer = compressedBlocksByteBuffer;
        this.uncompressedByteBuffer = uncompressedByteBuffer;
        this.closer = closer;
        uncompressedByteBuffer.clear();
        this.blockSize = uncompressedByteBuffer.remaining();
        this.maxValidUncompressedOffset = Integer.MAX_VALUE * (long)this.blockSize;
        this.decompressor = decompressor;
    }

    public static BlockCompressedPayloadReader create(ByteBuffer originalByteBuffer, ByteBufferProvider byteBufferProvider, CompressionStrategy.Decompressor decompressor) {
        ByteBuffer masterByteBuffer = originalByteBuffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
        int blockIndexSize = masterByteBuffer.getInt();
        ByteBuffer blockIndexBuffer = masterByteBuffer.asReadOnlyBuffer().order(masterByteBuffer.order());
        blockIndexBuffer.limit(blockIndexBuffer.position() + blockIndexSize);
        masterByteBuffer.position(masterByteBuffer.position() + blockIndexSize);
        int dataStreamSize = masterByteBuffer.getInt();
        ByteBuffer compressedBlockStreamByteBuffer = masterByteBuffer.asReadOnlyBuffer().order(masterByteBuffer.order());
        compressedBlockStreamByteBuffer.limit(compressedBlockStreamByteBuffer.position() + dataStreamSize);
        Closer closer = Closer.create();
        ResourceHolder<ByteBuffer> byteBufferResourceHolder = byteBufferProvider.get();
        closer.register(byteBufferResourceHolder);
        return new BlockCompressedPayloadReader(new IntIndexView(blockIndexBuffer), compressedBlockStreamByteBuffer, (ByteBuffer)byteBufferResourceHolder.get(), decompressor, closer);
    }

    public ByteBuffer read(long uncompressedStart, int size) {
        if (size == 0) {
            return NULL_CELL;
        }
        Preconditions.checkArgument((uncompressedStart + (long)size < this.maxValidUncompressedOffset ? 1 : 0) != 0);
        int blockNumber = (int)(uncompressedStart / (long)this.blockSize);
        int blockOffset = (int)(uncompressedStart % (long)this.blockSize);
        ByteBuffer currentUncompressedBlock = this.getUncompressedBlock(blockNumber);
        currentUncompressedBlock.position(blockOffset);
        if (size <= currentUncompressedBlock.remaining()) {
            ByteBuffer resultByteBuffer = currentUncompressedBlock.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
            resultByteBuffer.limit(blockOffset + size);
            return resultByteBuffer;
        }
        byte[] payload = this.readMultiBlock(size, blockNumber, blockOffset);
        return ByteBuffer.wrap(payload).order(ByteOrder.nativeOrder());
    }

    @Nonnull
    private byte[] readMultiBlock(int size, int blockNumber, int blockOffset) {
        int readSizeBytes;
        byte[] payload = new byte[size];
        int bytesRead = 0;
        do {
            ByteBuffer currentUncompressedBlock = this.getUncompressedBlock(blockNumber);
            currentUncompressedBlock.position(blockOffset);
            readSizeBytes = Math.min(size - bytesRead, currentUncompressedBlock.remaining());
            currentUncompressedBlock.get(payload, bytesRead, readSizeBytes);
            ++blockNumber;
            blockOffset = 0;
        } while ((bytesRead += readSizeBytes) < size);
        return payload;
    }

    private ByteBuffer getUncompressedBlock(int blockNumber) {
        if (this.currentUncompressedBlockNumber != blockNumber) {
            IntIndexView.EntrySpan span = this.blockIndexView.getEntrySpan(blockNumber);
            ByteBuffer compressedBlock = this.compressedBlocksByteBuffer.asReadOnlyBuffer().order(this.compressedBlocksByteBuffer.order());
            compressedBlock.position(compressedBlock.position() + span.getStart());
            compressedBlock.limit(compressedBlock.position() + span.getSize());
            this.uncompressedByteBuffer.clear();
            this.decompressor.decompress(compressedBlock, span.getSize(), this.uncompressedByteBuffer);
            this.currentUncompressedBlockNumber = blockNumber;
        }
        return this.uncompressedByteBuffer;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

