/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadReader;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.CellIndexReader;
import org.apache.druid.segment.serde.cell.NativeClearedByteBufferProvider;
import org.apache.druid.segment.serde.cell.PayloadEntrySpan;

public class CellReader
implements Closeable {
    private final CellIndexReader cellIndexReader;
    private final BlockCompressedPayloadReader dataReader;
    private final Closer closer;

    private CellReader(CellIndexReader cellIndexReader, BlockCompressedPayloadReader dataReader, Closer closer) {
        this.cellIndexReader = cellIndexReader;
        this.dataReader = dataReader;
        this.closer = closer;
    }

    public ByteBuffer getCell(int rowNumber) {
        PayloadEntrySpan payloadEntrySpan = this.cellIndexReader.getEntrySpan(rowNumber);
        ByteBuffer payload = this.dataReader.read(payloadEntrySpan.getStart(), payloadEntrySpan.getSize());
        return payload;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    public static Builder builder(ByteBuffer originalByteBuffer) {
        return new Builder(originalByteBuffer);
    }

    public static class Builder {
        private final ByteBuffer cellIndexBuffer;
        private final ByteBuffer dataStorageBuffer;
        private CompressionStrategy compressionStrategy = CompressionStrategy.LZ4;
        private ByteBufferProvider byteBufferProvider = NativeClearedByteBufferProvider.INSTANCE;

        public Builder(ByteBuffer originalByteBuffer) {
            ByteBuffer masterByteBuffer = originalByteBuffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
            int cellIndexSize = masterByteBuffer.getInt();
            this.cellIndexBuffer = masterByteBuffer.asReadOnlyBuffer().order(masterByteBuffer.order());
            this.cellIndexBuffer.limit(this.cellIndexBuffer.position() + cellIndexSize);
            masterByteBuffer.position(masterByteBuffer.position() + cellIndexSize);
            int dataStorageSize = masterByteBuffer.getInt();
            this.dataStorageBuffer = masterByteBuffer.asReadOnlyBuffer().order(masterByteBuffer.order());
            this.dataStorageBuffer.limit(this.dataStorageBuffer.position() + dataStorageSize);
        }

        public Builder setCompressionStrategy(CompressionStrategy compressionStrategy) {
            this.compressionStrategy = compressionStrategy;
            return this;
        }

        public Builder setByteBufferProvider(ByteBufferProvider byteBufferProvider) {
            this.byteBufferProvider = byteBufferProvider;
            return this;
        }

        public CellReader build() {
            Closer closer = Closer.create();
            CellIndexReader cellIndexReader = new CellIndexReader(BlockCompressedPayloadReader.create(this.cellIndexBuffer, this.byteBufferProvider, this.compressionStrategy.getDecompressor()));
            BlockCompressedPayloadReader dataReader = BlockCompressedPayloadReader.create(this.dataStorageBuffer, this.byteBufferProvider, this.compressionStrategy.getDecompressor());
            closer.register((Closeable)cellIndexReader);
            closer.register((Closeable)dataReader);
            CellReader cellReader = new CellReader(cellIndexReader, dataReader, closer);
            return cellReader;
        }
    }
}

