/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.collections.ResourceHolder;
import org.junit.Assert;
import org.junit.Test;

public class CloseableResourceHolderTest {
    @Test
    public void testCloseableResourceHolder() {
        AtomicLong closeCounter = new AtomicLong();
        Closeable closeable = closeCounter::incrementAndGet;
        ResourceHolder holder = ResourceHolder.fromCloseable((Closeable)closeable);
        Assert.assertSame((Object)closeable, (Object)holder.get());
        holder.close();
        Assert.assertEquals((long)1L, (long)closeCounter.get());
        holder.close();
        Assert.assertEquals((long)1L, (long)closeCounter.get());
        Assert.assertThrows(IllegalStateException.class, () -> ((ResourceHolder)holder).get());
    }
}

