/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import java.util.List;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.ConfigManagerConfig;
import org.apache.druid.common.config.ConfigSerde;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.metadata.MetadataCASUpdate;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigManagerTest {
    private static final String CONFIG_KEY = "configX";
    private static final String TABLE_NAME = "config_table";
    private static final byte[] OLD_CONFIG = new byte[]{1, 2, 3};
    private static final TestConfig NEW_CONFIG = new TestConfig("2", "y", 2);
    @Mock
    private MetadataStorageConnector mockDbConnector;
    @Mock
    private MetadataStorageTablesConfig mockMetadataStorageTablesConfig;
    @Mock
    private AuditManager mockAuditManager;
    @Mock
    private ConfigManagerConfig mockConfigManagerConfig;
    private ConfigSerde<TestConfig> configConfigSerdeFromClass;
    private ConfigManager configManager;
    private JacksonConfigManager jacksonConfigManager;

    @Before
    public void setup() {
        Mockito.when((Object)this.mockMetadataStorageTablesConfig.getConfigTable()).thenReturn((Object)TABLE_NAME);
        Mockito.when((Object)this.mockConfigManagerConfig.getPollDuration()).thenReturn((Object)new Period());
        this.configManager = new ConfigManager(this.mockDbConnector, Suppliers.ofInstance((Object)this.mockMetadataStorageTablesConfig), Suppliers.ofInstance((Object)this.mockConfigManagerConfig));
        this.jacksonConfigManager = new JacksonConfigManager(this.configManager, new ObjectMapper(), new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL), this.mockAuditManager);
        this.configConfigSerdeFromClass = this.jacksonConfigManager.create(TestConfig.class, null);
    }

    @Test
    public void testSetNewObjectIsNull() {
        ConfigManager.SetResult setResult = this.configManager.set(CONFIG_KEY, this.configConfigSerdeFromClass, null);
        Assert.assertFalse((boolean)setResult.isOk());
        Assert.assertFalse((boolean)setResult.isRetryable());
        Assert.assertTrue((boolean)(setResult.getException() instanceof IllegalAccessException));
    }

    @Test
    public void testSetConfigManagerNotStarted() {
        ConfigManager.SetResult setResult = this.configManager.set(CONFIG_KEY, this.configConfigSerdeFromClass, (Object)NEW_CONFIG);
        Assert.assertFalse((boolean)setResult.isOk());
        Assert.assertFalse((boolean)setResult.isRetryable());
        Assert.assertTrue((boolean)(setResult.getException() instanceof IllegalStateException));
    }

    @Test
    public void testSetOldObjectNullShouldInsertWithoutSwap() {
        this.configManager.start();
        ConfigManager.SetResult setResult = this.configManager.set(CONFIG_KEY, this.configConfigSerdeFromClass, null, (Object)NEW_CONFIG);
        Assert.assertTrue((boolean)setResult.isOk());
        ((MetadataStorageConnector)Mockito.verify((Object)this.mockDbConnector)).insertOrUpdate((String)ArgumentMatchers.eq((Object)TABLE_NAME), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)CONFIG_KEY), (byte[])ArgumentMatchers.any(byte[].class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDbConnector});
    }

    @Test
    public void testSetOldObjectNotNullShouldSwap() {
        Mockito.when((Object)this.mockConfigManagerConfig.isEnableCompareAndSwap()).thenReturn((Object)true);
        Mockito.when((Object)this.mockDbConnector.compareAndSwap((List)ArgumentMatchers.any(List.class))).thenReturn((Object)true);
        ArgumentCaptor updateCaptor = ArgumentCaptor.forClass(List.class);
        this.configManager.start();
        ConfigManager.SetResult setResult = this.configManager.set(CONFIG_KEY, this.configConfigSerdeFromClass, OLD_CONFIG, (Object)NEW_CONFIG);
        Assert.assertTrue((boolean)setResult.isOk());
        ((MetadataStorageConnector)Mockito.verify((Object)this.mockDbConnector)).compareAndSwap((List)updateCaptor.capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDbConnector});
        Assert.assertEquals((long)1L, (long)((List)updateCaptor.getValue()).size());
        Assert.assertEquals((Object)TABLE_NAME, (Object)((MetadataCASUpdate)((List)updateCaptor.getValue()).get(0)).getTableName());
        Assert.assertEquals((Object)"name", (Object)((MetadataCASUpdate)((List)updateCaptor.getValue()).get(0)).getKeyColumn());
        Assert.assertEquals((Object)"payload", (Object)((MetadataCASUpdate)((List)updateCaptor.getValue()).get(0)).getValueColumn());
        Assert.assertEquals((Object)CONFIG_KEY, (Object)((MetadataCASUpdate)((List)updateCaptor.getValue()).get(0)).getKey());
        Assert.assertArrayEquals((byte[])OLD_CONFIG, (byte[])((MetadataCASUpdate)((List)updateCaptor.getValue()).get(0)).getOldValue());
        Assert.assertArrayEquals((byte[])this.configConfigSerdeFromClass.serialize((Object)NEW_CONFIG), (byte[])((MetadataCASUpdate)((List)updateCaptor.getValue()).get(0)).getNewValue());
    }

    @Test
    public void testSetOldObjectNotNullButCompareAndSwapDisabledShouldInsertWithoutSwap() {
        Mockito.when((Object)this.mockConfigManagerConfig.isEnableCompareAndSwap()).thenReturn((Object)false);
        this.configManager.start();
        ConfigManager.SetResult setResult = this.configManager.set(CONFIG_KEY, this.configConfigSerdeFromClass, OLD_CONFIG, (Object)NEW_CONFIG);
        Assert.assertTrue((boolean)setResult.isOk());
        ((MetadataStorageConnector)Mockito.verify((Object)this.mockDbConnector)).insertOrUpdate((String)ArgumentMatchers.eq((Object)TABLE_NAME), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)CONFIG_KEY), (byte[])ArgumentMatchers.any(byte[].class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDbConnector});
    }

    static class TestConfig {
        private final String version;
        private final String settingString;
        private final int settingInt;

        @JsonCreator
        public TestConfig(@JsonProperty(value="version") String version, @JsonProperty(value="settingString") String settingString, @JsonProperty(value="settingInt") int settingInt) {
            this.version = version;
            this.settingString = settingString;
            this.settingInt = settingInt;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSettingString() {
            return this.settingString;
        }

        public int getSettingInt() {
            return this.settingInt;
        }
    }
}

