/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.ConfigSerde;
import org.apache.druid.common.config.JacksonConfigManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class JacksonConfigManagerTest {
    @Mock
    private ConfigManager mockConfigManager;
    @Mock
    private AuditManager mockAuditManager;
    private JacksonConfigManager jacksonConfigManager;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() {
        this.jacksonConfigManager = new JacksonConfigManager(this.mockConfigManager, new ObjectMapper(), new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL), this.mockAuditManager);
    }

    @Test
    public void testSerializeToStringWithSkipNullTrue() {
        ConfigSerde configConfigSerdeFromTypeReference = this.jacksonConfigManager.create((TypeReference)new TypeReference<TestConfig>(){}, null);
        ConfigSerde configConfigSerdeFromClass = this.jacksonConfigManager.create(TestConfig.class, null);
        TestConfig config = new TestConfig("version", null, 3);
        String actual = configConfigSerdeFromTypeReference.serializeToString((Object)config, true);
        Assert.assertEquals((Object)"{\"version\":\"version\",\"settingInt\":3}", (Object)actual);
        actual = configConfigSerdeFromClass.serializeToString((Object)config, true);
        Assert.assertEquals((Object)"{\"version\":\"version\",\"settingInt\":3}", (Object)actual);
    }

    @Test
    public void testSerializeToStringWithSkipNullFalse() {
        ConfigSerde configConfigSerdeFromTypeReference = this.jacksonConfigManager.create((TypeReference)new TypeReference<TestConfig>(){}, null);
        ConfigSerde configConfigSerdeFromClass = this.jacksonConfigManager.create(TestConfig.class, null);
        TestConfig config = new TestConfig("version", null, 3);
        String actual = configConfigSerdeFromTypeReference.serializeToString((Object)config, false);
        Assert.assertEquals((Object)"{\"version\":\"version\",\"settingString\":null,\"settingInt\":3}", (Object)actual);
        actual = configConfigSerdeFromClass.serializeToString((Object)config, false);
        Assert.assertEquals((Object)"{\"version\":\"version\",\"settingString\":null,\"settingInt\":3}", (Object)actual);
    }

    @Test
    public void testSerializeToStringWithInvalidConfigForConfigSerdeFromTypeReference() {
        ConfigSerde configConfigSerdeFromTypeReference = this.jacksonConfigManager.create((TypeReference)new TypeReference<ClassThatJacksonCannotSerialize>(){}, null);
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("InvalidDefinitionException");
        configConfigSerdeFromTypeReference.serializeToString((Object)new ClassThatJacksonCannotSerialize(), false);
    }

    @Test
    public void testSerializeToStringWithInvalidConfigForConfigSerdeFromClass() {
        ConfigSerde configConfigSerdeFromClass = this.jacksonConfigManager.create(ClassThatJacksonCannotSerialize.class, null);
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("InvalidDefinitionException");
        configConfigSerdeFromClass.serializeToString((Object)new ClassThatJacksonCannotSerialize(), false);
    }

    @Test
    public void testSet() {
        String key = "key";
        TestConfig val = new TestConfig("version", "string", 3);
        AuditInfo auditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        this.jacksonConfigManager.set(key, (Object)val, auditInfo);
        ArgumentCaptor configSerdeCapture = ArgumentCaptor.forClass(ConfigSerde.class);
        ((AuditManager)Mockito.verify((Object)this.mockAuditManager)).doAudit((String)ArgumentMatchers.eq((Object)key), (String)ArgumentMatchers.eq((Object)key), (AuditInfo)ArgumentMatchers.eq((Object)auditInfo), ArgumentMatchers.eq((Object)val), (ConfigSerde)configSerdeCapture.capture());
        Assert.assertNotNull((Object)configSerdeCapture.getValue());
    }

    @Test
    public void testConvertByteToConfigWithNullConfigInByte() {
        TestConfig defaultExpected = new TestConfig("version", null, 3);
        TestConfig actual = (TestConfig)this.jacksonConfigManager.convertByteToConfig(null, TestConfig.class, (Object)defaultExpected);
        Assert.assertEquals((Object)defaultExpected, (Object)actual);
    }

    @Test
    public void testConvertByteToConfigWithNonNullConfigInByte() {
        ConfigSerde configConfigSerdeFromTypeReference = this.jacksonConfigManager.create((TypeReference)new TypeReference<TestConfig>(){}, null);
        TestConfig defaultConfig = new TestConfig("version", null, 3);
        TestConfig expectedConfig = new TestConfig("version2", null, 5);
        byte[] expectedConfigInByte = configConfigSerdeFromTypeReference.serialize((Object)expectedConfig);
        TestConfig actual = (TestConfig)this.jacksonConfigManager.convertByteToConfig(expectedConfigInByte, TestConfig.class, (Object)defaultConfig);
        Assert.assertEquals((Object)expectedConfig, (Object)actual);
    }

    static class ClassThatJacksonCannotSerialize {
        ClassThatJacksonCannotSerialize() {
        }
    }

    static class TestConfig {
        private final String version;
        private final String settingString;
        private final int settingInt;

        @JsonCreator
        public TestConfig(@JsonProperty(value="version") String version, @JsonProperty(value="settingString") String settingString, @JsonProperty(value="settingInt") int settingInt) {
            this.version = version;
            this.settingString = settingString;
            this.settingInt = settingInt;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSettingString() {
            return this.settingString;
        }

        public int getSettingInt() {
            return this.settingInt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestConfig config = (TestConfig)o;
            return this.settingInt == config.settingInt && Objects.equals(this.version, config.version) && Objects.equals(this.settingString, config.settingString);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.settingString, this.settingInt);
        }
    }
}

