/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.config;

import org.apache.druid.common.config.NullHandling;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NullHandlingTest {
    @BeforeClass
    public static void setUpClass() {
        NullHandling.initializeForTests();
    }

    @Test
    public void test_defaultValueForClass_float() {
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? Float.valueOf(0.0f) : null), (Object)NullHandling.defaultValueForClass(Float.class));
    }

    @Test
    public void test_defaultValueForClass_double() {
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? Double.valueOf(0.0) : null), (Object)NullHandling.defaultValueForClass(Double.class));
    }

    @Test
    public void test_defaultValueForClass_integer() {
        Assert.assertNull((Object)NullHandling.defaultValueForClass(Integer.class));
    }

    @Test
    public void test_defaultValueForClass_long() {
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? Long.valueOf(0L) : null), (Object)NullHandling.defaultValueForClass(Long.class));
    }

    @Test
    public void test_defaultValueForClass_number() {
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? Double.valueOf(0.0) : null), (Object)NullHandling.defaultValueForClass(Number.class));
    }

    @Test
    public void test_defaultValueForClass_string() {
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? "" : null), (Object)NullHandling.defaultValueForClass(String.class));
    }

    @Test
    public void test_defaultValueForClass_object() {
        Assert.assertNull((Object)NullHandling.defaultValueForClass(Object.class));
    }

    @Test
    public void test_ignoreNullsStrings() {
        try {
            NullHandling.initializeForTestsWithValues((Boolean)false, (Boolean)true);
            Assert.assertFalse((boolean)NullHandling.ignoreNullsForStringCardinality());
            NullHandling.initializeForTestsWithValues((Boolean)true, (Boolean)false);
            Assert.assertFalse((boolean)NullHandling.ignoreNullsForStringCardinality());
        }
        finally {
            NullHandling.initializeForTests();
        }
    }
}

