/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.guava;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BinaryOperator;
import org.apache.druid.common.guava.CombiningSequence;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.junit.Assert;
import org.junit.Test;

public class ComplexSequenceTest {
    private static final BinaryOperator<Integer> PLUS_NULLABLE = (arg1, arg2) -> {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        return arg1 + arg2;
    };

    @Test
    public void testComplexSequence() {
        Sequence<Integer> complex = this.concat(this.combine(this.simple(3)), this.combine(this.simple(5)));
        this.check("[3, 5]", complex);
        complex = this.combine(complex);
        this.check("[8]", complex);
        complex = this.concat(complex, this.concat(this.combine(this.simple(2, 4)), this.simple(3, 5)));
        this.check("[8, 6, 3, 5]", complex);
        complex = this.combine(complex);
        this.check("[22]", complex);
        this.check("[22]", this.concat(complex, this.simple(new int[0])));
    }

    private void check(String expected, Sequence<Integer> complex) {
        List combined = complex.toList();
        Assert.assertEquals((Object)expected, (Object)combined.toString());
        Yielder yielder = complex.toYielder(null, (YieldingAccumulator)new YieldingAccumulator<Integer, Integer>(){

            public Integer accumulate(Integer accumulated, Integer in) {
                this.yield();
                return in;
            }
        });
        ArrayList<Object> combinedByYielder = new ArrayList<Object>();
        while (!yielder.isDone()) {
            combinedByYielder.add(yielder.get());
            yielder = yielder.next(null);
        }
        Assert.assertEquals((Object)expected, (Object)((Object)combinedByYielder).toString());
    }

    private Sequence<Integer> simple(int ... values) {
        return Sequences.simple((Iterable)Ints.asList((int[])values));
    }

    private Sequence<Integer> combine(Sequence<Integer> sequence) {
        return CombiningSequence.create(sequence, (Comparator)Comparators.alwaysEqual(), PLUS_NULLABLE);
    }

    private Sequence<Integer> concat(Sequence<Integer> ... sequences) {
        return Sequences.concat(Arrays.asList(sequences));
    }
}

