/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.guava;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class FutureUtilsTest {
    private ExecutorService exec;

    @Before
    public void setUp() {
        this.exec = Execs.singleThreaded((String)(StringUtils.encodeForFormat((String)this.getClass().getName()) + "-%d"));
    }

    @After
    public void tearDown() {
        if (this.exec != null) {
            this.exec.shutdownNow();
            this.exec = null;
        }
    }

    @Test
    public void test_get_ok() throws Exception {
        String s = (String)FutureUtils.get((ListenableFuture)Futures.immediateFuture((Object)"x"), (boolean)true);
        Assert.assertEquals((Object)"x", (Object)s);
    }

    @Test
    public void test_get_failed() {
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> FutureUtils.get((ListenableFuture)Futures.immediateFailedFuture((Throwable)new ISE("oh no", new Object[0])), (boolean)true));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"oh no")));
    }

    @Test
    public void test_getUnchecked_interrupted_cancelOnInterrupt() throws InterruptedException {
        SettableFuture neverGoingToResolve = SettableFuture.create();
        AtomicReference exceptionFromOtherThread = new AtomicReference();
        CountDownLatch runningLatch = new CountDownLatch(1);
        Future<?> execResult = this.exec.submit(() -> {
            runningLatch.countDown();
            try {
                FutureUtils.getUnchecked((ListenableFuture)neverGoingToResolve, (boolean)true);
            }
            catch (Throwable t) {
                exceptionFromOtherThread.set(t);
            }
        });
        runningLatch.await();
        Assert.assertTrue((boolean)execResult.cancel(true));
        this.exec.shutdown();
        Assert.assertTrue((boolean)this.exec.awaitTermination(1L, TimeUnit.MINUTES));
        this.exec = null;
        Assert.assertTrue((boolean)neverGoingToResolve.isCancelled());
        Throwable e = (Throwable)exceptionFromOtherThread.get();
        MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RuntimeException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(InterruptedException.class));
    }

    @Test
    public void test_getUnchecked_interrupted_dontCancelOnInterrupt() throws InterruptedException {
        SettableFuture neverGoingToResolve = SettableFuture.create();
        AtomicReference exceptionFromOtherThread = new AtomicReference();
        CountDownLatch runningLatch = new CountDownLatch(1);
        Future<?> execResult = this.exec.submit(() -> {
            runningLatch.countDown();
            try {
                FutureUtils.getUnchecked((ListenableFuture)neverGoingToResolve, (boolean)false);
            }
            catch (Throwable t) {
                exceptionFromOtherThread.set(t);
            }
        });
        runningLatch.await();
        Assert.assertTrue((boolean)execResult.cancel(true));
        this.exec.shutdown();
        Assert.assertTrue((boolean)this.exec.awaitTermination(1L, TimeUnit.MINUTES));
        this.exec = null;
        Assert.assertFalse((boolean)neverGoingToResolve.isCancelled());
        Assert.assertFalse((boolean)neverGoingToResolve.isDone());
        Throwable e = (Throwable)exceptionFromOtherThread.get();
        MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RuntimeException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(InterruptedException.class));
    }

    @Test
    public void test_getUnchecked_ok() {
        String s = (String)FutureUtils.getUnchecked((ListenableFuture)Futures.immediateFuture((Object)"x"), (boolean)true);
        Assert.assertEquals((Object)"x", (Object)s);
    }

    @Test
    public void test_getUnchecked_failed() {
        RuntimeException e = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> FutureUtils.getUnchecked((ListenableFuture)Futures.immediateFailedFuture((Throwable)new ISE("oh no", new Object[0])), (boolean)true));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"oh no")));
    }

    @Test
    public void test_getUncheckedImmediately_ok() {
        String s = (String)FutureUtils.getUncheckedImmediately((ListenableFuture)Futures.immediateFuture((Object)"x"));
        Assert.assertEquals((Object)"x", (Object)s);
    }

    @Test
    public void test_getUncheckedImmediately_failed() {
        RuntimeException e = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> FutureUtils.getUncheckedImmediately((ListenableFuture)Futures.immediateFailedFuture((Throwable)new ISE("oh no", new Object[0]))));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"oh no")));
    }

    @Test
    public void test_getUncheckedImmediately_notResolved() {
        Assert.assertThrows(IllegalStateException.class, () -> FutureUtils.getUncheckedImmediately((ListenableFuture)SettableFuture.create()));
    }

    @Test
    public void test_transform() throws Exception {
        Assert.assertEquals((Object)"xy", (Object)FutureUtils.transform((ListenableFuture)Futures.immediateFuture((Object)"x"), s -> s + "y").get());
    }

    @Test
    public void test_transformAsync() throws Exception {
        Assert.assertEquals((Object)"xy", (Object)FutureUtils.transformAsync((ListenableFuture)Futures.immediateFuture((Object)"x"), s -> Futures.immediateFuture((Object)(s + "y"))).get());
    }

    @Test
    public void test_coalesce_allOk() throws Exception {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        futures.add(Futures.immediateFuture((Object)"foo"));
        futures.add(Futures.immediateFuture((Object)"bar"));
        futures.add(Futures.immediateFuture(null));
        Assert.assertEquals((Object)ImmutableList.of((Object)Either.value((Object)"foo"), (Object)Either.value((Object)"bar"), (Object)Either.value(null)), (Object)FutureUtils.coalesce(futures).get());
    }

    @Test
    public void test_coalesce_inputError() throws Exception {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        ISE e = new ISE("oops", new Object[0]);
        futures.add(Futures.immediateFuture((Object)"foo"));
        futures.add(Futures.immediateFailedFuture((Throwable)e));
        futures.add(Futures.immediateFuture(null));
        Assert.assertEquals((Object)ImmutableList.of((Object)Either.value((Object)"foo"), (Object)Either.error((Object)((Object)e)), (Object)Either.value(null)), (Object)FutureUtils.coalesce(futures).get());
    }

    @Test
    public void test_coalesce_inputCanceled() throws Exception {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        futures.add(Futures.immediateFuture((Object)"foo"));
        futures.add(Futures.immediateCancelledFuture());
        futures.add(Futures.immediateFuture(null));
        List results = (List)FutureUtils.coalesce(futures).get();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((Object)Either.value((Object)"foo"), results.get(0));
        Assert.assertTrue((boolean)((Either)results.get(1)).isError());
        Assert.assertEquals((Object)Either.value(null), results.get(2));
        MatcherAssert.assertThat((Object)((Either)results.get(1)).error(), (Matcher)CoreMatchers.instanceOf(CancellationException.class));
    }

    @Test
    public void test_coalesce_timeout() {
        ArrayList<Object> futures = new ArrayList<Object>();
        SettableFuture unresolvedFuture = SettableFuture.create();
        futures.add(Futures.immediateFuture((Object)"foo"));
        futures.add(unresolvedFuture);
        futures.add(Futures.immediateFuture(null));
        ListenableFuture coalesced = FutureUtils.coalesce(futures);
        Assert.assertThrows(TimeoutException.class, () -> {
            List cfr_ignored_0 = (List)coalesced.get(10L, TimeUnit.MILLISECONDS);
        });
    }

    @Test
    public void test_coalesce_cancel() {
        ArrayList<Object> futures = new ArrayList<Object>();
        SettableFuture unresolvedFuture = SettableFuture.create();
        futures.add(Futures.immediateFuture((Object)"foo"));
        futures.add(unresolvedFuture);
        futures.add(Futures.immediateFuture(null));
        ListenableFuture coalesced = FutureUtils.coalesce(futures);
        coalesced.cancel(true);
        Assert.assertTrue((boolean)coalesced.isCancelled());
        Assert.assertTrue((boolean)unresolvedFuture.isCancelled());
    }

    @Test
    public void test_futureWithBaggage_ok() throws ExecutionException, InterruptedException {
        AtomicLong baggageHandled = new AtomicLong(0L);
        SettableFuture future = SettableFuture.create();
        ListenableFuture futureWithBaggage = FutureUtils.futureWithBaggage((ListenableFuture)future, baggageHandled::incrementAndGet);
        future.set((Object)3L);
        Assert.assertEquals((long)3L, (long)((Long)futureWithBaggage.get()));
        Assert.assertEquals((long)1L, (long)baggageHandled.get());
    }

    @Test
    public void test_futureWithBaggage_failure() {
        AtomicLong baggageHandled = new AtomicLong(0L);
        SettableFuture future = SettableFuture.create();
        ListenableFuture futureWithBaggage = FutureUtils.futureWithBaggage((ListenableFuture)future, baggageHandled::incrementAndGet);
        future.setException((Throwable)new ISE("error!", new Object[0]));
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> futureWithBaggage.get());
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"error!")));
        Assert.assertEquals((long)1L, (long)baggageHandled.get());
    }
}

