/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.utils;

import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IdUtilsTest {
    private static final String THINGO = "thingToValidate";
    public static final String VALID_ID_CHARS = "alpha123..*~!@#&%^&*()-+ \u0420\u043e\u0441\u0441\u0438\u044f\\ \ud55c\uad6d \u4e2d\u56fd!";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testValidIdName() {
        IdUtils.validateId((String)THINGO, (String)VALID_ID_CHARS);
    }

    @Test
    public void testInvalidNull() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot be null or empty. Please provide a thingToValidate.");
        IdUtils.validateId((String)THINGO, null);
    }

    @Test
    public void testInvalidEmpty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot be null or empty. Please provide a thingToValidate.");
        IdUtils.validateId((String)THINGO, (String)"");
    }

    @Test
    public void testInvalidSlashes() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot contain the '/' character.");
        IdUtils.validateId((String)THINGO, (String)"/paths/are/bad/since/we/make/files/from/stuff");
    }

    @Test
    public void testInvalidLeadingDot() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot start with the '.' character.");
        IdUtils.validateId((String)THINGO, (String)"./nice/try");
    }

    @Test
    public void testInvalidSpacesRegexTabs() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot contain whitespace character except space.");
        IdUtils.validateId((String)THINGO, (String)"spaces\tare\tbetter\tthan\ttabs\twhich\tare\tillegal");
    }

    @Test
    public void testInvalidSpacesRegexNewline() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot contain whitespace character except space.");
        IdUtils.validateId((String)THINGO, (String)"new\nline");
    }

    @Test
    public void testInvalidSpacesRegexCarriageReturn() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot contain whitespace character except space.");
        IdUtils.validateId((String)THINGO, (String)"does\rexist\rby\ritself");
    }

    @Test
    public void testInvalidSpacesRegexLineTabulation() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot contain whitespace character except space.");
        IdUtils.validateId((String)THINGO, (String)"what\u000bis line tabulation");
    }

    @Test
    public void testInvalidSpacesRegexFormFeed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot contain whitespace character except space.");
        IdUtils.validateId((String)THINGO, (String)"form\ffeed?");
    }

    @Test
    public void testInvalidUnprintableChars() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot contain character #129 (at position 4).");
        IdUtils.validateId((String)THINGO, (String)"form\u0081feed?");
    }

    @Test
    public void testInvalidEmojis() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("thingToValidate cannot contain character #55357 (at position 4).");
        IdUtils.validateId((String)THINGO, (String)"form\ud83d\udcaffeed?");
    }

    @Test
    public void testNewTaskIdWithoutInterval() {
        String id = IdUtils.newTaskId((String)"prefix", (String)"suffix", (DateTime)DateTimes.of((String)"2020-01-01"), (String)"type", (String)"datasource", null);
        String expected = String.join((CharSequence)"_", "prefix", "type", "datasource", "suffix", DateTimes.of((String)"2020-01-01").toString());
        Assert.assertEquals((Object)expected, (Object)id);
    }

    @Test
    public void testNewTaskIdWithInterval() {
        String id = IdUtils.newTaskId((String)"prefix", (String)"suffix", (DateTime)DateTimes.of((String)"2020-01-01"), (String)"type", (String)"datasource", (Interval)Intervals.of((String)"2020-01-01/2020-06-01"));
        String expected = String.join((CharSequence)"_", "prefix", "type", "datasource", "suffix", DateTimes.of((String)"2020-01-01").toString(), DateTimes.of((String)"2020-06-01").toString(), DateTimes.of((String)"2020-01-01").toString());
        Assert.assertEquals((Object)expected, (Object)id);
    }
}

