/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.MaxSizeSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.CloudObjectInputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.CloudObjectSplitWidget;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.MockSettings;
import org.mockito.Mockito;

public class CloudObjectInputSourceTest {
    private static final String SCHEME = "s3";
    private static final List<URI> URIS = Collections.singletonList(URI.create("s3://foo/bar/file.csv"));
    private static final List<URI> URIS2 = Arrays.asList(URI.create("s3://foo/bar/file.csv"), URI.create("s3://bar/foo/file2.parquet"));
    private static final List<URI> PREFIXES = Arrays.asList(URI.create("s3://foo/bar/"), URI.create("s3://bar/foo/"));
    private static final List<CloudObjectLocation> OBJECTS = Collections.singletonList(new CloudObjectLocation(URI.create("s3://foo/bar/file.csv")));
    private static final List<CloudObjectLocation> OBJECTS_BEFORE_GLOB = Arrays.asList(new CloudObjectLocation(URI.create("s3://foo/bar/file.csv")), new CloudObjectLocation(URI.create("s3://bar/foo/file2.parquet")));
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testGetUris() {
        CloudObjectInputSource inputSource = (CloudObjectInputSource)Mockito.mock(CloudObjectInputSource.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{SCHEME, URIS, null, null, null}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        Assert.assertEquals(URIS, (Object)inputSource.getUris());
    }

    @Test
    public void testGetPrefixes() {
        CloudObjectInputSource inputSource = (CloudObjectInputSource)Mockito.mock(CloudObjectInputSource.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{SCHEME, null, PREFIXES, null, null}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        Assert.assertEquals(PREFIXES, (Object)inputSource.getPrefixes());
    }

    @Test
    public void testGetObjectGlob() {
        CloudObjectInputSource inputSource = (CloudObjectInputSource)Mockito.mock(CloudObjectInputSource.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{SCHEME, URIS, null, null, "**.parquet"}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        Assert.assertEquals((Object)"**.parquet", (Object)inputSource.getObjectGlob());
    }

    @Test
    public void testInequality() {
        CloudObjectInputSource inputSource1 = (CloudObjectInputSource)Mockito.mock(CloudObjectInputSource.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{SCHEME, URIS, null, null, "**.parquet"}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        CloudObjectInputSource inputSource2 = (CloudObjectInputSource)Mockito.mock(CloudObjectInputSource.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{SCHEME, URIS, null, null, "**.csv"}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        Assert.assertEquals((Object)"**.parquet", (Object)inputSource1.getObjectGlob());
        Assert.assertEquals((Object)"**.csv", (Object)inputSource2.getObjectGlob());
        Assert.assertFalse((boolean)inputSource2.equals((Object)inputSource1));
    }

    @Test
    public void testWithUrisFilter() {
        CloudObjectInputSource inputSource = (CloudObjectInputSource)Mockito.mock(CloudObjectInputSource.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{SCHEME, URIS2, null, null, "**.csv"}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        Mockito.when((Object)inputSource.getSplitWidget()).thenReturn((Object)new MockSplitWidget());
        Stream splits = inputSource.createSplits((InputFormat)new JsonInputFormat(JSONPathSpec.DEFAULT, null, null, null, null), (SplitHintSpec)new MaxSizeSplitHintSpec(null, Integer.valueOf(1)));
        List returnedLocations = (List)splits.map(InputSplit::get).collect(Collectors.toList()).get(0);
        List returnedLocationUris = returnedLocations.stream().map(object -> object.toUri(SCHEME)).collect(Collectors.toList());
        Assert.assertEquals((Object)"**.csv", (Object)inputSource.getObjectGlob());
        Assert.assertEquals(URIS, returnedLocationUris);
    }

    @Test
    public void testWithUris() {
        CloudObjectInputSource inputSource = (CloudObjectInputSource)Mockito.mock(CloudObjectInputSource.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{SCHEME, URIS, null, null, null}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        Mockito.when((Object)inputSource.getSplitWidget()).thenReturn((Object)new MockSplitWidget());
        Stream splits = inputSource.createSplits((InputFormat)new JsonInputFormat(JSONPathSpec.DEFAULT, null, null, null, null), (SplitHintSpec)new MaxSizeSplitHintSpec(null, Integer.valueOf(1)));
        List returnedLocations = (List)splits.map(InputSplit::get).collect(Collectors.toList()).get(0);
        List returnedLocationUris = returnedLocations.stream().map(object -> object.toUri(SCHEME)).collect(Collectors.toList());
        Assert.assertEquals(null, (Object)inputSource.getObjectGlob());
        Assert.assertEquals(URIS, returnedLocationUris);
    }

    @Test
    public void testWithObjectsFilter() {
        CloudObjectInputSource inputSource = (CloudObjectInputSource)Mockito.mock(CloudObjectInputSource.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{SCHEME, null, null, OBJECTS_BEFORE_GLOB, "**.csv"}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        Mockito.when((Object)inputSource.getSplitWidget()).thenReturn((Object)new MockSplitWidget());
        Stream splits = inputSource.createSplits((InputFormat)new JsonInputFormat(JSONPathSpec.DEFAULT, null, null, null, null), (SplitHintSpec)new MaxSizeSplitHintSpec(null, Integer.valueOf(1)));
        List returnedLocations = (List)splits.map(InputSplit::get).collect(Collectors.toList()).get(0);
        List returnedLocationUris = returnedLocations.stream().map(object -> object.toUri(SCHEME)).collect(Collectors.toList());
        Assert.assertEquals((Object)"**.csv", (Object)inputSource.getObjectGlob());
        Assert.assertEquals(URIS, returnedLocationUris);
    }

    @Test
    public void testWithObjects() {
        CloudObjectInputSource inputSource = (CloudObjectInputSource)Mockito.mock(CloudObjectInputSource.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{SCHEME, null, null, OBJECTS, null}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        Mockito.when((Object)inputSource.getSplitWidget()).thenReturn((Object)new MockSplitWidget());
        Stream splits = inputSource.createSplits((InputFormat)new JsonInputFormat(JSONPathSpec.DEFAULT, null, null, null, null), (SplitHintSpec)new MaxSizeSplitHintSpec(null, Integer.valueOf(1)));
        List returnedLocations = (List)splits.map(InputSplit::get).collect(Collectors.toList()).get(0);
        Assert.assertEquals(null, (Object)inputSource.getObjectGlob());
        Assert.assertEquals(OBJECTS, (Object)returnedLocations);
    }

    @Test
    public void testGlobSubdirectories() {
        PathMatcher m = FileSystems.getDefault().getPathMatcher("glob:**.parquet");
        Assert.assertTrue((boolean)m.matches(Paths.get("db/date=2022-08-01/001.parquet", new String[0])));
        Assert.assertTrue((boolean)m.matches(Paths.get("db/date=2022-08-01/002.parquet", new String[0])));
        PathMatcher m2 = FileSystems.getDefault().getPathMatcher("glob:db/date=2022-08-01/*.parquet");
        Assert.assertTrue((boolean)m2.matches(Paths.get("db/date=2022-08-01/001.parquet", new String[0])));
        Assert.assertFalse((boolean)m2.matches(Paths.get("db/date=2022-08-01/_junk/0/001.parquet", new String[0])));
    }

    private static class MockSplitWidget
    implements CloudObjectSplitWidget {
        private MockSplitWidget() {
        }

        public Iterator<CloudObjectSplitWidget.LocationWithSize> getDescriptorIteratorForPrefixes(List<URI> prefixes) {
            throw new UnsupportedOperationException();
        }

        public long getObjectSize(CloudObjectLocation descriptor) {
            return 0L;
        }
    }
}

