/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CloudObjectLocationTest {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String SCHEME = "s3";
    private static final String BUCKET_NAME = "bucket";
    private static final CloudObjectLocation LOCATION = new CloudObjectLocation("bucket", "path/to/myobject");
    private static final CloudObjectLocation LOCATION_EXTRA_SLASHES = new CloudObjectLocation("bucket/", "/path/to/myobject");
    private static final CloudObjectLocation LOCATION_URLENCODE = new CloudObjectLocation("bucket", "path/to/myobject?question");
    private static final CloudObjectLocation LOCATION_NON_ASCII = new CloudObjectLocation("bucket", "p\u00c4th/t\u00f8/my\u00f8bject");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws Exception {
        Assert.assertEquals((Object)LOCATION, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)LOCATION), CloudObjectLocation.class));
        Assert.assertEquals((Object)LOCATION_EXTRA_SLASHES, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)LOCATION_EXTRA_SLASHES), CloudObjectLocation.class));
        Assert.assertEquals((Object)LOCATION_URLENCODE, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)LOCATION_URLENCODE), CloudObjectLocation.class));
        Assert.assertEquals((Object)LOCATION_NON_ASCII, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)LOCATION_NON_ASCII), CloudObjectLocation.class));
    }

    @Test
    public void testToUri() {
        Assert.assertEquals((Object)URI.create("s3://bucket/path/to/myobject"), (Object)LOCATION.toUri(SCHEME));
        Assert.assertEquals((Object)URI.create("s3://bucket/path/to/myobject"), (Object)LOCATION_EXTRA_SLASHES.toUri(SCHEME));
        Assert.assertEquals((Object)URI.create("s3://bucket/path/to/myobject%3Fquestion"), (Object)LOCATION_URLENCODE.toUri(SCHEME));
        Assert.assertEquals((Object)URI.create("s3://bucket/p%C3%84th/t%C3%B8/my%C3%B8bject"), (Object)LOCATION_NON_ASCII.toUri(SCHEME));
    }

    @Test
    public void testUriRoundTrip() {
        Assert.assertEquals((Object)LOCATION, (Object)new CloudObjectLocation(LOCATION.toUri(SCHEME)));
        Assert.assertEquals((Object)LOCATION_EXTRA_SLASHES, (Object)new CloudObjectLocation(LOCATION_EXTRA_SLASHES.toUri(SCHEME)));
        Assert.assertEquals((Object)LOCATION_URLENCODE, (Object)new CloudObjectLocation(LOCATION_URLENCODE.toUri(SCHEME)));
        Assert.assertEquals((Object)LOCATION_NON_ASCII, (Object)new CloudObjectLocation(LOCATION_NON_ASCII.toUri(SCHEME)));
    }

    @Test
    public void testBucketName() {
        this.expectedException.expect(IllegalArgumentException.class);
        CloudObjectLocation invalidBucket = new CloudObjectLocation("someB\u00dccket", "some/path");
        Assert.assertEquals((Object)invalidBucket, (Object)new CloudObjectLocation(invalidBucket.toUri(SCHEME)));
    }

    @Test
    public void testBucketNameWithoutUnderscores() {
        CloudObjectLocation gsValidBucket = new CloudObjectLocation(URI.create("gs://1test.bucket-value/path/to/path"));
        Assert.assertEquals((Object)"1test.bucket-value", (Object)gsValidBucket.getBucket());
        Assert.assertEquals((Object)"path/to/path", (Object)gsValidBucket.getPath());
        CloudObjectLocation s3ValidBucket = new CloudObjectLocation(URI.create("s3://2test.bucket-value/path/to/path"));
        Assert.assertEquals((Object)"2test.bucket-value", (Object)s3ValidBucket.getBucket());
        Assert.assertEquals((Object)"path/to/path", (Object)s3ValidBucket.getPath());
    }

    @Test
    public void testBucketNameWithUnderscores() {
        CloudObjectLocation gsValidBucket = new CloudObjectLocation(URI.create("gs://test_bucket/path/to/path"));
        Assert.assertEquals((Object)"test_bucket", (Object)gsValidBucket.getBucket());
        Assert.assertEquals((Object)"path/to/path", (Object)gsValidBucket.getPath());
        CloudObjectLocation s3ValidBucket = new CloudObjectLocation(URI.create("s3://test_bucket/path/to/path"));
        Assert.assertEquals((Object)"test_bucket", (Object)s3ValidBucket.getBucket());
        Assert.assertEquals((Object)"path/to/path", (Object)s3ValidBucket.getPath());
    }
}

