/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.DelimitedInputFormat;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DelimitedInputFormatTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        DelimitedInputFormat format = new DelimitedInputFormat(Collections.singletonList("a"), "|", "delim", null, Boolean.valueOf(true), 10);
        byte[] bytes = mapper.writeValueAsBytes((Object)format);
        DelimitedInputFormat fromJson = (DelimitedInputFormat)mapper.readValue(bytes, InputFormat.class);
        Assert.assertEquals((Object)format, (Object)fromJson);
    }

    @Test
    public void testTab() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Column[a\t] cannot have the delimiter[\t] in its name");
        new DelimitedInputFormat(Collections.singletonList("a\t"), ",", null, null, Boolean.valueOf(false), 0);
    }

    @Test
    public void testDelimiterAndListDelimiter() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot have same delimiter and list delimiter of [,]");
        new DelimitedInputFormat(Collections.singletonList("a\t"), ",", ",", null, Boolean.valueOf(false), 0);
    }

    @Test
    public void testCustomizeSeparator() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Column[a|] cannot have the delimiter[|] in its name");
        new DelimitedInputFormat(Collections.singletonList("a|"), ",", "|", null, Boolean.valueOf(false), 0);
    }

    @Test
    public void testFindColumnsFromHeaderWithColumnsReturningItsValue() {
        DelimitedInputFormat format = new DelimitedInputFormat(Collections.singletonList("a"), null, "delim", null, Boolean.valueOf(true), 0);
        Assert.assertTrue((boolean)format.isFindColumnsFromHeader());
    }

    @Test
    public void testFindColumnsFromHeaderWithMissingColumnsReturningItsValue() {
        DelimitedInputFormat format = new DelimitedInputFormat(null, null, "delim", null, Boolean.valueOf(true), 0);
        Assert.assertTrue((boolean)format.isFindColumnsFromHeader());
    }

    @Test
    public void testMissingFindColumnsFromHeaderWithMissingColumnsThrowingError() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("At least one of [Property{name='hasHeaderRow', value=null}");
        new DelimitedInputFormat(null, null, "delim", null, null, 0);
    }

    @Test
    public void testMissingFindColumnsFromHeaderWithColumnsReturningFalse() {
        DelimitedInputFormat format = new DelimitedInputFormat(Collections.singletonList("a"), null, "delim", null, null, 0);
        Assert.assertFalse((boolean)format.isFindColumnsFromHeader());
    }

    @Test
    public void testHasHeaderRowWithMissingFindColumnsThrowingError() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("At most one of [Property{name='hasHeaderRow', value=true}");
        new DelimitedInputFormat(null, null, "delim", Boolean.valueOf(true), Boolean.valueOf(false), 0);
    }

    @Test
    public void testHasHeaderRowWithMissingColumnsReturningItsValue() {
        DelimitedInputFormat format = new DelimitedInputFormat(null, null, "delim", Boolean.valueOf(true), null, 0);
        Assert.assertTrue((boolean)format.isFindColumnsFromHeader());
    }
}

