/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.impl.FastLineIterator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FastLineIteratorTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void setup() {
        NullHandling.initializeForTests();
    }

    @Test
    public void testNullInputThrows() {
        this.expectedException.expect(NullPointerException.class);
        new FastLineIterator(null);
    }

    @Test
    public void testEmptyInput() {
        byte[] input = new byte[]{};
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertFalse((boolean)iterator.hasNext());
        this.expectedException.expect(NoSuchElementException.class);
        iterator.next();
    }

    @Test
    public void testSoloCr() {
        byte[] input = "\r".getBytes(StandardCharsets.UTF_8);
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"\r", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSoloLf() {
        byte[] input = "\n".getBytes(StandardCharsets.UTF_8);
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testBackwardsLfCr() {
        byte[] input = "\n\r".getBytes(StandardCharsets.UTF_8);
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"", (Object)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"\r", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testForwardsSoloCrLf() {
        byte[] input = "\r\n".getBytes(StandardCharsets.UTF_8);
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSingleLine() {
        byte[] input = "abcd".getBytes(StandardCharsets.UTF_8);
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"abcd", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        input = "abcd\n".getBytes(StandardCharsets.UTF_8);
        iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"abcd", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        input = "abcd\r\n".getBytes(StandardCharsets.UTF_8);
        iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"abcd", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMultipleLines() {
        byte[] input = "abcd\ndefg\nhijk".getBytes(StandardCharsets.UTF_8);
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"abcd", (Object)iterator.next());
        Assert.assertEquals((Object)"defg", (Object)iterator.next());
        Assert.assertEquals((Object)"hijk", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testEmptyMiddleLine() {
        byte[] input = "abcd\n\nhijk\n".getBytes(StandardCharsets.UTF_8);
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"abcd", (Object)iterator.next());
        Assert.assertEquals((Object)"", (Object)iterator.next());
        Assert.assertEquals((Object)"hijk", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testEmptyLastLine() {
        byte[] input = "abcd\ndefg\nhijk\n".getBytes(StandardCharsets.UTF_8);
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"abcd", (Object)iterator.next());
        Assert.assertEquals((Object)"defg", (Object)iterator.next());
        Assert.assertEquals((Object)"hijk", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testOverlappingBuffer() {
        String line1 = RandomStringUtils.random((int)492);
        String line2 = RandomStringUtils.random((int)40);
        String line3 = RandomStringUtils.random((int)20);
        byte[] input = (line1 + "\n" + line2 + "\n" + line3 + "\n").getBytes(StandardCharsets.UTF_8);
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)line1, (Object)iterator.next());
        Assert.assertEquals((Object)line2, (Object)iterator.next());
        Assert.assertEquals((Object)line3, (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testLineLargerThanBufferSize() {
        String line1 = RandomStringUtils.random((int)1546);
        String line2 = RandomStringUtils.random((int)1039);
        String line3 = RandomStringUtils.random((int)521);
        byte[] input = (line1 + "\r\n" + line2 + "\r\n" + line3 + "\r\n").getBytes(StandardCharsets.UTF_8);
        FastLineIterator iterator = new FastLineIterator((InputStream)new ByteArrayInputStream(input));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)line1, (Object)iterator.next());
        Assert.assertEquals((Object)line2, (Object)iterator.next());
        Assert.assertEquals((Object)line3, (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

