/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.HttpInputSource;
import org.apache.druid.data.input.impl.HttpInputSourceConfig;
import org.apache.druid.metadata.DefaultPasswordProvider;
import org.apache.druid.metadata.PasswordProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HttpInputSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        HttpInputSourceConfig httpInputSourceConfig = new HttpInputSourceConfig(null);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(HttpInputSourceConfig.class, (Object)httpInputSourceConfig));
        HttpInputSource source = new HttpInputSource((List)ImmutableList.of((Object)URI.create("http://test.com/http-test")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), httpInputSourceConfig);
        byte[] json = mapper.writeValueAsBytes((Object)source);
        HttpInputSource fromJson = (HttpInputSource)mapper.readValue(json, InputSource.class);
        Assert.assertEquals((Object)source, (Object)fromJson);
    }

    @Test
    public void testConstructorAllowsOnlyDefaultProtocols() {
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("http:///")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), new HttpInputSourceConfig(null));
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("https:///")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), new HttpInputSourceConfig(null));
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Only [http, https] protocols are allowed");
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("my-protocol:///")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), new HttpInputSourceConfig(null));
    }

    @Test
    public void testConstructorAllowsOnlyCustomProtocols() {
        HttpInputSourceConfig customConfig = new HttpInputSourceConfig((Set)ImmutableSet.of((Object)"druid"));
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("druid:///")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), customConfig);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Only [druid] protocols are allowed");
        new HttpInputSource((List)ImmutableList.of((Object)URI.create("https:///")), "myName", (PasswordProvider)new DefaultPasswordProvider("myPassword"), customConfig);
    }
}

