/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.RegexInputFormat;
import org.junit.Assert;
import org.junit.Test;

public class RegexInputFormatTest {
    private final ObjectMapper mapper = new ObjectMapper();

    public RegexInputFormatTest() {
        this.mapper.registerSubtypes(new NamedType[]{new NamedType(RegexInputFormat.class, "regex")});
    }

    @Test
    public void testSerde() throws IOException {
        RegexInputFormat expected = new RegexInputFormat("//[^\\r\\n]*[\\r\\n]", "|", (List)ImmutableList.of((Object)"col1", (Object)"col2", (Object)"col3"));
        byte[] json = this.mapper.writeValueAsBytes((Object)expected);
        RegexInputFormat fromJson = (RegexInputFormat)this.mapper.readValue(json, InputFormat.class);
        Assert.assertEquals((Object)expected.getPattern(), (Object)fromJson.getPattern());
        Assert.assertEquals((Object)expected.getListDelimiter(), (Object)fromJson.getListDelimiter());
        Assert.assertEquals((Object)expected.getColumns(), (Object)fromJson.getColumns());
    }

    @Test
    public void testIgnoreCompiledPatternInJson() throws IOException {
        RegexInputFormat expected = new RegexInputFormat("//[^\\r\\n]*[\\r\\n]", "|", (List)ImmutableList.of((Object)"col1", (Object)"col2", (Object)"col3"));
        byte[] json = this.mapper.writeValueAsBytes((Object)expected);
        Map map = (Map)this.mapper.readValue(json, Map.class);
        Assert.assertFalse((boolean)map.containsKey("compiledPattern"));
    }
}

