/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.extendedset.intset;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import junit.framework.Assert;
import org.apache.druid.extendedset.intset.ConciseSet;
import org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.druid.extendedset.intset.IntSet;
import org.apache.druid.java.util.common.StringUtils;
import org.junit.Test;

public class ImmutableConciseSetTest {
    public static final int NO_COMPLEMENT_LENGTH = -1;

    @Test
    public void testWordIteratorNext1() {
        int[] ints = new int[]{1, 2, 3, 4, 5};
        ConciseSet set = new ConciseSet();
        for (int i : ints) {
            set.add(i);
        }
        ImmutableConciseSet iSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        ImmutableConciseSet.WordIterator itr = iSet.newWordIterator();
        Assert.assertEquals((int)-2147483586, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testWordIteratorNext2() {
        ConciseSet set = new ConciseSet();
        for (int i = 0; i < 100000; ++i) {
            set.add(i);
        }
        ImmutableConciseSet iSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        ImmutableConciseSet.WordIterator itr = iSet.newWordIterator();
        Assert.assertEquals((int)1073745048, (int)itr.next());
        Assert.assertEquals((int)-2113929217, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testWordIteratorAdvanceTo1() {
        ConciseSet set = new ConciseSet();
        for (int i = 0; i < 100000; ++i) {
            set.add(i);
        }
        ImmutableConciseSet iSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        ImmutableConciseSet.WordIterator itr = iSet.newWordIterator();
        itr.advanceTo(50);
        Assert.assertEquals((int)1073744998, (int)itr.next());
        Assert.assertEquals((int)-2113929217, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testWordIteratorAdvanceTo2() {
        ConciseSet set = new ConciseSet();
        for (int i = 0; i < 100000; ++i) {
            set.add(i);
        }
        ImmutableConciseSet iSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        ImmutableConciseSet.WordIterator itr = iSet.newWordIterator();
        itr.advanceTo(3225);
        Assert.assertEquals((int)-2113929217, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactOneLitOneLit() {
        int[] words = new int[]{-1, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)0x40000001, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactOneLitPureOneFill() {
        int[] words = new int[]{-1, 0x40000004};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)0x40000005, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactOneLitDirtyOneFill() {
        int[] words = new int[]{-1, 0x42000004};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((int)0x42000004, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactOneFillOneLit() {
        int[] words = new int[]{0x40000004, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)0x40000005, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactOneFillPureOneFill() {
        int[] words = new int[]{0x40000004, 0x40000004};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)0x40000009, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactOneFillDirtyOneFill() {
        int[] words = new int[]{0x40000004, 0x42000004};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)0x40000004, (int)itr.next());
        Assert.assertEquals((int)0x42000004, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactZeroLitZeroLit() {
        int[] words = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)1, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactZeroLitPureZeroFill() {
        int[] words = new int[]{Integer.MIN_VALUE, 4, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)5, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactZeroLitDirtyZeroFill() {
        int[] words = new int[]{Integer.MIN_VALUE, 0x2000004, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)Integer.MIN_VALUE, (int)itr.next());
        Assert.assertEquals((int)0x2000004, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactZeroFillZeroLit() {
        int[] words = new int[]{4, Integer.MIN_VALUE, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)5, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactZeroFillPureZeroFill() {
        int[] words = new int[]{4, 4, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)9, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactZeroFillDirtyZeroFill() {
        int[] words = new int[]{4, 0x2000004, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)4, (int)itr.next());
        Assert.assertEquals((int)0x2000004, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactSingleOneBitLitZeroLit() {
        int[] words = new int[]{-2147483647, Integer.MIN_VALUE, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)0x2000001, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactDoubleOneBitLitZeroLit() {
        int[] words = new int[]{-2147483645, Integer.MIN_VALUE, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)-2147483645, (int)itr.next());
        Assert.assertEquals((int)Integer.MIN_VALUE, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactSingleOneBitLitPureZeroFill() {
        int[] words = new int[]{-2147483647, 4, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)0x2000005, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactDoubleOneBitLitPureZeroFill() {
        int[] words = new int[]{-2147483645, 4, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)-2147483645, (int)itr.next());
        Assert.assertEquals((int)4, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactSingleOneBitLitDirtyZeroFill() {
        int[] words = new int[]{-2147483647, 0x2000004, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)-2147483647, (int)itr.next());
        Assert.assertEquals((int)0x2000004, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactSingleZeroBitLitOneLit() {
        int[] words = new int[]{-2, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)1107296257, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactDoubleZeroBitLitOneLit() {
        int[] words = new int[]{-18, -1};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)-18, (int)itr.next());
        Assert.assertEquals((int)-1, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactSingleZeroBitLitPureOneFill() {
        int[] words = new int[]{-2, 0x40000004};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)1107296261, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactDoubleZeroBitLitPureOneFill() {
        int[] words = new int[]{-4, 0x40000004};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)-4, (int)itr.next());
        Assert.assertEquals((int)0x40000004, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactSingleZeroBitLitDirtyOneFill() {
        int[] words = new int[]{-2, 0x42000004};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)-2, (int)itr.next());
        Assert.assertEquals((int)0x42000004, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testCompactTwoLiterals() {
        int[] words = new int[]{-2, -1048833};
        ImmutableConciseSet res = ImmutableConciseSet.compact((ImmutableConciseSet)new ImmutableConciseSet(IntBuffer.wrap(words)));
        ImmutableConciseSet.WordIterator itr = res.newWordIterator();
        Assert.assertEquals((int)-2, (int)itr.next());
        Assert.assertEquals((int)-1048833, (int)itr.next());
        Assert.assertEquals((boolean)itr.hasNext(), (boolean)false);
    }

    @Test
    public void testUnion1() {
        int[] ints1 = new int[]{33, 100000};
        int[] ints2 = new int[]{34, 100000};
        List<Integer> expected = Arrays.asList(33, 34, 100000);
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i : ints2) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion2() {
        int[] ints1 = new int[]{33, 100000};
        int[] ints2 = new int[]{34, 200000};
        List<Integer> expected = Arrays.asList(33, 34, 100000, 200000);
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i : ints2) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion3() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i = 62; i < 10001; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 63; i < 10002; ++i) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 62; i < 10002; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion4() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i = 63; i < 1001; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 64; i < 1002; ++i) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 63; i < 1002; ++i) {
            expected.add(i);
        }
        ConciseSet blah = new ConciseSet();
        Iterator iterator = expected.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            blah.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion5() {
        int[] ints1 = new int[]{1, 2, 3, 4, 5};
        int[] ints2 = new int[]{100000, 2405983, 33};
        int[] ints3 = new int[]{0, 4, 5, 34, 333333};
        List<Integer> expected = Arrays.asList(0, 1, 2, 3, 4, 5, 33, 34, 100000, 333333, 2405983);
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i : ints2) {
            set2.add(i);
        }
        ConciseSet set3 = new ConciseSet();
        for (int i : ints3) {
            set3.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set3));
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion6() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 30; ++i) {
            if (i == 28) continue;
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 30; ++i) {
            if (i == 27) continue;
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 0; i < 30; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion7() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i = 64; i < 1005; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 63; i < 99; ++i) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 63; i < 1005; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion8() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            if (i == 27) continue;
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            if (i == 28) continue;
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 0; i < 1000; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion9() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            if (i == 27 || i == 28) continue;
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            if (i == 28) continue;
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 0; i < 1000; ++i) {
            if (i == 28) continue;
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion10() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 1000; i += 2) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 1; i < 1000; i += 2) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 0; i < 1000; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion11() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 1000; i += 2) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        set2.add(10000);
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 0; i < 1000; i += 2) {
            expected.add(i);
        }
        expected.add(10000);
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion12() {
        int[] ints1 = new int[]{1, 2, 3, 4};
        int[] ints2 = new int[]{5, 1000};
        List<Integer> expected = Arrays.asList(1, 2, 3, 4, 5, 1000);
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i : ints2) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion13() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int[] ints1 = new int[]{0};
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 1; i < 100; ++i) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 0; i < 100; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion14() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int[] ints1 = new int[]{0, 100};
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 1; i < 100; ++i) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 0; i <= 100; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion15() {
        int i2;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int[] ints1 = new int[]{1, 100};
        int[] ints2 = new int[]{0};
        ConciseSet set1 = new ConciseSet();
        for (int i2 : ints1) {
            set1.add(i2);
        }
        ConciseSet set2 = new ConciseSet();
        int[] nArray = ints2;
        int n = nArray.length;
        for (i2 = 0; i2 < n; ++i2) {
            int i3 = nArray[i2];
            set2.add(i3);
        }
        ConciseSet set3 = new ConciseSet();
        for (int i4 = 1; i4 < 100; ++i4) {
            set3.add(i4);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set3));
        for (i2 = 0; i2 <= 100; ++i2) {
            expected.add(i2);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion16() {
        int[] ints1 = new int[]{1001, 1002, 1003};
        int[] ints2 = new int[]{1034, 1035, 1036};
        List<Integer> expected = Arrays.asList(1001, 1002, 1003, 1034, 1035, 1036);
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i : ints2) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion17() {
        int[] ints1 = new int[]{1, 2, 3, 4, 5};
        int[] ints2 = new int[]{1, 2, 3, 4, 5};
        List<Integer> expected = Arrays.asList(1, 2, 3, 4, 5);
        ConciseSet set1 = new ConciseSet();
        for (int i : ints1) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i : ints2) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion18() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 1000; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        set2.add(1000);
        set2.add(10000);
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 0; i < 1001; ++i) {
            expected.add(i);
        }
        expected.add(10000);
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion19() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (int i = 0; i < 93; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 62; i < 1000; ++i) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (int i = 0; i < 1000; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion20() {
        int i;
        int i2;
        int i3;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set1 = new ConciseSet();
        for (i3 = 0; i3 < 5; ++i3) {
            set1.add(i3);
        }
        for (i3 = 31; i3 < 1000; ++i3) {
            set1.add(i3);
        }
        ConciseSet set2 = new ConciseSet();
        for (i2 = 62; i2 < 68; ++i2) {
            set2.add(i2);
        }
        for (i2 = 800; i2 < 1000; ++i2) {
            set2.add(i2);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        for (i = 0; i < 5; ++i) {
            expected.add(i);
        }
        for (i = 31; i < 1000; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion21() {
        ConciseSet set1 = new ConciseSet();
        for (int i = 32; i < 93; ++i) {
            set1.add(i);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i = 0; i < 62; ++i) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (int i = 0; i < 93; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion22() {
        int i;
        ConciseSet set1 = new ConciseSet();
        for (int i2 = 93; i2 < 1000; ++i2) {
            set1.add(i2);
        }
        ConciseSet set2 = new ConciseSet();
        for (int i3 = 0; i3 < 32; ++i3) {
            set2.add(i3);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1), ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2));
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (i = 0; i < 32; ++i) {
            expected.add(i);
        }
        for (i = 93; i < 1000; ++i) {
            expected.add(i);
        }
        this.verifyUnion(expected, sets);
    }

    @Test
    public void testUnion23() {
        int i;
        ConciseSet set1 = new ConciseSet();
        set1.add(10);
        set1.add(1000);
        ConciseSet set2 = new ConciseSet();
        for (i = 0; i < 10; ++i) {
            set2.add(i);
        }
        for (i = 11; i < 1000; ++i) {
            set2.add(i);
        }
        List<ImmutableConciseSet> sets = Arrays.asList(ImmutableConciseSet.compact((ImmutableConciseSet)ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set1)), ImmutableConciseSet.compact((ImmutableConciseSet)ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set2)));
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (int i2 = 0; i2 <= 1000; ++i2) {
            expected.add(i2);
        }
        this.verifyUnion(expected, sets);
    }

    private void verifyUnion(List<Integer> expected, List<ImmutableConciseSet> sets) {
        ArrayList<Integer> actual = new ArrayList<Integer>();
        ImmutableConciseSet set = ImmutableConciseSet.union(sets);
        IntSet.IntIterator itr = set.iterator();
        while (itr.hasNext()) {
            actual.add(itr.next());
        }
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testComplement1() {
        int[] ints = new int[]{1, 100};
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set = new ConciseSet();
        for (int i : ints) {
            set.add(i);
        }
        for (int i = 0; i <= 100; ++i) {
            if (i == 1 || i == 100) continue;
            expected.add(i);
        }
        ImmutableConciseSet testSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        this.verifyComplement(expected, testSet, -1);
    }

    @Test
    public void testComplement2() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        ConciseSet set = new ConciseSet();
        for (int i = 0; i < 15; ++i) {
            set.add(i);
        }
        ImmutableConciseSet testSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        this.verifyComplement(expected, testSet, -1);
    }

    @Test
    public void testComplement3() {
        int i;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int length = 21;
        ConciseSet set = new ConciseSet();
        for (i = 0; i < 15; ++i) {
            set.add(i);
        }
        for (i = 15; i < 21; ++i) {
            expected.add(i);
        }
        ImmutableConciseSet testSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        this.verifyComplement(expected, testSet, 21);
    }

    @Test
    public void testComplement4() {
        int i;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int length = 41;
        ConciseSet set = new ConciseSet();
        for (i = 0; i < 15; ++i) {
            set.add(i);
        }
        for (i = 15; i < 41; ++i) {
            expected.add(i);
        }
        ImmutableConciseSet testSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        this.verifyComplement(expected, testSet, 41);
    }

    @Test
    public void testComplement5() {
        int i;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int length = 1001;
        ConciseSet set = new ConciseSet();
        for (i = 0; i < 15; ++i) {
            set.add(i);
        }
        for (i = 15; i < 1001; ++i) {
            expected.add(i);
        }
        ImmutableConciseSet testSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        this.verifyComplement(expected, testSet, 1001);
    }

    @Test
    public void testComplement6() {
        int i;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int length = 1001;
        ConciseSet set = new ConciseSet();
        for (i = 65; i <= 100; ++i) {
            set.add(i);
        }
        for (i = 0; i < 1001; ++i) {
            if (i >= 65 && i <= 100) continue;
            expected.add(i);
        }
        ImmutableConciseSet testSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        this.verifyComplement(expected, testSet, 1001);
    }

    @Test
    public void testComplement7() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int length = 37;
        ConciseSet set = new ConciseSet();
        for (int i = 0; i <= 35; ++i) {
            set.add(i);
        }
        expected.add(36);
        ImmutableConciseSet testSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        this.verifyComplement(expected, testSet, 37);
    }

    @Test
    public void testComplement8() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int length = 32;
        ConciseSet set = new ConciseSet();
        for (int i = 0; i <= 30; ++i) {
            set.add(i);
        }
        expected.add(31);
        ImmutableConciseSet testSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        this.verifyComplement(expected, testSet, 32);
    }

    @Test
    public void testComplement9() {
        ArrayList<Integer> lengths = new ArrayList<Integer>(Arrays.asList(35, 31, 32, 1, 0, 93, 1024, 1040187422));
        Random random = new Random(701534702L);
        for (int i = 0; i < 5; ++i) {
            lengths.add(random.nextInt(1040187423));
        }
        ImmutableConciseSet emptySet = new ImmutableConciseSet();
        Iterator iterator = lengths.iterator();
        while (iterator.hasNext()) {
            int length = (Integer)iterator.next();
            ImmutableConciseSet complement = ImmutableConciseSet.complement((ImmutableConciseSet)emptySet, (int)length);
            IntSet.IntIterator intIterator = complement.iterator();
            for (int i = 0; i < length; ++i) {
                int n = intIterator.next();
                if (i == n) continue;
                Assert.assertEquals((String)StringUtils.format((String)"Failure at bit [%d] on length [%d]", (Object[])new Object[]{i, length}), (int)i, (int)n);
            }
            NoSuchElementException ex = null;
            try {
                intIterator.next();
            }
            catch (NoSuchElementException e) {
                ex = e;
            }
            Assert.assertNotNull((Object)ex);
        }
    }

    @Test
    public void testComplement10() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int length = 93;
        for (int i = 0; i < 93; ++i) {
            expected.add(i);
        }
        ImmutableConciseSet testSet = new ImmutableConciseSet();
        this.verifyComplement(expected, testSet, 93);
    }

    @Test
    public void testComplement11() {
        int i;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int length = 18930;
        for (i = 0; i < 500; ++i) {
            expected.add(i);
        }
        for (i = 18881; i < length; ++i) {
            expected.add(i);
        }
        ConciseSet set = new ConciseSet();
        for (int i2 = 500; i2 <= 18880; ++i2) {
            set.add(i2);
        }
        ImmutableConciseSet testSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)set);
        this.verifyComplement(expected, testSet, length);
    }

    @Test
    public void testComplement12() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int length = 10;
        for (int i = 0; i < 10; ++i) {
            expected.add(i);
        }
        ImmutableConciseSet testSet = new ImmutableConciseSet();
        this.verifyComplement(expected, testSet, length);
    }

    @Test
    public void testComplement13() {
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int length = 10;
        for (int i = 0; i < length; ++i) {
            expected.add(i);
        }
        ImmutableConciseSet testSet = new ImmutableConciseSet();
        this.verifyComplement(expected, testSet, length);
    }

    private void verifyComplement(List<Integer> expected, ImmutableConciseSet set, int endIndex) {
        ArrayList<Integer> actual = new ArrayList<Integer>();
        ImmutableConciseSet res = endIndex == -1 ? ImmutableConciseSet.complement((ImmutableConciseSet)set) : ImmutableConciseSet.complement((ImmutableConciseSet)set, (int)endIndex);
        IntSet.IntIterator itr = res.iterator();
        while (itr.hasNext()) {
            actual.add(itr.next());
        }
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testContains() {
        ConciseSet conciseSet = new ConciseSet();
        Random random = new Random(543167436715430L);
        HashSet<Integer> integerSet = new HashSet<Integer>();
        int max = -1;
        for (int i = 0; i < 100; ++i) {
            int j = random.nextInt(0x100000);
            integerSet.add(j);
            conciseSet.add(j);
            if (j <= max) continue;
            max = j;
        }
        ImmutableConciseSet immutableConciseSet = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)conciseSet);
        for (int i = 0; i < max + 10; ++i) {
            String s = Integer.toString(i);
            Assert.assertEquals((String)s, (boolean)integerSet.contains(i), (boolean)conciseSet.contains(i));
            Assert.assertEquals((String)s, (boolean)integerSet.contains(i), (boolean)immutableConciseSet.contains(i));
        }
    }
}

