/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import java.util.ArrayList;
import java.util.List;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.channel.BlockingQueueFrameChannel;
import org.apache.druid.frame.channel.ReadableConcatFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Test;

public class ReadableConcatFrameChannelTest
extends InitializedNullHandlingTest {
    @Test
    public void testChannel() throws Exception {
        QueryableIndexStorageAdapter adapter = new QueryableIndexStorageAdapter(TestIndex.getMMappedTestIndex());
        List frames = FrameSequenceBuilder.fromAdapter((StorageAdapter)adapter).frameType(FrameType.ROW_BASED).maxRowsPerFrame(11).frames().toList();
        ArrayList<Object> channels = new ArrayList<Object>();
        for (Frame frame : frames) {
            BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
            channel.writable().write(frame);
            channel.writable().close();
            channels.add(channel.readable());
            channels.add(ReadableNilFrameChannel.INSTANCE);
        }
        ReadableConcatFrameChannel concatChannel = ReadableConcatFrameChannel.open(channels.iterator());
        FrameTestUtil.assertRowsEqual(FrameTestUtil.readRowsFromAdapter((StorageAdapter)adapter, null, false), FrameTestUtil.readRowsFromFrameChannel((ReadableFrameChannel)concatChannel, FrameReader.create((RowSignature)adapter.getRowSignature())));
    }
}

