/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.ConstantFieldPointer;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.field.StringFieldReader;
import org.apache.druid.frame.field.StringFieldWriter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class StringFieldReaderTest
extends InitializedNullHandlingTest {
    private static final long MEMORY_POSITION = 1L;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public DimensionSelector writeSelector;
    private WritableMemory memory;
    private FieldWriter fieldWriter;

    @Before
    public void setUp() {
        this.memory = WritableMemory.allocate((int)1000);
        this.fieldWriter = new StringFieldWriter(this.writeSelector);
    }

    @After
    public void tearDown() {
        this.fieldWriter.close();
    }

    @Test
    public void test_isNull_null() {
        this.writeToMemory(Collections.singletonList(null));
        Assert.assertTrue((boolean)new StringFieldReader(false).isNull((Memory)this.memory, 1L));
        Assert.assertTrue((boolean)new StringFieldReader(true).isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_aValue() {
        this.writeToMemory(Collections.singletonList("foo"));
        Assert.assertFalse((boolean)new StringFieldReader(false).isNull((Memory)this.memory, 1L));
        Assert.assertFalse((boolean)new StringFieldReader(true).isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_multiString() {
        this.writeToMemory((List<String>)ImmutableList.of((Object)"foo", (Object)"bar"));
        Assert.assertFalse((boolean)new StringFieldReader(false).isNull((Memory)this.memory, 1L));
        Assert.assertFalse((boolean)new StringFieldReader(true).isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_isNull_multiStringIncludingNulls() {
        this.writeToMemory(Arrays.asList(null, "bar"));
        Assert.assertFalse((boolean)new StringFieldReader(false).isNull((Memory)this.memory, 1L));
        Assert.assertFalse((boolean)new StringFieldReader(true).isNull((Memory)this.memory, 1L));
    }

    @Test
    public void test_makeColumnValueSelector_singleString_notArray() {
        this.writeToMemory(Collections.singletonList("foo"));
        ColumnValueSelector readSelector = new StringFieldReader(false).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        ColumnValueSelector readSelectorAsArray = new StringFieldReader(true).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        Assert.assertEquals((Object)"foo", (Object)readSelector.getObject());
        Assert.assertEquals(Collections.singletonList("foo"), (Object)readSelectorAsArray.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_multiString() {
        this.writeToMemory((List<String>)ImmutableList.of((Object)"foo", (Object)"bar"));
        ColumnValueSelector readSelector = new StringFieldReader(false).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        ColumnValueSelector readSelectorAsArray = new StringFieldReader(true).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar"), (Object)readSelector.getObject());
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar"), (Object)readSelectorAsArray.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_null() {
        this.writeToMemory(Collections.singletonList(null));
        ColumnValueSelector readSelector = new StringFieldReader(false).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        ColumnValueSelector readSelectorAsArray = new StringFieldReader(true).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        Assert.assertNull((Object)readSelector.getObject());
        Assert.assertEquals(Collections.singletonList(null), (Object)readSelectorAsArray.getObject());
    }

    @Test
    public void test_makeColumnValueSelector_empty() {
        this.writeToMemory(Collections.emptyList());
        ColumnValueSelector readSelector = new StringFieldReader(false).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        ColumnValueSelector readSelectorAsArray = new StringFieldReader(true).makeColumnValueSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L));
        Assert.assertNull((Object)readSelector.getObject());
        Assert.assertEquals(Collections.emptyList(), (Object)readSelectorAsArray.getObject());
    }

    @Test
    public void test_makeDimensionSelector_multiString_asArray() {
        this.writeToMemory((List<String>)ImmutableList.of((Object)"foo", (Object)"bar"));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> new StringFieldReader(true).makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L), null));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Cannot call makeDimensionSelector")));
    }

    @Test
    public void test_makeDimensionSelector_multiString() {
        this.writeToMemory((List<String>)ImmutableList.of((Object)"foo", (Object)"bar"));
        DimensionSelector readSelector = new StringFieldReader(false).makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L), null);
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)2L, (long)row.size());
        Assert.assertEquals((Object)"foo", (Object)readSelector.lookupName(0));
        Assert.assertEquals((Object)"bar", (Object)readSelector.lookupName(1));
        Assert.assertEquals((Object)StringUtils.toUtf8ByteBuffer((String)"foo"), (Object)readSelector.lookupNameUtf8(0));
        Assert.assertEquals((Object)StringUtils.toUtf8ByteBuffer((String)"bar"), (Object)readSelector.lookupNameUtf8(1));
        Assert.assertTrue((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(Object.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("bar").matches());
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("baz").matches());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("bar"::equals).matches());
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("baz"::equals).matches());
    }

    @Test
    public void test_makeDimensionSelector_multiString_withExtractionFn() {
        this.writeToMemory((List<String>)ImmutableList.of((Object)"foo", (Object)"bar"));
        DimensionSelector readSelector = new StringFieldReader(false).makeDimensionSelector((Memory)this.memory, (ReadableFieldPointer)new ConstantFieldPointer(1L), (ExtractionFn)new SubstringDimExtractionFn(1, null));
        IndexedInts row = readSelector.getRow();
        Assert.assertEquals((long)2L, (long)row.size());
        Assert.assertEquals((Object)"oo", (Object)readSelector.lookupName(0));
        Assert.assertEquals((Object)"ar", (Object)readSelector.lookupName(1));
        Assert.assertFalse((boolean)readSelector.supportsLookupNameUtf8());
        Assert.assertFalse((boolean)readSelector.nameLookupPossibleInAdvance());
        Assert.assertEquals((long)-1L, (long)readSelector.getValueCardinality());
        Assert.assertEquals(Object.class, (Object)readSelector.classOfObject());
        Assert.assertNull((Object)readSelector.idLookup());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("ar").matches());
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("bar").matches());
        Assert.assertTrue((boolean)readSelector.makeValueMatcher("ar"::equals).matches());
        Assert.assertFalse((boolean)readSelector.makeValueMatcher("bar"::equals).matches());
    }

    private void writeToMemory(List<String> values) {
        RangeIndexedInts row = new RangeIndexedInts();
        row.setSize(values.size());
        Mockito.when((Object)this.writeSelector.getRow()).thenReturn((Object)row);
        if (values.size() > 0) {
            Mockito.when((Object)this.writeSelector.supportsLookupNameUtf8()).thenReturn((Object)false);
        }
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            Mockito.when((Object)this.writeSelector.lookupName(i)).thenReturn((Object)value);
        }
        if (this.fieldWriter.writeTo(this.memory, 1L, this.memory.getCapacity() - 1L) < 0L) {
            throw new ISE("Could not write", new Object[0]);
        }
    }
}

