/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.FieldReaders;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.FrameComparisonWidgetImpl;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.KeyTestUtils;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyComparatorTest;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FrameComparisonWidgetImplTest
extends InitializedNullHandlingTest {
    private Frame frame;

    @Before
    public void setUp() {
        StorageAdapter rowBasedAdapter = new RowBasedSegment(SegmentId.dummy((String)"test"), Sequences.simple(RowKeyComparatorTest.ALL_KEY_OBJECTS), columnName -> {
            int idx = RowKeyComparatorTest.SIGNATURE.getColumnNames().indexOf(columnName);
            if (idx < 0) {
                return row -> null;
            }
            return row -> row[idx];
        }, RowKeyComparatorTest.SIGNATURE).asStorageAdapter();
        this.frame = (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromAdapter(rowBasedAdapter).frameType(FrameType.ROW_BASED).frames().toList());
    }

    @Test
    public void test_isPartiallyNullKey_someColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget((List<KeyColumn>)keyColumns);
        for (int i = 0; i < this.frame.numRows(); ++i) {
            boolean isPartiallyNull = Arrays.stream(RowKeyComparatorTest.ALL_KEY_OBJECTS.get(i)).limit(3L).anyMatch(Objects::isNull);
            Assert.assertEquals((Object)isPartiallyNull, (Object)widget.isPartiallyNullKey(i));
        }
    }

    @Test
    public void test_isPartiallyNullKey_allColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget((List<KeyColumn>)keyColumns);
        for (int i = 0; i < this.frame.numRows(); ++i) {
            boolean isPartiallyNull = Arrays.stream(RowKeyComparatorTest.ALL_KEY_OBJECTS.get(i)).anyMatch(Objects::isNull);
            Assert.assertEquals((Object)isPartiallyNull, (Object)widget.isPartiallyNullKey(i));
        }
    }

    @Test
    public void test_readKey_someColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget((List<KeyColumn>)keyColumns);
        RowSignature signature = RowSignature.builder().add("1", (ColumnType)RowKeyComparatorTest.SIGNATURE.getColumnType("1").orElse(null)).add("2", (ColumnType)RowKeyComparatorTest.SIGNATURE.getColumnType("2").orElse(null)).add("3", (ColumnType)RowKeyComparatorTest.SIGNATURE.getColumnType("3").orElse(null)).build();
        for (int i = 0; i < this.frame.numRows(); ++i) {
            Object[] expectedKeyArray = new Object[keyColumns.size()];
            System.arraycopy(RowKeyComparatorTest.ALL_KEY_OBJECTS.get(i), 0, expectedKeyArray, 0, keyColumns.size());
            Assert.assertEquals((Object)KeyTestUtils.createKey(signature, expectedKeyArray), (Object)widget.readKey(i));
        }
    }

    @Test
    public void test_readKey_allColumns() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget((List<KeyColumn>)keyColumns);
        for (int i = 0; i < this.frame.numRows(); ++i) {
            Assert.assertEquals((Object)KeyTestUtils.createKey(RowKeyComparatorTest.SIGNATURE, RowKeyComparatorTest.ALL_KEY_OBJECTS.get(i)), (Object)widget.readKey(i));
        }
    }

    @Test
    public void test_compare_frameToKey() {
        ImmutableList keyColumns = ImmutableList.of((Object)new KeyColumn("1", KeyOrder.ASCENDING), (Object)new KeyColumn("2", KeyOrder.ASCENDING), (Object)new KeyColumn("3", KeyOrder.ASCENDING), (Object)new KeyColumn("4", KeyOrder.ASCENDING));
        FrameComparisonWidget widget = this.createComparisonWidget((List<KeyColumn>)keyColumns);
        for (int i = 0; i < this.frame.numRows(); ++i) {
            Assert.assertEquals((long)0L, (long)widget.compare(i, KeyTestUtils.createKey(RowKeyComparatorTest.SIGNATURE, RowKeyComparatorTest.ALL_KEY_OBJECTS.get(i))));
        }
        RowKey firstKey = KeyTestUtils.createKey(RowKeyComparatorTest.SIGNATURE, RowKeyComparatorTest.ALL_KEY_OBJECTS.get(0));
        MatcherAssert.assertThat((Object)widget.compare(0, firstKey), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)widget.compare(1, firstKey), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(2, firstKey), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(3, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(4, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(5, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)widget.compare(6, firstKey), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    private FrameComparisonWidget createComparisonWidget(List<KeyColumn> keyColumns) {
        return FrameComparisonWidgetImpl.create((Frame)this.frame, (RowSignature)RowKeyComparatorTest.SIGNATURE, keyColumns, keyColumns.stream().map(keyColumn -> FieldReaders.create((String)keyColumn.columnName(), (ColumnType)((ColumnType)RowKeyComparatorTest.SIGNATURE.getColumnType(keyColumn.columnName()).get()))).collect(Collectors.toList()));
    }
}

