/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.PartitionedReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameStorageAdapter;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class OutputChannelFactoryTest
extends InitializedNullHandlingTest {
    private final OutputChannelFactory outputChannelFactory;
    private final long frameSize;
    protected final StorageAdapter sourceAdapter;
    protected final Frame frame;

    public OutputChannelFactoryTest(OutputChannelFactory outputChannelFactory, long frameSize) {
        this.outputChannelFactory = outputChannelFactory;
        this.frameSize = frameSize;
        this.sourceAdapter = new IncrementalIndexStorageAdapter(TestIndex.getIncrementalTestIndex());
        this.frame = (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromAdapter(this.sourceAdapter).frameType(FrameType.COLUMNAR).frames().toList());
    }

    @Test
    public void test_openChannel() throws IOException, ExecutionException, InterruptedException {
        OutputChannel channel = this.outputChannelFactory.openChannel(1);
        Assert.assertEquals((long)1L, (long)channel.getPartitionNumber());
        WritableFrameChannel writableFrameChannel = channel.getWritableChannel();
        writableFrameChannel.writabilityFuture().get();
        writableFrameChannel.write(new FrameWithPartition(this.frame, 1));
        writableFrameChannel.close();
        this.verifySingleFrameReadableChannel(channel.getReadableChannel(), this.sourceAdapter);
        Assert.assertEquals((long)this.frameSize, (long)channel.getFrameMemoryAllocator().capacity());
    }

    @Test
    public void test_openPartitionedChannel() throws IOException, ExecutionException, InterruptedException {
        PartitionedOutputChannel channel = this.outputChannelFactory.openPartitionedChannel("test", true);
        int[] partitions = new int[]{1, 2};
        WritableFrameChannel writableFrameChannel = channel.getWritableChannel();
        writableFrameChannel.writabilityFuture().get();
        for (int partition : partitions) {
            writableFrameChannel.write(new FrameWithPartition(this.frame, partition));
        }
        writableFrameChannel.close();
        Supplier partitionedReadableFrameChannelSupplier = channel.getReadableChannelSupplier();
        for (int partition : partitions) {
            this.verifySingleFrameReadableChannel(((PartitionedReadableFrameChannel)partitionedReadableFrameChannelSupplier.get()).getReadableFrameChannel(partition), this.sourceAdapter);
            Assert.assertEquals((long)this.frameSize, (long)channel.getFrameMemoryAllocator().capacity());
        }
    }

    protected void verifySingleFrameReadableChannel(ReadableFrameChannel readableFrameChannel, StorageAdapter adapter) throws ExecutionException, InterruptedException {
        readableFrameChannel.readabilityFuture().get();
        while (!readableFrameChannel.canRead()) {
        }
        Frame readbackFrame = readableFrameChannel.read();
        readableFrameChannel.readabilityFuture().get();
        Assert.assertFalse((boolean)readableFrameChannel.canRead());
        Assert.assertTrue((boolean)readableFrameChannel.isFinished());
        readableFrameChannel.close();
        List writtenData = adapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null).flatMap(cursor -> FrameTestUtil.readRowsFromCursor(cursor, adapter.getRowSignature())).toList();
        FrameStorageAdapter frameStorageAdapter = new FrameStorageAdapter(readbackFrame, FrameReader.create((RowSignature)adapter.getRowSignature()), Intervals.ETERNITY);
        List readData = frameStorageAdapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null).flatMap(cursor -> FrameTestUtil.readRowsFromCursor(cursor, adapter.getRowSignature())).toList();
        Assert.assertEquals((String)"Read rows count is different from written rows count", (long)writtenData.size(), (long)readData.size());
        Assert.assertEquals((String)"Read data is different from written data", (Object)writtenData, (Object)readData);
    }

    @Test
    public void test_openNilChannel() {
        OutputChannel channel = this.outputChannelFactory.openNilChannel(1);
        Assert.assertEquals((long)1L, (long)channel.getPartitionNumber());
        Assert.assertTrue((boolean)channel.getReadableChannel().isFinished());
        Assert.assertThrows(IllegalStateException.class, () -> ((OutputChannel)channel).getWritableChannel());
    }
}

