/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import java.net.MalformedURLException;
import java.net.URL;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.indexer.TaskLocation;
import org.junit.Assert;
import org.junit.Test;

public class TaskLocationTest {
    @Test
    public void testMakeURL() throws MalformedURLException {
        Assert.assertEquals((Object)new URL("http://abc:80/foo"), (Object)new TaskLocation("abc", 80, 0).makeURL("/foo"));
        Assert.assertEquals((Object)new URL("http://abc:80/foo"), (Object)new TaskLocation("abc", 80, -1).makeURL("/foo"));
        Assert.assertEquals((Object)new URL("https://abc:443/foo"), (Object)new TaskLocation("abc", 80, 443).makeURL("/foo"));
        Assert.assertThrows((String)"URL that does not start with '/'", IllegalArgumentException.class, () -> new TaskLocation("abc", 80, 443).makeURL("foo"));
    }

    @Test
    public void testTlsForPeonJobs() {
        TaskLocation noTls = TaskLocation.create((String)"foo", (int)1, (int)2, (boolean)false);
        Assert.assertEquals((long)-1L, (long)noTls.getTlsPort());
        Assert.assertEquals((long)1L, (long)noTls.getPort());
        TaskLocation tls = TaskLocation.create((String)"foo", (int)1, (int)2, (boolean)true);
        Assert.assertEquals((long)-1L, (long)tls.getPort());
        Assert.assertEquals((long)2L, (long)tls.getTlsPort());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(TaskLocation.class).usingGetClass().verify();
    }
}

