/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.Test;

public class GranularityTest {
    final Granularity NONE = Granularities.NONE;
    final Granularity SECOND = Granularities.SECOND;
    final Granularity MINUTE = Granularities.MINUTE;
    final Granularity HOUR = Granularities.HOUR;
    final Granularity SIX_HOUR = Granularities.SIX_HOUR;
    final Granularity EIGHT_HOUR = Granularities.EIGHT_HOUR;
    final Granularity FIFTEEN_MINUTE = Granularities.FIFTEEN_MINUTE;
    final Granularity DAY = Granularities.DAY;
    final Granularity WEEK = Granularities.WEEK;
    final Granularity MONTH = Granularities.MONTH;
    final Granularity YEAR = Granularities.YEAR;
    final Granularity ALL = Granularities.ALL;

    @Test
    public void testHiveFormat() {
        PathDate[] secondChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "dt=2011-03-15-20-50-43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/dt=2011-03-15-20-50-43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/dt=2011-03-15-20-50-43/Test1"), new PathDate(null, null, "valid/dt=2011-03-15-20-50/Test2"), new PathDate(null, null, "valid/dt=2011-03-15-20/Test3"), new PathDate(null, null, "valid/dt=2011-03-15/Test4"), new PathDate(null, null, "valid/dt=2011-03/Test5"), new PathDate(null, null, "valid/dt=2011/Test6"), new PathDate(null, null, "null/dt=----/Test7"), new PathDate(null, null, "null/10-2011-23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(null, IllegalFieldValueException.class, "error/dt=2011-10-20-20-42-72/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/dt=2011-10-20-42-90-24/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/dt=2011-10-33-20-42-24/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/dt=2011-13-20-20-42-24/Test11")};
        this.checkToDate(this.SECOND, Granularity.Formatter.HIVE, secondChecks);
    }

    @Test
    public void testSecondToDate() {
        PathDate[] secondChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(null, null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(null, null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.SECOND, Granularity.Formatter.DEFAULT, secondChecks);
    }

    @Test
    public void testMinuteToDate() {
        PathDate[] minuteChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 50, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(null, null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 20, 42, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.MINUTE, Granularity.Formatter.DEFAULT, minuteChecks);
    }

    @Test
    public void testFifteenMinuteToDate() {
        PathDate[] minuteChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=00/Test2a"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=14/Test2b"), new PathDate(new DateTime(2011, 3, 15, 20, 15, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=15/Test2c"), new PathDate(new DateTime(2011, 3, 15, 20, 15, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=29/Test2d"), new PathDate(new DateTime(2011, 3, 15, 20, 30, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=30/Test2e"), new PathDate(new DateTime(2011, 3, 15, 20, 30, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=44/Test2f"), new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=45/Test2g"), new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=59/Test2h"), new PathDate(null, null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 20, 30, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.FIFTEEN_MINUTE, Granularity.Formatter.DEFAULT, minuteChecks);
    }

    @Test
    public void testHourToDate() {
        PathDate[] hourChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 20, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 10, 20, 20, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.HOUR, Granularity.Formatter.DEFAULT, hourChecks);
    }

    @Test
    public void testSixHourToDate() {
        PathDate[] hourChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 18, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 18, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 18, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 18, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 15, 18, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 18, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 10, 20, 18, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=00/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=02/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 6, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=06/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 6, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=11/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 12, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=12/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 12, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=13/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.SIX_HOUR, Granularity.Formatter.DEFAULT, hourChecks);
    }

    @Test
    public void testEightHourToDate() {
        PathDate[] hourChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 16, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 16, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 16, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 16, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 15, 16, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 16, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 10, 20, 16, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=00/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=02/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=06/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 8, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=11/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 8, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=12/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 8, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=13/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.EIGHT_HOUR, Granularity.Formatter.DEFAULT, hourChecks);
    }

    @Test
    public void testDayToDate() {
        PathDate[] dayChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.DAY, Granularity.Formatter.DEFAULT, dayChecks);
    }

    @Test
    public void testMonthToDate() {
        PathDate[] monthChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 10, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(new DateTime(2011, 10, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.MONTH, Granularity.Formatter.DEFAULT, monthChecks);
    }

    @Test
    public void testYearToDate() {
        PathDate[] yearChecks = new PathDate[]{new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/Test5"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.YEAR, Granularity.Formatter.DEFAULT, yearChecks);
    }

    private void checkToDate(Granularity granularity, Granularity.Formatter formatter, PathDate[] checks) {
        for (PathDate pd : checks) {
            boolean flag;
            block5: {
                if (pd.exception == null) {
                    Assert.assertEquals((String)StringUtils.format((String)"[%s,%s] Expected path %s to return date %s", (Object[])new Object[]{granularity, formatter, pd.path, pd.date}), (Object)pd.date, (Object)granularity.toDate(pd.path, formatter));
                    if (formatter.equals((Object)Granularity.Formatter.DEFAULT)) {
                        Assert.assertEquals((String)StringUtils.format((String)"[%s] Expected toDate(%s) to return the same as toDate(%s, DEFAULT)", (Object[])new Object[]{granularity, pd.path, pd.path}), (Object)granularity.toDate(pd.path), (Object)granularity.toDate(pd.path, formatter));
                    }
                    if (pd.date == null) continue;
                    Assert.assertEquals((String)StringUtils.format((String)"[%s,%s] Expected date %s to return date %s", (Object[])new Object[]{granularity, formatter, pd.date, pd.date}), (Object)pd.date, (Object)granularity.toDate(granularity.getFormatter(formatter).print((ReadableInstant)pd.date) + "/", formatter));
                    continue;
                }
                flag = false;
                try {
                    granularity.toDate(pd.path, formatter);
                }
                catch (Exception e) {
                    if (e.getClass() != pd.exception) break block5;
                    flag = true;
                }
            }
            Assert.assertTrue((String)StringUtils.format((String)"[%s,%s] Expected exception %s for path: %s", (Object[])new Object[]{granularity, formatter, pd.exception, pd.path}), (boolean)flag);
        }
    }

    @Test
    public void testBucket() {
        DateTime dt = DateTimes.of((String)"2011-02-03T04:05:06.100");
        Assert.assertEquals((Object)Intervals.ETERNITY, (Object)this.ALL.bucket(dt));
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-01/2012-01-01"), (Object)this.YEAR.bucket(dt));
        Assert.assertEquals((Object)Intervals.of((String)"2011-02-01/2011-03-01"), (Object)this.MONTH.bucket(dt));
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-31/2011-02-07"), (Object)this.WEEK.bucket(dt));
        Assert.assertEquals((Object)Intervals.of((String)"2011-02-03/2011-02-04"), (Object)this.DAY.bucket(dt));
        Assert.assertEquals((Object)Intervals.of((String)"2011-02-03T04/2011-02-03T05"), (Object)this.HOUR.bucket(dt));
        Assert.assertEquals((Object)Intervals.of((String)"2011-02-03T04:05:00/2011-02-03T04:06:00"), (Object)this.MINUTE.bucket(dt));
        Assert.assertEquals((Object)Intervals.of((String)"2011-02-03T04:05:06/2011-02-03T04:05:07"), (Object)this.SECOND.bucket(dt));
        Assert.assertEquals((Object)Intervals.of((String)"2011-02-03T04:05:06.100/2011-02-03T04:05:06.101"), (Object)this.NONE.bucket(dt));
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-01/2011-01-02"), (Object)this.DAY.bucket(DateTimes.of((String)"2011-01-01")));
    }

    @Test
    public void testBucketStart() {
        DateTime date = DateTimes.of((String)"2011-03-15T22:42:23.898");
        Assert.assertEquals((Object)DateTimes.MIN, (Object)this.ALL.bucketStart(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-01-01T00:00:00.000"), (Object)this.YEAR.bucketStart(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-01T00:00:00.000"), (Object)this.MONTH.bucketStart(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-14T00:00:00.000"), (Object)this.WEEK.bucketStart(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-15T00:00:00.000"), (Object)this.DAY.bucketStart(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-15T22:00:00.000"), (Object)this.HOUR.bucketStart(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-15T22:42:00.000"), (Object)this.MINUTE.bucketStart(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-15T22:42:23.000"), (Object)this.SECOND.bucketStart(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-15T22:42:23.898"), (Object)this.NONE.bucketStart(date));
    }

    @Test
    public void testBucketStartOnMillis() {
        DateTime date = DateTimes.of((String)"2011-03-15T22:42:23.898");
        Assert.assertEquals((long)DateTimes.MIN.getMillis(), (long)this.ALL.bucketStart(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-01-01T00:00:00.000").getMillis(), (long)this.YEAR.bucketStart(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-01T00:00:00.000").getMillis(), (long)this.MONTH.bucketStart(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-14T00:00:00.000").getMillis(), (long)this.WEEK.bucketStart(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-15T00:00:00.000").getMillis(), (long)this.DAY.bucketStart(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-15T22:00:00.000").getMillis(), (long)this.HOUR.bucketStart(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-15T22:42:00.000").getMillis(), (long)this.MINUTE.bucketStart(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-15T22:42:23.000").getMillis(), (long)this.SECOND.bucketStart(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-15T22:42:23.898").getMillis(), (long)this.NONE.bucketStart(date.getMillis()));
    }

    @Test
    public void testIncrement() {
        DateTime date = DateTimes.of((String)"2011-03-15T22:42:23.898");
        Assert.assertEquals((Object)DateTimes.MIN, (Object)this.ALL.bucketStart(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2012-03-15T22:42:23.898"), (Object)this.YEAR.increment(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-04-15T22:42:23.898"), (Object)this.MONTH.increment(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-22T22:42:23.898"), (Object)this.WEEK.increment(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-16T22:42:23.898"), (Object)this.DAY.increment(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-15T23:42:23.898"), (Object)this.HOUR.increment(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-15T22:43:23.898"), (Object)this.MINUTE.increment(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-15T22:42:24.898"), (Object)this.SECOND.increment(date));
        Assert.assertEquals((Object)DateTimes.of((String)"2011-03-15T22:42:23.899"), (Object)this.NONE.increment(date));
    }

    @Test
    public void testIncrementOnMillis() {
        DateTime date = DateTimes.of((String)"2011-03-15T22:42:23.898");
        Assert.assertEquals((Object)DateTimes.MIN, (Object)this.ALL.bucketStart(date));
        Assert.assertEquals((long)DateTimes.of((String)"2012-03-15T22:42:23.898").getMillis(), (long)this.YEAR.increment(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-04-15T22:42:23.898").getMillis(), (long)this.MONTH.increment(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-22T22:42:23.898").getMillis(), (long)this.WEEK.increment(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-16T22:42:23.898").getMillis(), (long)this.DAY.increment(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-15T23:42:23.898").getMillis(), (long)this.HOUR.increment(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-15T22:43:23.898").getMillis(), (long)this.MINUTE.increment(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-15T22:42:24.898").getMillis(), (long)this.SECOND.increment(date.getMillis()));
        Assert.assertEquals((long)DateTimes.of((String)"2011-03-15T22:42:23.899").getMillis(), (long)this.NONE.increment(date.getMillis()));
    }

    @Test
    public void testGetIterable() {
        DateTime start = DateTimes.of((String)"2011-01-01T00:00:00");
        DateTime end = DateTimes.of((String)"2011-01-14T00:00:00");
        Iterator intervals = this.DAY.getIterable(new Interval((ReadableInstant)start, (ReadableInstant)end)).iterator();
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-01/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-02/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-03/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-04/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-05/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-06/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-07/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-08/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-09/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-10/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-11/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-12/P1d"), intervals.next());
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-13/P1d"), intervals.next());
        try {
            intervals.next();
        }
        catch (NoSuchElementException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testCustomPeriodToDate() {
        PathDate[] customChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 50, 42, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 42, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 42, 0, (Chronology)ISOChronology.getInstanceUTC()), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1")};
        this.checkToDate((Granularity)new PeriodGranularity(new Period((Object)"PT2S"), null, DateTimeZone.UTC), Granularity.Formatter.DEFAULT, customChecks);
    }

    @Test
    public void testCustomNestedPeriodFail() {
        try {
            Period p = Period.years((int)6).withMonths(3).withSeconds(23);
            GranularityType.fromPeriod((Period)p);
            Assert.fail((String)"Complicated period creation should fail b/c of unsupported granularity type.");
        }
        catch (IAE iAE) {
            // empty catch block
        }
    }

    @Test
    public void testIncrementOverSpringForward() {
        DateTimeZone saoPaulo = DateTimes.inferTzFromString((String)"America/Sao_Paulo");
        PeriodGranularity granSaoPauloDay = new PeriodGranularity(Period.days((int)1), null, saoPaulo);
        Iterable intervals = granSaoPauloDay.getIterable(new Interval((ReadableInstant)new DateTime((Object)"2017-10-14", saoPaulo), (ReadableInstant)new DateTime((Object)"2017-10-17", saoPaulo)));
        Assert.assertEquals((Object)ImmutableList.of((Object)new DateTime((Object)"2017-10-14", saoPaulo), (Object)new DateTime((Object)"2017-10-15T01", saoPaulo), (Object)new DateTime((Object)"2017-10-16", saoPaulo)), StreamSupport.stream(intervals.spliterator(), false).map(interval -> granSaoPauloDay.bucketStart(interval.getStart())).collect(Collectors.toList()));
    }

    @Test
    public void testIsFinerComparator() {
        Assert.assertTrue((Granularity.IS_FINER_THAN.compare(this.NONE, this.SECOND) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Granularity.IS_FINER_THAN.compare(this.SECOND, this.NONE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((Granularity.IS_FINER_THAN.compare(this.NONE, this.MINUTE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Granularity.IS_FINER_THAN.compare(this.MINUTE, this.NONE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((Granularity.IS_FINER_THAN.compare(this.DAY, this.MONTH) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Granularity.IS_FINER_THAN.compare(Granularities.YEAR, this.ALL) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Granularity.IS_FINER_THAN.compare(Granularities.ALL, this.YEAR) > 0 ? 1 : 0) != 0);
        Granularity day = this.DAY;
        Granularity none = this.NONE;
        Granularity all = this.ALL;
        Assert.assertTrue((Granularity.IS_FINER_THAN.compare(this.DAY, day) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Granularity.IS_FINER_THAN.compare(this.NONE, none) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Granularity.IS_FINER_THAN.compare(this.ALL, all) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGranularitiesFinerThanDay() {
        Assert.assertEquals((Object)ImmutableList.of((Object)Granularities.DAY, (Object)Granularities.EIGHT_HOUR, (Object)Granularities.SIX_HOUR, (Object)Granularities.HOUR, (Object)Granularities.THIRTY_MINUTE, (Object)Granularities.FIFTEEN_MINUTE, (Object)Granularities.TEN_MINUTE, (Object)Granularities.FIVE_MINUTE, (Object)Granularities.MINUTE, (Object)Granularities.SECOND), (Object)Granularity.granularitiesFinerThan((Granularity)Granularities.DAY));
    }

    @Test
    public void testGranularitiesFinerThanHour() {
        Assert.assertEquals((Object)ImmutableList.of((Object)Granularities.HOUR, (Object)Granularities.THIRTY_MINUTE, (Object)Granularities.FIFTEEN_MINUTE, (Object)Granularities.TEN_MINUTE, (Object)Granularities.FIVE_MINUTE, (Object)Granularities.MINUTE, (Object)Granularities.SECOND), (Object)Granularity.granularitiesFinerThan((Granularity)Granularities.HOUR));
    }

    @Test
    public void testGranularitiesFinerThanAll() {
        Assert.assertEquals((Object)ImmutableList.of((Object)Granularities.ALL, (Object)Granularities.YEAR, (Object)Granularities.QUARTER, (Object)Granularities.MONTH, (Object)Granularities.WEEK, (Object)Granularities.DAY, (Object)Granularities.EIGHT_HOUR, (Object)Granularities.SIX_HOUR, (Object)Granularities.HOUR, (Object)Granularities.THIRTY_MINUTE, (Object)Granularities.FIFTEEN_MINUTE, (Object)Granularities.TEN_MINUTE, (Object[])new Granularity[]{Granularities.FIVE_MINUTE, Granularities.MINUTE, Granularities.SECOND}), (Object)Granularity.granularitiesFinerThan((Granularity)Granularities.ALL));
    }

    @Test
    public void testGranularitiesFinerThanNone() {
        Assert.assertEquals((Object)ImmutableList.of(), (Object)Granularity.granularitiesFinerThan((Granularity)Granularities.NONE));
    }

    private static class PathDate {
        public final String path;
        public final DateTime date;
        public final Class<? extends Exception> exception;

        private PathDate(DateTime date, Class<? extends Exception> exception, String path) {
            this.path = path;
            this.date = date;
            this.exception = exception;
        }
    }
}

