/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.collect.ImmutableList;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StringUtilsTest {
    private static final List<String> COMPARE_TEST_STRINGS = ImmutableList.of((Object)"\uff08\u8acb\u53c3\u898b\u5df2\u88ab\u522a\u9664\u7248\u672c\uff09", (Object)"\u8acb\u53c3\u898b\u5df2\u88ab\u522a\u9664\u7248\u672c", (Object)"\u05e9\u05b8\u05c1\u05dc\u05d5\u05b9\u05dd", (Object)"\uff0b{{[[Template:\u5225\u540d\u91cd\u5b9a\u5411|\u5225\u540d\u91cd\u5b9a\u5411]]}}", (Object)"\ud83d\udc4d\ud83d\udc4d\ud83d\udc4d", (Object)"\ud83d\udca9", (Object)"", (Object)"f", (Object)"fo", (Object)"\ud83d\ude42", (Object)"\ud83e\udee5", (Object)"\ud83e\udd20", (Object[])new String[]{"quick", "brown", "fox"});
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void fromUtf8ConversionTest() throws UnsupportedEncodingException {
        byte[] bytes = new byte[]{97, 98, 99, 100};
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((byte[])bytes));
        String abcd = "abcd";
        Assert.assertEquals((Object)abcd, (Object)StringUtils.fromUtf8((byte[])abcd.getBytes(StringUtils.UTF8_STRING)));
    }

    @Test
    public void toUtf8ConversionTest() {
        byte[] bytes = new byte[]{97, 98, 99, 100};
        byte[] strBytes = StringUtils.toUtf8((String)"abcd");
        for (int i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)strBytes[i]);
        }
    }

    @Test
    public void toUtf8WithLimitTest() {
        ByteBuffer smallBuffer = ByteBuffer.allocate(4);
        ByteBuffer mediumBuffer = ByteBuffer.allocate(6);
        ByteBuffer bigBuffer = ByteBuffer.allocate(8);
        int smallBufferResult = StringUtils.toUtf8WithLimit((String)"\ud83d\ude80\ud83c\udf14", (ByteBuffer)smallBuffer);
        Assert.assertEquals((long)4L, (long)smallBufferResult);
        byte[] smallBufferByteArray = new byte[smallBufferResult];
        smallBuffer.get(smallBufferByteArray);
        Assert.assertEquals((Object)"\ud83d\ude80", (Object)StringUtils.fromUtf8((byte[])smallBufferByteArray));
        int mediumBufferResult = StringUtils.toUtf8WithLimit((String)"\ud83d\ude80\ud83c\udf14", (ByteBuffer)mediumBuffer);
        Assert.assertEquals((long)4L, (long)mediumBufferResult);
        byte[] mediumBufferByteArray = new byte[mediumBufferResult];
        mediumBuffer.get(mediumBufferByteArray);
        Assert.assertEquals((Object)"\ud83d\ude80", (Object)StringUtils.fromUtf8((byte[])mediumBufferByteArray));
        int bigBufferResult = StringUtils.toUtf8WithLimit((String)"\ud83d\ude80\ud83c\udf14", (ByteBuffer)bigBuffer);
        Assert.assertEquals((long)8L, (long)bigBufferResult);
        byte[] bigBufferByteArray = new byte[bigBufferResult];
        bigBuffer.get(bigBufferByteArray);
        Assert.assertEquals((Object)"\ud83d\ude80\ud83c\udf14", (Object)StringUtils.fromUtf8((byte[])bigBufferByteArray));
    }

    @Test
    public void fromUtf8ByteBufferHeap() {
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 98, 99, 100});
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes, (int)4));
        bytes.rewind();
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes));
    }

    @Test
    public void testMiddleOfByteArrayConversion() {
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 98, 99, 100});
        bytes.position(1).limit(3);
        Assert.assertEquals((Object)"bc", (Object)StringUtils.fromUtf8((ByteBuffer)bytes, (int)2));
        bytes.position(1);
        Assert.assertEquals((Object)"bc", (Object)StringUtils.fromUtf8((ByteBuffer)bytes));
    }

    @Test(expected=BufferUnderflowException.class)
    public void testOutOfBounds() {
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 98, 99, 100});
        bytes.position(1).limit(3);
        StringUtils.fromUtf8((ByteBuffer)bytes, (int)3);
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointerByteBuffer() {
        StringUtils.fromUtf8((ByteBuffer)null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointerByteArray() {
        StringUtils.fromUtf8((byte[])null);
    }

    @Test
    public void fromUtf8ByteBufferDirect() {
        try (ResourceHolder bufferHolder = ByteBufferUtils.allocateDirect((int)4);){
            ByteBuffer bytes = (ByteBuffer)bufferHolder.get();
            bytes.put(new byte[]{97, 98, 99, 100});
            bytes.rewind();
            Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes, (int)4));
            bytes.rewind();
            Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes));
        }
    }

    @Test
    public void testNonStrictFormat() {
        Assert.assertEquals((Object)"test%d; format", (Object)StringUtils.nonStrictFormat((String)"test%d", (Object[])new Object[]{"format"}));
        Assert.assertEquals((Object)"test%s%s; format", (Object)StringUtils.nonStrictFormat((String)"test%s%s", (Object[])new Object[]{"format"}));
    }

    @Test
    public void testRemoveChar() {
        Assert.assertEquals((Object)"123", (Object)StringUtils.removeChar((String)"123", (char)','));
        Assert.assertEquals((Object)"123", (Object)StringUtils.removeChar((String)"123,", (char)','));
        Assert.assertEquals((Object)"123", (Object)StringUtils.removeChar((String)",1,,2,3,", (char)','));
        Assert.assertEquals((Object)"", (Object)StringUtils.removeChar((String)",,", (char)','));
    }

    @Test
    public void testReplaceChar() {
        Assert.assertEquals((Object)"123", (Object)StringUtils.replaceChar((String)"123", (char)',', (String)"x"));
        Assert.assertEquals((Object)"12345", (Object)StringUtils.replaceChar((String)"123,", (char)',', (String)"45"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceChar((String)"", (char)'a', (String)"bb"));
        Assert.assertEquals((Object)"bb", (Object)StringUtils.replaceChar((String)"a", (char)'a', (String)"bb"));
        Assert.assertEquals((Object)"bbbb", (Object)StringUtils.replaceChar((String)"aa", (char)'a', (String)"bb"));
    }

    @Test
    public void testReplace() {
        Assert.assertEquals((Object)"x1x2x3x", (Object)StringUtils.replace((String)"123", (String)"", (String)"x"));
        Assert.assertEquals((Object)"12345", (Object)StringUtils.replace((String)"123,", (String)",", (String)"45"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"", (String)"a", (String)"bb"));
        Assert.assertEquals((Object)"bb", (Object)StringUtils.replace((String)"a", (String)"a", (String)"bb"));
        Assert.assertEquals((Object)"bba", (Object)StringUtils.replace((String)"aaa", (String)"aa", (String)"bb"));
        Assert.assertEquals((Object)"bcb", (Object)StringUtils.replace((String)"aacaa", (String)"aa", (String)"b"));
        Assert.assertEquals((Object)"bb", (Object)StringUtils.replace((String)"aaaa", (String)"aa", (String)"b"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"aaaa", (String)"aa", (String)""));
    }

    @Test
    public void testEncodeForFormat() {
        Assert.assertEquals((Object)"x %% a %%s", (Object)StringUtils.encodeForFormat((String)"x % a %s"));
        Assert.assertEquals((Object)"", (Object)StringUtils.encodeForFormat((String)""));
        Assert.assertNull((Object)StringUtils.encodeForFormat(null));
    }

    @Test
    public void testURLEncodeSpace() {
        String s1 = StringUtils.urlEncode((String)"aaa bbb");
        Assert.assertEquals((Object)s1, (Object)"aaa%20bbb");
        Assert.assertEquals((Object)"aaa bbb", (Object)StringUtils.urlDecode((String)s1));
        String s2 = StringUtils.urlEncode((String)"fff+ggg");
        Assert.assertEquals((Object)s2, (Object)"fff%2Bggg");
        Assert.assertEquals((Object)"fff+ggg", (Object)StringUtils.urlDecode((String)s2));
    }

    @Test
    public void testRepeat() {
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"foo", (int)0));
        Assert.assertEquals((Object)"foo", (Object)StringUtils.repeat((String)"foo", (int)1));
        Assert.assertEquals((Object)"foofoofoo", (Object)StringUtils.repeat((String)"foo", (int)3));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", (int)1));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", (int)3));
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("count is negative, -1");
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"foo", (int)-1));
    }

    @Test
    public void testLpad() {
        String lpad = StringUtils.lpad((String)"abc", (int)7, (String)"de");
        Assert.assertEquals((Object)"dedeabc", (Object)lpad);
        lpad = StringUtils.lpad((String)"abc", (int)6, (String)"de");
        Assert.assertEquals((Object)"dedabc", (Object)lpad);
        lpad = StringUtils.lpad((String)"abc", (int)2, (String)"de");
        Assert.assertEquals((Object)"ab", (Object)lpad);
        lpad = StringUtils.lpad((String)"abc", (int)0, (String)"de");
        Assert.assertEquals((Object)"", (Object)lpad);
        lpad = StringUtils.lpad((String)"abc", (int)-1, (String)"de");
        Assert.assertEquals((Object)"", (Object)lpad);
        lpad = StringUtils.lpad((String)"abc", (int)10, (String)"");
        Assert.assertEquals((Object)"abc", (Object)lpad);
        lpad = StringUtils.lpad((String)"abc", (int)1, (String)"");
        Assert.assertEquals((Object)"a", (Object)lpad);
    }

    @Test
    public void testRpad() {
        String rpad = StringUtils.rpad((String)"abc", (int)7, (String)"de");
        Assert.assertEquals((Object)"abcdede", (Object)rpad);
        rpad = StringUtils.rpad((String)"abc", (int)6, (String)"de");
        Assert.assertEquals((Object)"abcded", (Object)rpad);
        rpad = StringUtils.rpad((String)"abc", (int)2, (String)"de");
        Assert.assertEquals((Object)"ab", (Object)rpad);
        rpad = StringUtils.rpad((String)"abc", (int)0, (String)"de");
        Assert.assertEquals((Object)"", (Object)rpad);
        rpad = StringUtils.rpad((String)"abc", (int)-1, (String)"de");
        Assert.assertEquals((Object)"", (Object)rpad);
        rpad = StringUtils.rpad((String)"abc", (int)10, (String)"");
        Assert.assertEquals((Object)"abc", (Object)rpad);
        rpad = StringUtils.rpad((String)"abc", (int)1, (String)"");
        Assert.assertEquals((Object)"a", (Object)rpad);
    }

    @Test
    public void testChop() {
        Assert.assertEquals((Object)"foo", (Object)StringUtils.chop((String)"foo", (int)5));
        Assert.assertEquals((Object)"fo", (Object)StringUtils.chop((String)"foo", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.chop((String)"foo", (int)0));
        Assert.assertEquals((Object)"smile \ud83d\ude42 for", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)14));
        Assert.assertEquals((Object)"smile \ud83d\ude42", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)10));
        Assert.assertEquals((Object)"smile ", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)9));
        Assert.assertEquals((Object)"smile ", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)8));
        Assert.assertEquals((Object)"smile ", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)7));
        Assert.assertEquals((Object)"smile ", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)6));
        Assert.assertEquals((Object)"smile", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)5));
    }

    @Test
    public void testFastLooseChop() {
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fastLooseChop((String)"foo", (int)5));
        Assert.assertEquals((Object)"fo", (Object)StringUtils.fastLooseChop((String)"foo", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.fastLooseChop((String)"foo", (int)0));
        Assert.assertEquals((Object)"smile \ud83d\ude42 for", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)12));
        Assert.assertEquals((Object)"smile \ud83d\ude42 ", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)9));
        Assert.assertEquals((Object)"smile \ud83d\ude42", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)8));
        Assert.assertEquals((Object)"smile \ud83d", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)7));
        Assert.assertEquals((Object)"smile ", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)6));
        Assert.assertEquals((Object)"smile", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)5));
    }

    @Test
    public void testUnicodeStringCompare() {
        for (String string1 : COMPARE_TEST_STRINGS) {
            for (String string2 : COMPARE_TEST_STRINGS) {
                int compareUnicode = StringUtils.compareUnicode((String)string1, (String)string2);
                int compareUtf8 = StringUtils.compareUtf8((byte[])StringUtils.toUtf8((String)string1), (byte[])StringUtils.toUtf8((String)string2));
                Assert.assertEquals((String)StringUtils.format((String)"compareUnicode (actual) matches compareUtf8 (expected) for [%s] vs [%s]", (Object[])new Object[]{string1, string2}), (long)((int)Math.signum(compareUtf8)), (long)((int)Math.signum(compareUnicode)));
            }
        }
    }

    @Test
    public void testJavaStringCompare() {
        for (String string1 : COMPARE_TEST_STRINGS) {
            for (String string2 : COMPARE_TEST_STRINGS) {
                int compareJavaString = string1.compareTo(string2);
                byte[] utf8Bytes1 = StringUtils.toUtf8((String)string1);
                byte[] utf8Bytes2 = StringUtils.toUtf8((String)string2);
                int compareByteArrayUtf8UsingJavaStringOrdering = StringUtils.compareUtf8UsingJavaStringOrdering((byte[])utf8Bytes1, (byte[])utf8Bytes2);
                ByteBuffer utf8ByteBuffer1 = ByteBuffer.allocate(utf8Bytes1.length + 2);
                ByteBuffer utf8ByteBuffer2 = ByteBuffer.allocate(utf8Bytes2.length + 2);
                utf8ByteBuffer1.position(1);
                utf8ByteBuffer1.put(utf8Bytes1, 0, utf8Bytes1.length).position(utf8Bytes1.length);
                utf8ByteBuffer2.position(1);
                utf8ByteBuffer2.put(utf8Bytes2, 0, utf8Bytes2.length).position(utf8Bytes2.length);
                int compareByteBufferUtf8UsingJavaStringOrdering = StringUtils.compareUtf8UsingJavaStringOrdering((ByteBuffer)utf8ByteBuffer1, (int)1, (int)utf8Bytes1.length, (ByteBuffer)utf8ByteBuffer2, (int)1, (int)utf8Bytes2.length);
                Assert.assertEquals((String)StringUtils.format((String)"compareUtf8UsingJavaStringOrdering(byte[]) (actual) matches compareJavaString (expected) for [%s] vs [%s]", (Object[])new Object[]{string1, string2}), (long)((int)Math.signum(compareJavaString)), (long)((int)Math.signum(compareByteArrayUtf8UsingJavaStringOrdering)));
                Assert.assertEquals((String)StringUtils.format((String)"compareByteBufferUtf8UsingJavaStringOrdering(ByteBuffer) (actual) matches compareJavaString (expected) for [%s] vs [%s]", (Object[])new Object[]{string1, string2}), (long)((int)Math.signum(compareJavaString)), (long)((int)Math.signum(compareByteBufferUtf8UsingJavaStringOrdering)));
            }
        }
    }
}

