/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.junit.Assert;
import org.junit.Test;

public class CloseableIteratorTest {
    @Test
    public void testMap() {
        CloseableIterator actual = CloseableIteratorTest.generateTestIterator(8).map(list -> {
            ArrayList<Integer> newList = new ArrayList<Integer>(list.size());
            for (Integer i : list) {
                newList.add(i * 10);
            }
            return newList;
        });
        Iterator expected = IntStream.range(0, 8).mapToObj(i -> IntStream.range(0, i).map(j -> j * 10).boxed().collect(Collectors.toList())).iterator();
        while (expected.hasNext() && actual.hasNext()) {
            Assert.assertEquals(expected.next(), (Object)actual.next());
        }
        Assert.assertFalse((boolean)actual.hasNext());
        Assert.assertFalse((boolean)expected.hasNext());
    }

    @Test
    public void testFlatMap() throws IOException {
        ArrayList innerIterators = new ArrayList();
        CloseTrackingCloseableIterator actual = new CloseTrackingCloseableIterator(CloseableIteratorTest.generateTestIterator(8).flatMap(list -> {
            CloseTrackingCloseableIterator inner = new CloseTrackingCloseableIterator(CloseableIterators.withEmptyBaggage(list.iterator()));
            innerIterators.add(inner);
            return inner;
        }));
        PrimitiveIterator.OfInt expected = IntStream.range(0, 8).flatMap(i -> IntStream.range(0, i)).iterator();
        while (expected.hasNext() && actual.hasNext()) {
            Assert.assertEquals(expected.next(), actual.next());
        }
        Assert.assertFalse((boolean)actual.hasNext());
        Assert.assertFalse((boolean)expected.hasNext());
        actual.close();
        Assert.assertEquals((long)1L, (long)actual.closeCount);
        for (CloseTrackingCloseableIterator iter : innerIterators) {
            Assert.assertEquals((long)1L, (long)iter.closeCount);
        }
    }

    @Test
    public void testFlatMapClosedEarly() throws IOException {
        int numIterations = 8;
        ArrayList innerIterators = new ArrayList();
        CloseTrackingCloseableIterator actual = new CloseTrackingCloseableIterator(CloseableIteratorTest.generateTestIterator(8).flatMap(list -> {
            CloseTrackingCloseableIterator inner = new CloseTrackingCloseableIterator(CloseableIterators.withEmptyBaggage(list.iterator()));
            innerIterators.add(inner);
            return inner;
        }));
        PrimitiveIterator.OfInt expected = IntStream.range(0, 8).flatMap(i -> IntStream.range(0, i)).iterator();
        int cnt = 0;
        int numFlatIterations = 5;
        while (expected.hasNext() && actual.hasNext() && cnt++ < numFlatIterations) {
            Assert.assertEquals(expected.next(), actual.next());
        }
        Assert.assertTrue((boolean)actual.hasNext());
        Assert.assertTrue((boolean)expected.hasNext());
        Assert.assertEquals((long)4L, (long)innerIterators.size());
        Assert.assertTrue((boolean)((CloseTrackingCloseableIterator)innerIterators.get(innerIterators.size() - 1)).hasNext());
        actual.close();
        Assert.assertEquals((long)1L, (long)actual.closeCount);
        for (CloseTrackingCloseableIterator iter : innerIterators) {
            Assert.assertEquals((long)1L, (long)iter.closeCount);
        }
    }

    private static CloseableIterator<List<Integer>> generateTestIterator(final int numIterates) {
        return new CloseableIterator<List<Integer>>(){
            private int cnt = 0;

            public boolean hasNext() {
                return this.cnt < numIterates;
            }

            public List<Integer> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                List<Integer> integers = IntStream.range(0, this.cnt).boxed().collect(Collectors.toList());
                ++this.cnt;
                return integers;
            }

            public void close() {
            }
        };
    }

    static class CloseTrackingCloseableIterator<T>
    implements CloseableIterator<T> {
        CloseableIterator<T> inner;
        int closeCount;

        public CloseTrackingCloseableIterator(CloseableIterator<T> toTrack) {
            this.inner = toTrack;
            this.closeCount = 0;
        }

        public void close() throws IOException {
            this.inner.close();
            ++this.closeCount;
        }

        public boolean hasNext() {
            return this.inner.hasNext();
        }

        public T next() {
            return (T)this.inner.next();
        }
    }
}

