/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.junit.Assert;
import org.junit.Test;

public class JSONFlattenerMakerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JSONFlattenerMaker FLATTENER_MAKER = new JSONFlattenerMaker(true, false);
    private static final JSONFlattenerMaker FLATTENER_MAKER_NESTED = new JSONFlattenerMaker(true, true);

    @Test
    public void testStrings() throws JsonProcessingException {
        String s1 = "hello";
        JsonNode node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)s1));
        Object result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)s1, (Object)result);
        String s2 = "hello \ud900";
        String s2Json = "\"hello \ud900\"";
        node = OBJECT_MAPPER.readTree(s2Json);
        result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertArrayEquals((byte[])StringUtils.toUtf8((String)s2), (byte[])StringUtils.toUtf8((String)((String)result)));
    }

    @Test
    public void testNumbers() throws JsonProcessingException {
        Integer i1 = 123;
        JsonNode node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)i1));
        Assert.assertTrue((boolean)node.isInt());
        Object result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)i1.longValue(), (Object)result);
        Long l1 = 0x80000000L;
        node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)l1));
        Assert.assertTrue((boolean)node.isLong());
        result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)l1, (Object)result);
        Float f1 = Float.valueOf(230.333f);
        node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)f1));
        Assert.assertTrue((boolean)node.isNumber());
        result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)230.333, (Object)result);
        Double d1 = 3.4028234663852886E38;
        node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)d1));
        Assert.assertTrue((boolean)node.isDouble());
        result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)d1, (Object)result);
        BigInteger bigInt = new BigInteger(String.valueOf(Long.MAX_VALUE));
        BigInteger bigInt2 = new BigInteger(String.valueOf(Long.MAX_VALUE));
        node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)bigInt.add(bigInt2)));
        Assert.assertTrue((boolean)node.isBigInteger());
        result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)bigInt.add(bigInt).doubleValue(), (Object)result);
    }

    @Test
    public void testBoolean() throws JsonProcessingException {
        Boolean bool = true;
        JsonNode node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)bool));
        Assert.assertTrue((boolean)node.isBoolean());
        Object result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)bool, (Object)result);
    }

    @Test
    public void testBinary() {
        byte[] data = new byte[]{1, 2, 3};
        BinaryNode node = new BinaryNode(data);
        Object result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)data, (Object)result);
    }

    @Test
    public void testNested() throws JsonProcessingException {
        ImmutableList intArray = ImmutableList.of((Object)1, (Object)2, (Object)3);
        ImmutableList expectedIntArray = ImmutableList.of((Object)1L, (Object)2L, (Object)3L);
        JsonNode node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)intArray));
        Assert.assertTrue((boolean)node.isArray());
        Object result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)expectedIntArray, (Object)result);
        ImmutableMap theMap = ImmutableMap.builder().put((Object)"bool", (Object)true).put((Object)"int", (Object)1).put((Object)"long", (Object)1L).put((Object)"float", (Object)Float.valueOf(0.11f)).put((Object)"double", (Object)0.33).put((Object)"binary", (Object)new byte[]{1, 2, 3}).put((Object)"list", (Object)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz")).put((Object)"anotherList", (Object)intArray).build();
        ImmutableMap expectedMap = ImmutableMap.builder().put((Object)"bool", (Object)true).put((Object)"int", (Object)1L).put((Object)"long", (Object)1L).put((Object)"float", (Object)0.11).put((Object)"double", (Object)0.33).put((Object)"binary", (Object)StringUtils.encodeBase64String((byte[])new byte[]{1, 2, 3})).put((Object)"list", (Object)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz")).put((Object)"anotherList", (Object)expectedIntArray).build();
        node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)theMap));
        Assert.assertTrue((boolean)node.isObject());
        result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)expectedMap, (Object)result);
        ImmutableList theList = ImmutableList.of((Object)theMap, (Object)theMap);
        ImmutableList expectedList = ImmutableList.of((Object)expectedMap, (Object)expectedMap);
        node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)theList));
        Assert.assertTrue((boolean)node.isArray());
        result = FLATTENER_MAKER.finalizeConversionForMap((Object)node);
        Assert.assertEquals((Object)expectedList, (Object)result);
    }

    @Test
    public void testDiscovery() throws JsonProcessingException {
        ImmutableMap theMap = ImmutableMap.builder().put((Object)"bool", (Object)true).put((Object)"int", (Object)1).put((Object)"long", (Object)1L).put((Object)"float", (Object)Float.valueOf(0.11f)).put((Object)"double", (Object)0.33).put((Object)"binary", (Object)new byte[]{1, 2, 3}).put((Object)"list", (Object)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz")).put((Object)"anotherList", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)).put((Object)"nested", (Object)ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)2L, (Object)"z", (Object)3L)).build();
        JsonNode node = OBJECT_MAPPER.readTree(OBJECT_MAPPER.writeValueAsString((Object)theMap));
        Assert.assertTrue((boolean)node.isObject());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"bool", (Object)"int", (Object)"long", (Object)"float", (Object)"double", (Object)"binary", (Object[])new String[]{"list", "anotherList"}), (Object)ImmutableSet.copyOf((Iterable)FLATTENER_MAKER.discoverRootFields(node)));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"bool", (Object)"int", (Object)"long", (Object)"float", (Object)"double", (Object)"binary", (Object[])new String[]{"list", "anotherList", "nested"}), (Object)ImmutableSet.copyOf((Iterable)FLATTENER_MAKER_NESTED.discoverRootFields(node)));
    }
}

