/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.apache.druid.java.util.emitter.core.BatchingStrategy;
import org.apache.druid.java.util.emitter.core.EmitterTest;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.GoHandler;
import org.apache.druid.java.util.emitter.core.GoHandlers;
import org.apache.druid.java.util.emitter.core.HttpEmitterConfig;
import org.apache.druid.java.util.emitter.core.HttpPostEmitter;
import org.apache.druid.java.util.emitter.core.MockHttpClient;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.testing.junit.LoggerCaptureRule;
import org.apache.logging.log4j.Level;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class HttpPostEmitterLoggerStressTest {
    @Rule
    public LoggerCaptureRule logCapture = new LoggerCaptureRule(HttpPostEmitter.class);
    private final MockHttpClient httpClient = new MockHttpClient();

    @Test(timeout=20000L)
    public void testBurstFollowedByQuietPeriod() throws InterruptedException, IOException {
        HttpEmitterConfig config = new HttpEmitterConfig.Builder("http://foo.bar").setFlushMillis(5000L).setFlushCount(3).setBatchingStrategy(BatchingStrategy.ONLY_EVENTS).setMaxBatchSize(0x100000).setBatchQueueSizeLimit(10).setMinHttpTimeoutMillis(100).build();
        HttpPostEmitter emitter = new HttpPostEmitter(config, (AsyncHttpClient)this.httpClient, new ObjectMapper());
        emitter.start();
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            protected <X extends Exception> ListenableFuture<Response> go(Request request) throws X {
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        });
        Event smallEvent = ServiceMetricEvent.builder().setFeed("smallEvents").setDimension("test", (Object)"hi").build("metric", (Number)10).build("qwerty", "asdfgh");
        for (int i = 0; i < 1000; ++i) {
            emitter.emit(smallEvent);
            Assert.assertTrue((emitter.getTotalFailedBuffers() <= 10 ? 1 : 0) != 0);
            Assert.assertTrue((emitter.getBuffersToEmit() <= 12 ? 1 : 0) != 0);
        }
        while (emitter.getTotalFailedBuffers() > 0) {
            Thread.sleep(500L);
        }
        long countOfTimeouts = this.logCapture.getLogEvents().stream().filter(ev -> ev.getLevel() == Level.DEBUG).filter(ev -> ev.getThrown() instanceof TimeoutException).count();
        long limitTimeoutEvents = 1000L;
        Assert.assertTrue((String)String.format(Locale.getDefault(), "too many timeouts (%d), expect less than (%d)", countOfTimeouts, limitTimeoutEvents), (countOfTimeouts < limitTimeoutEvents ? 1 : 0) != 0);
        emitter.close();
    }
}

