/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.emitter.core.BaseHttpEmittingConfig;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.EmitterTest;
import org.apache.druid.java.util.emitter.core.Emitters;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.GoHandler;
import org.apache.druid.java.util.emitter.core.GoHandlers;
import org.apache.druid.java.util.emitter.core.MockHttpClient;
import org.apache.druid.java.util.emitter.core.ParametrizedUriEmitter;
import org.apache.druid.java.util.emitter.service.UnitEvent;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParametrizedUriEmitterTest {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private MockHttpClient httpClient;
    private Lifecycle lifecycle;

    @Before
    public void setUp() {
        this.httpClient = new MockHttpClient();
    }

    @After
    public void tearDown() {
        if (this.lifecycle != null) {
            this.lifecycle.stop();
        }
    }

    private Emitter parametrizedEmmiter(String uriPattern) throws Exception {
        Properties props = new Properties();
        props.setProperty("org.apache.druid.java.util.emitter.type", "parametrized");
        props.setProperty("org.apache.druid.java.util.emitter.recipientBaseUrlPattern", uriPattern);
        props.setProperty("org.apache.druid.java.util.emitter.httpEmitting.flushTimeOut", String.valueOf(BaseHttpEmittingConfig.TEST_FLUSH_TIMEOUT_MILLIS));
        this.lifecycle = new Lifecycle();
        Emitter emitter = Emitters.create((Properties)props, (AsyncHttpClient)this.httpClient, (Lifecycle)this.lifecycle);
        Assert.assertEquals(ParametrizedUriEmitter.class, emitter.getClass());
        this.lifecycle.start();
        return emitter;
    }

    @Test
    public void testParametrizedEmitterCreated() throws Exception {
        this.parametrizedEmmiter("http://example.com/");
    }

    @Test
    public void testEmitterWithFeedUriExtractor() throws Exception {
        Emitter emitter = this.parametrizedEmmiter("http://example.com/{feed}");
        final List<UnitEvent> events = Arrays.asList(new UnitEvent("test", 1), new UnitEvent("test", 2));
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            public ListenableFuture<Response> go(Request request) throws JsonProcessingException {
                Assert.assertEquals((Object)"http://example.com/test", (Object)request.getUrl());
                Assert.assertEquals((Object)StringUtils.format((String)"[%s,%s]\n", (Object[])new Object[]{JSON_MAPPER.writeValueAsString(events.get(0)), JSON_MAPPER.writeValueAsString(events.get(1))}), (Object)StandardCharsets.UTF_8.decode(request.getByteBufferData().slice()).toString());
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        }.times(1));
        for (UnitEvent event : events) {
            emitter.emit((Event)event);
        }
        emitter.flush();
        Assert.assertTrue((boolean)this.httpClient.succeeded());
    }

    @Test
    public void testEmitterWithMultipleFeeds() throws Exception {
        Emitter emitter = this.parametrizedEmmiter("http://example.com/{feed}");
        List<UnitEvent> events = Arrays.asList(new UnitEvent("test1", 1), new UnitEvent("test2", 2));
        final HashMap results = new HashMap();
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            protected ListenableFuture<Response> go(Request request) {
                results.put(request.getUrl(), StandardCharsets.UTF_8.decode(request.getByteBufferData().slice()).toString());
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        }.times(2));
        for (UnitEvent event : events) {
            emitter.emit((Event)event);
        }
        emitter.flush();
        Assert.assertTrue((boolean)this.httpClient.succeeded());
        ImmutableMap expected = ImmutableMap.of((Object)"http://example.com/test1", (Object)StringUtils.format((String)"[%s]\n", (Object[])new Object[]{JSON_MAPPER.writeValueAsString((Object)events.get(0))}), (Object)"http://example.com/test2", (Object)StringUtils.format((String)"[%s]\n", (Object[])new Object[]{JSON_MAPPER.writeValueAsString((Object)events.get(1))}));
        Assert.assertEquals((Object)expected, results);
    }

    @Test
    public void testEmitterWithParametrizedUriExtractor() throws Exception {
        Emitter emitter = this.parametrizedEmmiter("http://example.com/{key1}/{key2}");
        final List<UnitEvent> events = Arrays.asList(new UnitEvent("test", 1, (Map<String, String>)ImmutableMap.of((Object)"key1", (Object)"val1", (Object)"key2", (Object)"val2")), new UnitEvent("test", 2, (Map<String, String>)ImmutableMap.of((Object)"key1", (Object)"val1", (Object)"key2", (Object)"val2")));
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            protected ListenableFuture<Response> go(Request request) throws JsonProcessingException {
                Assert.assertEquals((Object)"http://example.com/val1/val2", (Object)request.getUrl());
                Assert.assertEquals((Object)StringUtils.format((String)"[%s,%s]\n", (Object[])new Object[]{JSON_MAPPER.writeValueAsString(events.get(0)), JSON_MAPPER.writeValueAsString(events.get(1))}), (Object)StandardCharsets.UTF_8.decode(request.getByteBufferData().slice()).toString());
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        }.times(1));
        for (UnitEvent event : events) {
            emitter.emit((Event)event);
        }
        emitter.flush();
        Assert.assertTrue((boolean)this.httpClient.succeeded());
    }

    @Test
    public void failEmitMalformedEvent() throws Exception {
        Emitter emitter = this.parametrizedEmmiter("http://example.com/{keyNotSetInEvents}");
        UnitEvent event = new UnitEvent("test", 1);
        this.httpClient.setGoHandler(GoHandlers.failingHandler());
        try {
            emitter.emit((Event)event);
            emitter.flush();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)StringUtils.format((String)"ParametrizedUriExtractor with pattern http://example.com/{keyNotSetInEvents} requires keyNotSetInEvents to be set in event, but found %s", (Object[])new Object[]{event.toMap()}));
        }
    }
}

