/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.service;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.junit.Assert;
import org.junit.Test;

public class ServiceMetricEventTest {
    @Test
    public void testStupidTest() {
        ServiceMetricEvent builderEvent = (ServiceMetricEvent)new ServiceMetricEvent.Builder().setDimension("user1", (Object)"a").setDimension("user2", (Object)"b").setDimension("user3", (Object)"c").setDimension("user4", (Object)"d").setDimension("user5", (Object)"e").setDimension("user6", (Object)"f").setDimension("user7", (Object)"g").setDimension("user8", (Object)"h").setDimension("user9", (Object)"i").setDimension("user10", (Object)"j").build("test-metric", (Number)1234).build("test", "localhost");
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"metrics").put((Object)"timestamp", (Object)builderEvent.getCreatedTime().toString()).put((Object)"service", (Object)"test").put((Object)"host", (Object)"localhost").put((Object)"metric", (Object)"test-metric").put((Object)"user1", (Object)"a").put((Object)"user2", (Object)"b").put((Object)"user3", (Object)"c").put((Object)"user4", (Object)"d").put((Object)"user5", (Object)"e").put((Object)"user6", (Object)"f").put((Object)"user7", (Object)"g").put((Object)"user8", (Object)"h").put((Object)"user9", (Object)"i").put((Object)"user10", (Object)"j").put((Object)"value", (Object)1234).build(), (Object)builderEvent.toMap());
        ServiceMetricEvent constructorEvent = (ServiceMetricEvent)ServiceMetricEvent.builder().setDimension("user1", (Object)"a").setDimension("user2", (Object)"b").setDimension("user3", (Object)"c").setDimension("user4", (Object)"d").setDimension("user5", (Object)"e").setDimension("user6", (Object)"f").setDimension("user7", (Object)"g").setDimension("user8", (Object)"h").setDimension("user9", (Object)"i").setDimension("user10", (Object)"j").build("test-metric", (Number)1234).build("test", "localhost");
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"metrics").put((Object)"timestamp", (Object)constructorEvent.getCreatedTime().toString()).put((Object)"service", (Object)"test").put((Object)"host", (Object)"localhost").put((Object)"metric", (Object)"test-metric").put((Object)"user1", (Object)"a").put((Object)"user2", (Object)"b").put((Object)"user3", (Object)"c").put((Object)"user4", (Object)"d").put((Object)"user5", (Object)"e").put((Object)"user6", (Object)"f").put((Object)"user7", (Object)"g").put((Object)"user8", (Object)"h").put((Object)"user9", (Object)"i").put((Object)"user10", (Object)"j").put((Object)"value", (Object)1234).build(), (Object)constructorEvent.toMap());
        ServiceMetricEvent arrayConstructorEvent = (ServiceMetricEvent)ServiceMetricEvent.builder().setDimension("user1", new String[]{"a"}).setDimension("user2", new String[]{"b"}).setDimension("user3", new String[]{"c"}).setDimension("user4", new String[]{"d"}).setDimension("user5", new String[]{"e"}).setDimension("user6", new String[]{"f"}).setDimension("user7", new String[]{"g"}).setDimension("user8", new String[]{"h"}).setDimension("user9", new String[]{"i"}).setDimension("user10", new String[]{"j"}).build("test-metric", (Number)1234).build("test", "localhost");
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"metrics").put((Object)"timestamp", (Object)arrayConstructorEvent.getCreatedTime().toString()).put((Object)"service", (Object)"test").put((Object)"host", (Object)"localhost").put((Object)"metric", (Object)"test-metric").put((Object)"user1", Collections.singletonList("a")).put((Object)"user2", Collections.singletonList("b")).put((Object)"user3", Collections.singletonList("c")).put((Object)"user4", Collections.singletonList("d")).put((Object)"user5", Collections.singletonList("e")).put((Object)"user6", Collections.singletonList("f")).put((Object)"user7", Collections.singletonList("g")).put((Object)"user8", Collections.singletonList("h")).put((Object)"user9", Collections.singletonList("i")).put((Object)"user10", Collections.singletonList("j")).put((Object)"value", (Object)1234).build(), (Object)arrayConstructorEvent.toMap());
        Assert.assertNotNull((Object)((ServiceMetricEvent)new ServiceMetricEvent.Builder().setDimension("user1", (Object)"a").setDimension("user2", (Object)"b").setDimension("user3", (Object)"c").setDimension("user4", (Object)"d").setDimension("user5", (Object)"e").setDimension("user6", (Object)"f").setDimension("user7", (Object)"g").setDimension("user8", (Object)"h").setDimension("user9", (Object)"i").setDimension("user10", (Object)"j").build(null, "test-metric", (Number)1234).build("test", "localhost")).getCreatedTime());
        Assert.assertNotNull((Object)((ServiceMetricEvent)ServiceMetricEvent.builder().setDimension("user1", new String[]{"a"}).setDimension("user2", new String[]{"b"}).setDimension("user3", new String[]{"c"}).setDimension("user4", new String[]{"d"}).setDimension("user5", new String[]{"e"}).setDimension("user6", new String[]{"f"}).setDimension("user7", new String[]{"g"}).setDimension("user8", new String[]{"h"}).setDimension("user9", new String[]{"i"}).setDimension("user10", new String[]{"j"}).build("test-metric", (Number)1234).build("test", "localhost")).getCreatedTime());
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"metrics").put((Object)"timestamp", (Object)DateTimes.utc((long)42L).toString()).put((Object)"service", (Object)"test").put((Object)"host", (Object)"localhost").put((Object)"metric", (Object)"test-metric").put((Object)"user1", (Object)"a").put((Object)"user2", (Object)"b").put((Object)"user3", (Object)"c").put((Object)"user4", (Object)"d").put((Object)"user5", (Object)"e").put((Object)"user6", (Object)"f").put((Object)"user7", (Object)"g").put((Object)"user8", (Object)"h").put((Object)"user9", (Object)"i").put((Object)"user10", (Object)"j").put((Object)"value", (Object)1234).build(), (Object)((ServiceMetricEvent)new ServiceMetricEvent.Builder().setDimension("user1", (Object)"a").setDimension("user2", (Object)"b").setDimension("user3", (Object)"c").setDimension("user4", (Object)"d").setDimension("user5", (Object)"e").setDimension("user6", (Object)"f").setDimension("user7", (Object)"g").setDimension("user8", (Object)"h").setDimension("user9", (Object)"i").setDimension("user10", (Object)"j").build(DateTimes.utc((long)42L), "test-metric", (Number)1234).build("test", "localhost")).toMap());
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"metrics").put((Object)"timestamp", (Object)DateTimes.utc((long)42L).toString()).put((Object)"service", (Object)"test").put((Object)"host", (Object)"localhost").put((Object)"metric", (Object)"test-metric").put((Object)"user1", Collections.singletonList("a")).put((Object)"user2", Collections.singletonList("b")).put((Object)"user3", Collections.singletonList("c")).put((Object)"user4", Collections.singletonList("d")).put((Object)"user5", Collections.singletonList("e")).put((Object)"user6", Collections.singletonList("f")).put((Object)"user7", Collections.singletonList("g")).put((Object)"user8", Collections.singletonList("h")).put((Object)"user9", Collections.singletonList("i")).put((Object)"user10", Collections.singletonList("j")).put((Object)"value", (Object)1234).build(), (Object)((ServiceMetricEvent)ServiceMetricEvent.builder().setDimension("user1", new String[]{"a"}).setDimension("user2", new String[]{"b"}).setDimension("user3", new String[]{"c"}).setDimension("user4", new String[]{"d"}).setDimension("user5", new String[]{"e"}).setDimension("user6", new String[]{"f"}).setDimension("user7", new String[]{"g"}).setDimension("user8", new String[]{"h"}).setDimension("user9", new String[]{"i"}).setDimension("user10", new String[]{"j"}).build(DateTimes.utc((long)42L), "test-metric", (Number)1234).build("test", "localhost")).toMap());
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"metrics").put((Object)"timestamp", (Object)DateTimes.utc((long)42L).toString()).put((Object)"service", (Object)"test").put((Object)"host", (Object)"localhost").put((Object)"metric", (Object)"test-metric").put((Object)"foo", (Object)"bar").put((Object)"baz", Arrays.asList("foo", "qux")).put((Object)"value", (Object)1234).build(), (Object)((ServiceMetricEvent)ServiceMetricEvent.builder().setDimension("foo", (Object)"bar").setDimension("baz", new String[]{"foo", "qux"}).build(DateTimes.utc((long)42L), "test-metric", (Number)1234).build("test", "localhost")).toMap());
    }

    @Test(expected=IllegalStateException.class)
    public void testInfinite() {
        ServiceMetricEvent.builder().build("foo", (Number)Double.POSITIVE_INFINITY);
    }

    @Test(expected=IllegalStateException.class)
    public void testInfinite2() {
        ServiceMetricEvent.builder().build("foo", (Number)Float.valueOf(Float.POSITIVE_INFINITY));
    }

    @Test(expected=IllegalStateException.class)
    public void testNaN() {
        ServiceMetricEvent.builder().build("foo", (Number)Double.NaN);
    }

    @Test(expected=IllegalStateException.class)
    public void testNaN2() {
        ServiceMetricEvent.builder().build("foo", (Number)Float.valueOf(Float.NaN));
    }

    @Test
    public void testSetDimensionIfNotNullSetsNonNullDimension() {
        ImmutableMap userDimMap = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2");
        ServiceMetricEvent target = (ServiceMetricEvent)ServiceMetricEvent.builder().setDimensionIfNotNull("userDimMap", (Object)userDimMap).build("foo", (Number)1).build("service", "host");
        Assert.assertEquals((Object)userDimMap, target.getUserDims().get("userDimMap"));
    }

    @Test
    public void testSetDimensionIfNotNullShouldNotSetNullDimension() {
        ServiceMetricEvent target = (ServiceMetricEvent)ServiceMetricEvent.builder().setDimensionIfNotNull("userDimMap", null).build("foo", (Number)1).build("service", "host");
        Assert.assertTrue((boolean)target.getUserDims().isEmpty());
        Assert.assertNull(target.getUserDims().get("userDimMap"));
    }
}

