/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableList;
import io.timeandspace.cronscheduler.CronScheduler;
import io.timeandspace.cronscheduler.CronTask;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.ClockDriftSafeMonitorScheduler;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.java.util.metrics.MonitorSchedulerConfig;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class ClockDriftSafeMonitorSchedulerTest {
    private ExecutorService cronTaskRunner;
    @Mock
    private CronScheduler cronScheduler;
    private AutoCloseable mocks;

    @Before
    public void setUp() {
        this.cronTaskRunner = Execs.singleThreaded((String)"monitor-scheduler-test");
        this.mocks = MockitoAnnotations.openMocks((Object)this);
    }

    @After
    public void tearDown() throws Exception {
        this.cronTaskRunner.shutdownNow();
        this.mocks.close();
    }

    @Test
    public void testFindMonitor() {
        class Monitor1
        extends NoopMonitor {
            Monitor1() {
            }
        }
        Monitor1 monitor1 = new Monitor1();
        class Monitor2
        extends NoopMonitor {
            Monitor2() {
            }
        }
        Monitor2 monitor2 = new Monitor2();
        ExecutorService executor = (ExecutorService)Mockito.mock(ExecutorService.class);
        ClockDriftSafeMonitorScheduler scheduler = new ClockDriftSafeMonitorScheduler((MonitorSchedulerConfig)Mockito.mock(MonitorSchedulerConfig.class), (ServiceEmitter)Mockito.mock(ServiceEmitter.class), (List)ImmutableList.of((Object)monitor1, (Object)monitor2), CronScheduler.newBuilder((java.time.Duration)java.time.Duration.ofSeconds(1L)).setThreadName("monitor-scheduler-test").build(), executor);
        Optional maybeFound1 = scheduler.findMonitor(Monitor1.class);
        Optional maybeFound2 = scheduler.findMonitor(Monitor2.class);
        Assert.assertTrue((boolean)maybeFound1.isPresent());
        Assert.assertTrue((boolean)maybeFound2.isPresent());
        Assert.assertSame((Object)monitor1, maybeFound1.get());
        Assert.assertSame((Object)monitor2, maybeFound2.get());
        class Monitor3
        extends NoopMonitor {
            Monitor3() {
            }
        }
        Assert.assertFalse((boolean)scheduler.findMonitor(Monitor3.class).isPresent());
    }

    @Test
    public void testStart_RepeatScheduling() throws InterruptedException {
        final ExecutorService executor = (ExecutorService)Mockito.mock(ExecutorService.class);
        final CountDownLatch latch = new CountDownLatch(1);
        ((CronScheduler)Mockito.doAnswer((Answer)new Answer<Future<?>>(){
            private int scheduleCount = 0;

            public Future<?> answer(InvocationOnMock invocation) {
                Object originalArgument = invocation.getArguments()[3];
                CronTask task = (CronTask)originalArgument;
                ((ExecutorService)Mockito.doAnswer((Answer)new Answer<Future<?>>(){

                    public Future<Boolean> answer(InvocationOnMock invocation) throws Exception {
                        Object originalArgument = invocation.getArguments()[0];
                        ((Callable)originalArgument).call();
                        return CompletableFuture.completedFuture(Boolean.TRUE);
                    }
                }).when((Object)executor)).submit((Callable)ArgumentMatchers.any(Callable.class));
                ClockDriftSafeMonitorSchedulerTest.this.cronTaskRunner.submit(() -> {
                    while (this.scheduleCount < 2) {
                        ++this.scheduleCount;
                        task.run(123L);
                    }
                    latch.countDown();
                    return null;
                });
                return ClockDriftSafeMonitorSchedulerTest.this.createDummyFuture();
            }
        }).when((Object)this.cronScheduler)).scheduleAtFixedRate(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()), (CronTask)ArgumentMatchers.any(CronTask.class));
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        MonitorSchedulerConfig config = (MonitorSchedulerConfig)Mockito.mock(MonitorSchedulerConfig.class);
        Mockito.when((Object)config.getEmitterPeriod()).thenReturn((Object)new Duration(1000L));
        ClockDriftSafeMonitorScheduler scheduler = new ClockDriftSafeMonitorScheduler(config, (ServiceEmitter)Mockito.mock(ServiceEmitter.class), (List)ImmutableList.of((Object)monitor), this.cronScheduler, executor);
        scheduler.start();
        latch.await(5L, TimeUnit.SECONDS);
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).start();
        ((CronScheduler)Mockito.verify((Object)this.cronScheduler, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()), (CronTask)ArgumentMatchers.any(CronTask.class));
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)2))).submit((Callable)ArgumentMatchers.any(Callable.class));
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)2))).monitor((ServiceEmitter)ArgumentMatchers.any());
        scheduler.stop();
    }

    @Test
    public void testStart_RepeatAndStopScheduling() throws InterruptedException {
        final ExecutorService executor = (ExecutorService)Mockito.mock(ExecutorService.class);
        final CountDownLatch latch = new CountDownLatch(1);
        ((CronScheduler)Mockito.doAnswer((Answer)new Answer<Future<?>>(){
            private int scheduleCount = 0;

            public Future<?> answer(InvocationOnMock invocation) {
                Object originalArgument = invocation.getArguments()[3];
                CronTask task = (CronTask)originalArgument;
                ((ExecutorService)Mockito.doAnswer((Answer)new Answer<Future<?>>(){

                    public Future<Boolean> answer(InvocationOnMock invocation) throws Exception {
                        Object originalArgument = invocation.getArguments()[0];
                        ((Callable)originalArgument).call();
                        return CompletableFuture.completedFuture(Boolean.FALSE);
                    }
                }).when((Object)executor)).submit((Callable)ArgumentMatchers.any(Callable.class));
                ClockDriftSafeMonitorSchedulerTest.this.cronTaskRunner.submit(() -> {
                    while (this.scheduleCount < 2) {
                        ++this.scheduleCount;
                        task.run(123L);
                    }
                    latch.countDown();
                    return null;
                });
                return ClockDriftSafeMonitorSchedulerTest.this.createDummyFuture();
            }
        }).when((Object)this.cronScheduler)).scheduleAtFixedRate(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()), (CronTask)ArgumentMatchers.any(CronTask.class));
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        MonitorSchedulerConfig config = (MonitorSchedulerConfig)Mockito.mock(MonitorSchedulerConfig.class);
        Mockito.when((Object)config.getEmitterPeriod()).thenReturn((Object)new Duration(1000L));
        ClockDriftSafeMonitorScheduler scheduler = new ClockDriftSafeMonitorScheduler(config, (ServiceEmitter)Mockito.mock(ServiceEmitter.class), (List)ImmutableList.of((Object)monitor), this.cronScheduler, executor);
        scheduler.start();
        latch.await(5L, TimeUnit.SECONDS);
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).start();
        ((CronScheduler)Mockito.verify((Object)this.cronScheduler, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()), (CronTask)ArgumentMatchers.any(CronTask.class));
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).submit((Callable)ArgumentMatchers.any(Callable.class));
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)2))).monitor((ServiceEmitter)ArgumentMatchers.any());
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).stop();
        scheduler.stop();
    }

    @Test
    public void testStart_UnexpectedExceptionWhileMonitoring() throws InterruptedException {
        final ExecutorService executor = (ExecutorService)Mockito.mock(ExecutorService.class);
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        Mockito.when((Object)monitor.monitor((ServiceEmitter)ArgumentMatchers.any(ServiceEmitter.class))).thenThrow(new Throwable[]{new RuntimeException("Test throwing exception while monitoring")});
        MonitorSchedulerConfig config = (MonitorSchedulerConfig)Mockito.mock(MonitorSchedulerConfig.class);
        Mockito.when((Object)config.getEmitterPeriod()).thenReturn((Object)new Duration(1000L));
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean monitorResultHolder = new AtomicBoolean(false);
        ((CronScheduler)Mockito.doAnswer((Answer)new Answer<Future<?>>(){

            public Future<?> answer(InvocationOnMock invocation) {
                Object originalArgument = invocation.getArguments()[3];
                CronTask task = (CronTask)originalArgument;
                ((ExecutorService)Mockito.doAnswer((Answer)new Answer<Future<?>>(){

                    public Future<Boolean> answer(InvocationOnMock invocation) throws Exception {
                        Object originalArgument = invocation.getArguments()[0];
                        boolean continueMonitor = (Boolean)((Callable)originalArgument).call();
                        monitorResultHolder.set(continueMonitor);
                        return CompletableFuture.completedFuture(continueMonitor);
                    }
                }).when((Object)executor)).submit((Callable)ArgumentMatchers.any(Callable.class));
                ClockDriftSafeMonitorSchedulerTest.this.cronTaskRunner.submit(() -> {
                    task.run(123L);
                    latch.countDown();
                    return null;
                });
                return ClockDriftSafeMonitorSchedulerTest.this.createDummyFuture();
            }
        }).when((Object)this.cronScheduler)).scheduleAtFixedRate(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()), (CronTask)ArgumentMatchers.any(CronTask.class));
        ClockDriftSafeMonitorScheduler scheduler = new ClockDriftSafeMonitorScheduler(config, (ServiceEmitter)Mockito.mock(ServiceEmitter.class), (List)ImmutableList.of((Object)monitor), this.cronScheduler, executor);
        scheduler.start();
        latch.await(5L, TimeUnit.SECONDS);
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).start();
        ((CronScheduler)Mockito.verify((Object)this.cronScheduler, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()), (CronTask)ArgumentMatchers.any(CronTask.class));
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).submit((Callable)ArgumentMatchers.any(Callable.class));
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).monitor((ServiceEmitter)ArgumentMatchers.any());
        Assert.assertTrue((boolean)monitorResultHolder.get());
        scheduler.stop();
    }

    @Test
    public void testStart_UnexpectedExceptionWhileScheduling() throws InterruptedException {
        final ExecutorService executor = (ExecutorService)Mockito.mock(ExecutorService.class);
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        MonitorSchedulerConfig config = (MonitorSchedulerConfig)Mockito.mock(MonitorSchedulerConfig.class);
        Mockito.when((Object)config.getEmitterPeriod()).thenReturn((Object)new Duration(1000L));
        final CountDownLatch latch = new CountDownLatch(1);
        ((CronScheduler)Mockito.doAnswer((Answer)new Answer<Future<?>>(){

            public Future<?> answer(InvocationOnMock invocation) {
                Object originalArgument = invocation.getArguments()[3];
                CronTask task = (CronTask)originalArgument;
                Mockito.when(executor.submit((Callable)ArgumentMatchers.any(Callable.class))).thenThrow(new Throwable[]{new RuntimeException("Test throwing exception while scheduling")});
                ClockDriftSafeMonitorSchedulerTest.this.cronTaskRunner.submit(() -> {
                    task.run(123L);
                    latch.countDown();
                    return null;
                });
                return ClockDriftSafeMonitorSchedulerTest.this.createDummyFuture();
            }
        }).when((Object)this.cronScheduler)).scheduleAtFixedRate(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()), (CronTask)ArgumentMatchers.any(CronTask.class));
        ClockDriftSafeMonitorScheduler scheduler = new ClockDriftSafeMonitorScheduler(config, (ServiceEmitter)Mockito.mock(ServiceEmitter.class), (List)ImmutableList.of((Object)monitor), this.cronScheduler, executor);
        scheduler.start();
        latch.await(5L, TimeUnit.SECONDS);
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).start();
        ((CronScheduler)Mockito.verify((Object)this.cronScheduler, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()), (CronTask)ArgumentMatchers.any(CronTask.class));
        ((ExecutorService)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).submit((Callable)ArgumentMatchers.any(Callable.class));
        scheduler.stop();
    }

    private Future createDummyFuture() {
        Future future = new Future(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }

            public Object get() {
                return null;
            }

            public Object get(long timeout, TimeUnit unit) {
                return null;
            }
        };
        return future;
    }

    private static class NoopMonitor
    implements Monitor {
        private NoopMonitor() {
        }

        public void start() {
        }

        public void stop() {
        }

        public boolean monitor(ServiceEmitter emitter) {
            return true;
        }
    }
}

