/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import java.util.List;
import java.util.Map;
import org.junit.Assert;

public interface MetricsVerifier {
    default public void verifyNotEmitted(String metricName) {
        this.verifyEmitted(metricName, 0);
    }

    default public void verifyEmitted(String metricName, int times) {
        this.verifyEmitted(metricName, null, times);
    }

    default public void verifyEmitted(String metricName, Map<String, Object> dimensionFilters, int times) {
        Assert.assertEquals((String)"Metric was emitted unexpected number of times.", (long)times, (long)this.getMetricValues(metricName, dimensionFilters).size());
    }

    default public void verifyValue(String metricName, Number expectedValue) {
        this.verifyValue(metricName, null, expectedValue);
    }

    default public void verifyValue(String metricName, Map<String, Object> dimensionFilters, Number expectedValue) {
        Assert.assertEquals((Object)expectedValue, (Object)this.getValue(metricName, dimensionFilters));
    }

    default public Number getValue(String metricName, Map<String, Object> dimensionFilters) {
        List<Number> values = this.getMetricValues(metricName, dimensionFilters);
        Assert.assertEquals((String)"Metric must have been emitted exactly once for the given dimensions.", (long)1L, (long)values.size());
        return values.get(0);
    }

    public List<Number> getMetricValues(String var1, Map<String, Object> var2);
}

