/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import java.io.File;
import java.io.IOException;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.Cpu;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CpuTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private CgroupDiscoverer discoverer;

    @Before
    public void setUp() throws IOException {
        File cgroupDir = this.temporaryFolder.newFolder();
        File procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupDiscoverer(procDir.toPath());
        TestUtils.setUpCgroups(procDir, cgroupDir);
        File cpuDir = new File(cgroupDir, "cpu,cpuacct/system.slice/some.service/f12ba7e0-fa16-462e-bb9d-652ccc27f0ee");
        FileUtils.mkdirp((File)cpuDir);
        TestUtils.copyOrReplaceResource("/cpu.shares", new File(cpuDir, "cpu.shares"));
        TestUtils.copyOrReplaceResource("/cpu.cfs_quota_us", new File(cpuDir, "cpu.cfs_quota_us"));
        TestUtils.copyOrReplaceResource("/cpu.cfs_period_us", new File(cpuDir, "cpu.cfs_period_us"));
    }

    @Test
    public void testWontCrash() {
        Cpu cpu = new Cpu(cgroup -> {
            throw new RuntimeException("Should still continue");
        });
        Cpu.CpuAllocationMetric metric = cpu.snapshot();
        Assert.assertEquals((long)-1L, (long)metric.getShares());
        Assert.assertEquals((long)0L, (long)metric.getQuotaUs());
        Assert.assertEquals((long)0L, (long)metric.getPeriodUs());
    }

    @Test
    public void testSimpleLoad() {
        Cpu cpu = new Cpu(this.discoverer);
        Cpu.CpuAllocationMetric snapshot = cpu.snapshot();
        Assert.assertEquals((long)1024L, (long)snapshot.getShares());
        Assert.assertEquals((long)300000L, (long)snapshot.getQuotaUs());
        Assert.assertEquals((long)100000L, (long)snapshot.getPeriodUs());
    }
}

