/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;

public class TestUtils {
    public static void setUpCgroups(File procDir, File cgroupDir) throws IOException {
        File procMountsTemplate = new File(procDir, "mounts.template");
        File procMounts = new File(procDir, "mounts");
        TestUtils.copyResource("/proc.mounts", procMountsTemplate);
        String procMountsString = StringUtils.fromUtf8((byte[])Files.readAllBytes(procMountsTemplate.toPath()));
        Files.write(procMounts.toPath(), StringUtils.toUtf8((String)StringUtils.replace((String)procMountsString, (String)"/sys/fs/cgroup", (String)cgroupDir.getAbsolutePath())), new OpenOption[0]);
        FileUtils.mkdirp((File)new File(cgroupDir, "cpu,cpuacct/system.slice/some.service/f12ba7e0-fa16-462e-bb9d-652ccc27f0ee"));
        FileUtils.mkdirp((File)new File(cgroupDir, "cpuset/system.slice/some.service/f12ba7e0-fa16-462e-bb9d-652ccc27f0ee"));
        TestUtils.copyResource("/proc.pid.cgroup", new File(procDir, "cgroup"));
    }

    public static void copyResource(String resource, File out) throws IOException {
        Files.copy(TestUtils.class.getResourceAsStream(resource), out.toPath(), new CopyOption[0]);
        Assert.assertTrue((boolean)out.exists());
        Assert.assertNotEquals((long)0L, (long)out.length());
    }

    public static void copyOrReplaceResource(String resource, File out) throws IOException {
        Files.copy(TestUtils.class.getResourceAsStream(resource), out.toPath(), new CopyOption[0]);
        Assert.assertTrue((boolean)out.exists());
        Assert.assertNotEquals((long)0L, (long)out.length());
    }
}

