/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionValidationException;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ApplyFunctionTest
extends InitializedNullHandlingTest {
    private Expr.ObjectBinding bindings;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"x", (Object)"foo");
        builder.put((Object)"y", (Object)2);
        builder.put((Object)"z", (Object)3.1);
        builder.put((Object)"a", (Object)new String[]{"foo", "bar", "baz", "foobar"});
        builder.put((Object)"b", (Object)new Long[]{1L, 2L, 3L, 4L, 5L});
        builder.put((Object)"c", (Object)new Double[]{3.1, 4.2, 5.3});
        builder.put((Object)"d", (Object)new String[]{null});
        builder.put((Object)"e", (Object)new String[]{null, "foo", "bar"});
        builder.put((Object)"f", (Object)new String[0]);
        this.bindings = InputBindings.forMap((Map)builder.build());
    }

    @Test
    public void testMap() {
        this.assertExpr("map((x) -> concat(x, 'foo'), ['foo', 'bar', 'baz', 'foobar'])", new String[]{"foofoo", "barfoo", "bazfoo", "foobarfoo"});
        this.assertExpr("map((x) -> concat(x, 'foo'), a)", new String[]{"foofoo", "barfoo", "bazfoo", "foobarfoo"});
        this.assertExpr("map((x) -> x + 1, [1, 2, 3, 4, 5])", new Long[]{2L, 3L, 4L, 5L, 6L});
        this.assertExpr("map((x) -> x + 1, b)", new Long[]{2L, 3L, 4L, 5L, 6L});
        this.assertExpr("map((c) -> c + z, [3.1, 4.2, 5.3])", new Double[]{6.2, 7.3, 8.4});
        this.assertExpr("map((c) -> c + z, c)", new Double[]{6.2, 7.3, 8.4});
        this.assertExpr("map((x) -> x + 1, map((x) -> x + 1, [1, 2, 3, 4, 5]))", new Long[]{3L, 4L, 5L, 6L, 7L});
        this.assertExpr("map((x) -> x + 1, map((x) -> x + 1, b))", new Long[]{3L, 4L, 5L, 6L, 7L});
        this.assertExpr("map((x) -> 1, [1, 2, 3, 4, 5])", new Long[]{1L, 1L, 1L, 1L, 1L});
    }

    @Test
    public void testCartesianMap() {
        this.assertExpr("cartesian_map((x, y) -> concat(x, y), ['foo', 'bar', 'baz', 'foobar'], ['bar', 'baz'])", new String[]{"foobar", "foobaz", "barbar", "barbaz", "bazbar", "bazbaz", "foobarbar", "foobarbaz"});
        this.assertExpr("cartesian_map((x, y, z) -> concat(concat(x, y), z), ['foo', 'bar', 'baz', 'foobar'], ['bar', 'baz'], ['omg'])", new String[]{"foobaromg", "foobazomg", "barbaromg", "barbazomg", "bazbaromg", "bazbazomg", "foobarbaromg", "foobarbazomg"});
        this.assertExpr("cartesian_map((x, y) -> 1, [1, 2], [1, 2, 3])", new Long[]{1L, 1L, 1L, 1L, 1L, 1L});
        this.assertExpr("cartesian_map((x, y) -> concat(x, y), d, d)", new String[]{null});
        this.assertExpr("cartesian_map((x, y) -> concat(x, y), d, f)", new String[0]);
        if (NullHandling.replaceWithDefault()) {
            this.assertExpr("cartesian_map((x, y) -> concat(x, y), d, e)", new String[]{null, "foo", "bar"});
            this.assertExpr("cartesian_map((x, y) -> concat(x, y), e, e)", new String[]{null, "foo", "bar", "foo", "foofoo", "foobar", "bar", "barfoo", "barbar"});
        } else {
            this.assertExpr("cartesian_map((x, y) -> concat(x, y), d, e)", new String[]{null, null, null});
            this.assertExpr("cartesian_map((x, y) -> concat(x, y), e, e)", new String[]{null, null, null, null, "foofoo", "foobar", null, "barfoo", "barbar"});
        }
    }

    @Test
    public void testFilter() {
        this.assertExpr("filter((x) -> strlen(x) > 3, ['foo', 'bar', 'baz', 'foobar'])", new String[]{"foobar"});
        this.assertExpr("filter((x) -> strlen(x) > 3, a)", new String[]{"foobar"});
        this.assertExpr("filter((x) -> x > 2, [1, 2, 3, 4, 5])", new Long[]{3L, 4L, 5L});
        this.assertExpr("filter((x) -> x > 2, b)", new Long[]{3L, 4L, 5L});
    }

    @Test
    public void testFold() {
        this.assertExpr("fold((x, y) -> x + y, [1, 1, 1, 1, 1], 0)", 5L);
        this.assertExpr("fold((b, acc) -> b * acc, map((b) -> b * 2, filter(b -> b > 3, b)), 1)", 80L);
        this.assertExpr("fold((a, acc) -> concat(a, acc), a, '')", "foobarbazbarfoo");
        this.assertExpr("fold((a, acc) -> array_append(acc, a), a, [])", new String[]{"foo", "bar", "baz", "foobar"});
        this.assertExpr("fold((a, acc) -> array_append(acc, a), b, <LONG>[])", new Long[]{1L, 2L, 3L, 4L, 5L});
    }

    @Test
    public void testCartesianFold() {
        this.assertExpr("cartesian_fold((x, y, acc) -> x + y + acc, [1, 1, 1, 1, 1], [1, 1], 0)", 20L);
    }

    @Test
    public void testAnyMatch() {
        this.assertExpr("any(x -> x > 3, [1, 2, 3, 4])", 1L);
        this.assertExpr("any(x -> x > 3, [1, 2, 3])", 0L);
        this.assertExpr("any(x -> x, map(x -> x > 3, [1, 2, 3, 4]))", 1L);
        this.assertExpr("any(x -> x, map(x -> x > 3, [1, 2, 3]))", 0L);
    }

    @Test
    public void testAllMatch() {
        this.assertExpr("all(x -> x > 0, [1, 2, 3, 4])", 1L);
        this.assertExpr("all(x -> x > 1, [1, 2, 3, 4])", 0L);
        this.assertExpr("all(x -> x, map(x -> x > 0, [1, 2, 3, 4]))", 1L);
        this.assertExpr("all(x -> x, map(x -> x > 1, [1, 2, 3, 4]))", 0L);
    }

    @Test
    public void testScoping() {
        this.assertExpr("map(b -> b + 1, b)", new Long[]{2L, 3L, 4L, 5L, 6L});
        this.assertExpr("fold((b, acc) -> acc + b, map(b -> b + 1, b), 0)", 20L);
        this.assertExpr("fold((b, acc) -> acc + b, map(b -> b + 1, b), fold((b, acc) -> acc + b, map(b -> b + 1, b), 0))", 40L);
        this.assertExpr("fold((b, acc) -> acc + b, map(b -> b + 1, b), 0) + fold((b, acc) -> acc + b, map(b -> b + 1, b), 0)", 40L);
        this.assertExpr("fold((b, acc) -> acc + b, map(b -> b + 1, b), fold((b, acc) -> acc + b, map(b -> b + 1, b), 0) + fold((b, acc) -> acc + b, map(b -> b + 1, b), 0))", 60L);
    }

    @Test
    public void testInvalidArgCountFold() {
        this.expectedException.expect(ExpressionValidationException.class);
        this.expectedException.expectMessage("Function[fold] requires 3 arguments");
        this.assertExpr("fold((x, y) -> x + 1, [1, 1, 1, 1, 1])", (Double[])null);
    }

    @Test
    public void testInvalidArgCountFoldLambda() {
        this.expectedException.expect(ExpressionValidationException.class);
        this.expectedException.expectMessage("Function[fold] lambda expression argument count of 0 does not match the 2 arguments passed to it");
        this.assertExpr("fold(() -> 1, [1, 1, 1, 1, 1], 0)", (Double[])null);
    }

    @Test
    public void testInvalidArgCountCartesianFoldLambda() {
        this.expectedException.expect(ExpressionValidationException.class);
        this.expectedException.expectMessage("Function[cartesian_fold] lambda expression argument count of 0 does not match the 3 arguments passed to it");
        this.assertExpr("cartesian_fold(() -> 1, [1, 1, 1, 1, 1], [1, 1], 0)", (Double[])null);
    }

    @Test
    public void testInvalidArgCountAny() {
        this.expectedException.expect(ExpressionValidationException.class);
        this.expectedException.expectMessage("Function[any] requires 2 arguments");
        this.assertExpr("any((x) -> 1, [1, 2, 3, 4], y)", (Double[])null);
    }

    @Test
    public void testInvalidArgCountAnyLambda() {
        this.expectedException.expect(ExpressionValidationException.class);
        this.expectedException.expectMessage("Function[any] lambda expression argument count of 0 does not match the 1 arguments passed to it");
        this.assertExpr("any(() -> 1, [1, 2, 3, 4])", (Double[])null);
    }

    @Test
    public void testInvalidArgCountAll() {
        this.expectedException.expect(ExpressionValidationException.class);
        this.expectedException.expectMessage("Function[all] requires 2 arguments");
        this.assertExpr("all((x) -> 0, [1, 2, 3, 4], y)", (Double[])null);
    }

    @Test
    public void testInvalidArgCountAllLambda() {
        this.expectedException.expect(ExpressionValidationException.class);
        this.expectedException.expectMessage("Function[all] lambda expression argument count of 0 does not match the 1 arguments passed to it");
        this.assertExpr("all(() -> 0, [1, 2, 3, 4])", (Double[])null);
    }

    private void assertExpr(String expression, Object expectedResult) {
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil());
        Assert.assertEquals((String)expression, (Object)expectedResult, (Object)expr.eval(this.bindings).value());
        Expr exprNoFlatten = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil(), (boolean)false);
        Expr roundTrip = Parser.parse((String)exprNoFlatten.stringify(), (ExprMacroTable)ExprMacroTable.nil());
        Assert.assertEquals((String)expr.stringify(), (Object)expectedResult, (Object)roundTrip.eval(this.bindings).value());
        Expr roundTripFlatten = Parser.parse((String)expr.stringify(), (ExprMacroTable)ExprMacroTable.nil());
        Assert.assertEquals((String)expr.stringify(), (Object)expectedResult, (Object)roundTripFlatten.eval(this.bindings).value());
        Assert.assertEquals((Object)expr.stringify(), (Object)roundTrip.stringify());
        Assert.assertEquals((Object)expr.stringify(), (Object)roundTripFlatten.stringify());
        Assert.assertArrayEquals((byte[])expr.getCacheKey(), (byte[])roundTrip.getCacheKey());
        Assert.assertArrayEquals((byte[])expr.getCacheKey(), (byte[])roundTripFlatten.getCacheKey());
    }

    private void assertExpr(String expression, Object[] expectedResult) {
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil());
        Object[] result = expr.eval(this.bindings).asArray();
        if (expectedResult.length != 0 || result == null || result.length != 0) {
            Assert.assertArrayEquals((String)expression, (Object[])expectedResult, (Object[])result);
        }
        Expr exprNoFlatten = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil(), (boolean)false);
        Expr roundTrip = Parser.parse((String)exprNoFlatten.stringify(), (ExprMacroTable)ExprMacroTable.nil());
        Object[] resultRoundTrip = roundTrip.eval(this.bindings).asArray();
        if (expectedResult.length != 0 || resultRoundTrip == null || resultRoundTrip.length != 0) {
            Assert.assertArrayEquals((String)expr.stringify(), (Object[])expectedResult, (Object[])resultRoundTrip);
        }
        Expr roundTripFlatten = Parser.parse((String)expr.stringify(), (ExprMacroTable)ExprMacroTable.nil());
        Object[] resultRoundTripFlatten = roundTripFlatten.eval(this.bindings).asArray();
        if (expectedResult.length != 0 || resultRoundTripFlatten == null || resultRoundTripFlatten.length != 0) {
            Assert.assertArrayEquals((String)expr.stringify(), (Object[])expectedResult, (Object[])resultRoundTripFlatten);
        }
        Assert.assertEquals((Object)expr.stringify(), (Object)roundTrip.stringify());
        Assert.assertEquals((Object)expr.stringify(), (Object)roundTripFlatten.stringify());
        Assert.assertArrayEquals((byte[])expr.getCacheKey(), (byte[])roundTrip.getCacheKey());
        Assert.assertArrayEquals((byte[])expr.getCacheKey(), (byte[])roundTripFlatten.getCacheKey());
    }

    private void assertExpr(String expression, Double[] expectedResult) {
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil());
        Object[] result = expr.eval(this.bindings).asArray();
        Assert.assertEquals((long)expectedResult.length, (long)result.length);
        for (int i = 0; i < result.length; ++i) {
            Assert.assertEquals((String)expression, (double)expectedResult[i], (double)((Double)result[i]), (double)1.0E-5);
        }
        Expr exprNoFlatten = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil(), (boolean)false);
        Expr roundTrip = Parser.parse((String)exprNoFlatten.stringify(), (ExprMacroTable)ExprMacroTable.nil());
        Object[] resultRoundTrip = (Object[])roundTrip.eval(this.bindings).value();
        Assert.assertEquals((long)expectedResult.length, (long)resultRoundTrip.length);
        for (int i = 0; i < resultRoundTrip.length; ++i) {
            Assert.assertEquals((String)expression, (double)expectedResult[i], (double)((Double)resultRoundTrip[i]), (double)1.0E-5);
        }
        Expr roundTripFlatten = Parser.parse((String)expr.stringify(), (ExprMacroTable)ExprMacroTable.nil());
        Object[] resultRoundTripFlatten = (Object[])roundTripFlatten.eval(this.bindings).value();
        Assert.assertEquals((long)expectedResult.length, (long)resultRoundTripFlatten.length);
        for (int i = 0; i < resultRoundTripFlatten.length; ++i) {
            Assert.assertEquals((String)expression, (double)expectedResult[i], (double)((Double)resultRoundTripFlatten[i]), (double)1.0E-5);
        }
        Assert.assertEquals((Object)expr.stringify(), (Object)roundTrip.stringify());
        Assert.assertEquals((Object)expr.stringify(), (Object)roundTripFlatten.stringify());
        Assert.assertArrayEquals((byte[])expr.getCacheKey(), (byte[])roundTrip.getCacheKey());
        Assert.assertArrayEquals((byte[])expr.getCacheKey(), (byte[])roundTripFlatten.getCacheKey());
    }
}

