/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.metadata.TaskLookup;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class TaskLookupTest {

    public static class ActiveTaskLookupTest {
        @Test
        public void testSingleton() {
            TaskLookup.ActiveTaskLookup lookup1 = TaskLookup.ActiveTaskLookup.getInstance();
            TaskLookup.ActiveTaskLookup lookup2 = TaskLookup.ActiveTaskLookup.getInstance();
            Assert.assertEquals((Object)lookup1, (Object)lookup2);
            Assert.assertSame((Object)lookup1, (Object)lookup2);
        }

        @Test
        public void testGetType() {
            Assert.assertEquals((Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance().getType());
        }
    }

    public static class CompleteTaskLookupTest {
        @Test
        public void testEquals() {
            EqualsVerifier.forClass(TaskLookup.CompleteTaskLookup.class).usingGetClass().verify();
        }

        @Test
        public void testGetType() {
            Assert.assertEquals((Object)TaskLookup.TaskLookupType.COMPLETE, (Object)TaskLookup.CompleteTaskLookup.of(null, null).getType());
        }

        @Test
        public void testNullParams() {
            TaskLookup.CompleteTaskLookup lookup = TaskLookup.CompleteTaskLookup.of(null, null);
            Assert.assertNull((Object)lookup.getMaxTaskStatuses());
            Assert.assertFalse((boolean)lookup.hasTaskCreatedTimeFilter());
            Assert.assertThrows(AssertionError.class, () -> ((TaskLookup.CompleteTaskLookup)lookup).getTasksCreatedPriorTo());
        }

        @Test
        public void testWithDurationBeforeNow() {
            Duration duration = new Period((Object)"P1D").toStandardDuration();
            DateTime timestampBeforeLookupCreated = DateTimes.nowUtc().minus((ReadableDuration)duration);
            TaskLookup.CompleteTaskLookup lookup = TaskLookup.CompleteTaskLookup.of(null, null).withDurationBeforeNow(duration);
            Assert.assertNull((Object)lookup.getMaxTaskStatuses());
            Assert.assertTrue((timestampBeforeLookupCreated.isEqual((ReadableInstant)lookup.getTasksCreatedPriorTo()) || timestampBeforeLookupCreated.isBefore((ReadableInstant)lookup.getTasksCreatedPriorTo()) ? 1 : 0) != 0);
        }

        @Test
        public void testNonNullParams() {
            Duration duration = new Period((Object)"P1D").toStandardDuration();
            DateTime timestampBeforeLookupCreated = DateTimes.nowUtc().minus((ReadableDuration)duration);
            TaskLookup.CompleteTaskLookup lookup = TaskLookup.CompleteTaskLookup.of((Integer)3, (Duration)duration);
            Assert.assertNotNull((Object)lookup.getMaxTaskStatuses());
            Assert.assertEquals((long)3L, (long)lookup.getMaxTaskStatuses().intValue());
            Assert.assertTrue((boolean)lookup.hasTaskCreatedTimeFilter());
            Assert.assertTrue((timestampBeforeLookupCreated.isEqual((ReadableInstant)lookup.getTasksCreatedPriorTo()) || timestampBeforeLookupCreated.isBefore((ReadableInstant)lookup.getTasksCreatedPriorTo()) ? 1 : 0) != 0);
        }
    }
}

