/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Properties;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.config.Config;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.utils.JvmUtils;
import org.apache.druid.utils.RuntimeInfo;
import org.hamcrest.CoreMatchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.skife.config.ConfigurationObjectFactory;

public class DruidProcessingConfigTest {
    private static final long BUFFER_SIZE = 0x40000000L;
    private static final int NUM_PROCESSORS = 4;
    private static final long DIRECT_SIZE = 0x180000000L;
    private static final long HEAP_SIZE = 0x80000000L;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private static Injector makeInjector(int numProcessors, long directMemorySize, long heapSize) {
        return DruidProcessingConfigTest.makeInjector(numProcessors, directMemorySize, heapSize, new Properties(), null);
    }

    @AfterClass
    public static void teardown() {
        JvmUtils.resetTestsToDefaultRuntimeInfo();
    }

    private static Injector makeInjector(int numProcessors, long directMemorySize, long heapSize, Properties props, Map<String, String> replacements) {
        return Guice.createInjector((Module[])new Module[]{binder -> {
            binder.bind(RuntimeInfo.class).toInstance((Object)new MockRuntimeInfo(numProcessors, directMemorySize, heapSize));
            binder.requestStaticInjection(new Class[]{JvmUtils.class});
            ConfigurationObjectFactory factory = Config.createFactory((Properties)props);
            DruidProcessingConfig config = replacements != null ? (DruidProcessingConfig)factory.buildWithReplacements(DruidProcessingConfig.class, replacements) : (DruidProcessingConfig)factory.build(DruidProcessingConfig.class);
            binder.bind(ConfigurationObjectFactory.class).toInstance((Object)factory);
            binder.bind(DruidProcessingConfig.class).toInstance((Object)config);
        }});
    }

    @Test
    public void testDefaultsMultiProcessor() {
        Injector injector = DruidProcessingConfigTest.makeInjector(4, 0x180000000L, 0x80000000L);
        DruidProcessingConfig config = (DruidProcessingConfig)injector.getInstance(DruidProcessingConfig.class);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)config.poolCacheMaxCount());
        Assert.assertEquals((long)3L, (long)config.getNumThreads());
        Assert.assertEquals((long)Math.max(2, config.getNumThreads() / 4), (long)config.getNumMergeBuffers());
        Assert.assertEquals((long)0L, (long)config.columnCacheSizeBytes());
        Assert.assertTrue((boolean)config.isFifo());
        Assert.assertEquals((Object)System.getProperty("java.io.tmpdir"), (Object)config.getTmpDir());
        Assert.assertEquals((long)0x40000000L, (long)config.intermediateComputeSizeBytes());
    }

    @Test
    public void testDefaultsSingleProcessor() {
        Injector injector = DruidProcessingConfigTest.makeInjector(1, 0x100000000L, 0x80000000L);
        DruidProcessingConfig config = (DruidProcessingConfig)injector.getInstance(DruidProcessingConfig.class);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)config.poolCacheMaxCount());
        Assert.assertTrue((config.getNumThreads() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)Math.max(2, config.getNumThreads() / 4), (long)config.getNumMergeBuffers());
        Assert.assertEquals((long)0L, (long)config.columnCacheSizeBytes());
        Assert.assertTrue((boolean)config.isFifo());
        Assert.assertEquals((Object)System.getProperty("java.io.tmpdir"), (Object)config.getTmpDir());
        Assert.assertEquals((long)0x40000000L, (long)config.intermediateComputeSizeBytes());
    }

    @Test
    public void testDefaultsLargeDirect() {
        Injector injector = DruidProcessingConfigTest.makeInjector(1, 0x1900000000L, 0x80000000L);
        DruidProcessingConfig config = (DruidProcessingConfig)injector.getInstance(DruidProcessingConfig.class);
        Assert.assertEquals((long)0x40000000L, (long)config.intermediateComputeSizeBytes());
    }

    @Test
    public void testReplacements() {
        Properties props = new Properties();
        props.setProperty("druid.processing.buffer.sizeBytes", "1");
        props.setProperty("druid.processing.buffer.poolCacheMaxCount", "1");
        props.setProperty("druid.processing.numThreads", "256");
        props.setProperty("druid.processing.columnCache.sizeBytes", "1");
        props.setProperty("druid.processing.fifo", "false");
        props.setProperty("druid.processing.tmpDir", "/test/path");
        Injector injector = DruidProcessingConfigTest.makeInjector(4, 0x180000000L, 0x80000000L, props, (Map<String, String>)ImmutableMap.of((Object)"base_path", (Object)"druid.processing"));
        DruidProcessingConfig config = (DruidProcessingConfig)injector.getInstance(DruidProcessingConfig.class);
        Assert.assertEquals((long)1L, (long)config.intermediateComputeSizeBytes());
        Assert.assertEquals((long)1L, (long)config.poolCacheMaxCount());
        Assert.assertEquals((long)256L, (long)config.getNumThreads());
        Assert.assertEquals((long)64L, (long)config.getNumMergeBuffers());
        Assert.assertEquals((long)1L, (long)config.columnCacheSizeBytes());
        Assert.assertFalse((boolean)config.isFifo());
        Assert.assertEquals((Object)"/test/path", (Object)config.getTmpDir());
        Assert.assertEquals((long)0L, (long)config.getNumInitalBuffersForIntermediatePool());
    }

    @Test
    public void testInvalidSizeBytes() {
        Properties props = new Properties();
        props.setProperty("druid.processing.buffer.sizeBytes", "-1");
        this.expectedException.expectCause(CoreMatchers.isA(IAE.class));
        Injector injector = DruidProcessingConfigTest.makeInjector(4, 0x180000000L, 0x80000000L, props, (Map<String, String>)ImmutableMap.of((Object)"base_path", (Object)"druid.processing"));
    }

    @Test
    public void testSizeBytesUpperLimit() {
        Properties props = new Properties();
        props.setProperty("druid.processing.buffer.sizeBytes", "2GiB");
        Injector injector = DruidProcessingConfigTest.makeInjector(4, 0x180000000L, 0x80000000L, props, (Map<String, String>)ImmutableMap.of((Object)"base_path", (Object)"druid.processing"));
        DruidProcessingConfig config = (DruidProcessingConfig)injector.getInstance(DruidProcessingConfig.class);
        this.expectedException.expectMessage("druid.processing.buffer.sizeBytes must be less than 2GiB");
        config.intermediateComputeSizeBytes();
    }

    public static class MockRuntimeInfo
    extends RuntimeInfo {
        private final int availableProcessors;
        private final long maxHeapSize;
        private final long directSize;

        public MockRuntimeInfo(int availableProcessors, long directSize, long maxHeapSize) {
            this.availableProcessors = availableProcessors;
            this.directSize = directSize;
            this.maxHeapSize = maxHeapSize;
        }

        public int getAvailableProcessors() {
            return this.availableProcessors;
        }

        public long getMaxHeapSizeBytes() {
            return this.maxHeapSize;
        }

        public long getDirectMemorySizeBytes() {
            return this.directSize;
        }
    }
}

