/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.TestQueryRunners;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.druid.query.dimension.RegexFilteredDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiValuedDimensionTest
extends InitializedNullHandlingTest {
    private final AggregationTestHelper helper;
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    private IncrementalIndex incrementalIndex;
    private QueryableIndex queryableIndex;
    private File persistedSegmentDir;
    private IncrementalIndex incrementalIndexNullSampler;
    private QueryableIndex queryableIndexNullSampler;
    private File persistedSegmentDirNullSampler;
    private final GroupByQueryConfig config;
    private final ImmutableMap<String, Object> context;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Parameterized.Parameters(name="groupby: {0} forceHashAggregation: {2} ({1})")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            constructors.add(new Object[]{config, TmpFileSegmentWriteOutMediumFactory.instance(), false});
            constructors.add(new Object[]{config, OffHeapMemorySegmentWriteOutMediumFactory.instance(), false});
            constructors.add(new Object[]{config, TmpFileSegmentWriteOutMediumFactory.instance(), true});
            constructors.add(new Object[]{config, OffHeapMemorySegmentWriteOutMediumFactory.instance(), true});
        }
        return constructors;
    }

    public MultiValuedDimensionTest(GroupByQueryConfig config, SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, boolean forceHashAggregation) {
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper((List<? extends Module>)ImmutableList.of(), config, null);
        this.config = config;
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        this.context = config.getDefaultStrategy().equals("v1") ? ImmutableMap.of() : ImmutableMap.of((Object)"forceHashAggregation", (Object)forceHashAggregation);
    }

    @Before
    public void setup() throws Exception {
        String[] rowsNullSampler;
        String[] rows;
        this.incrementalIndex = new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setMaxRowCount(5000).build();
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new CSVParseSpec(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"product", (Object)"tags", (Object)"othertags"))), "\t", (List)ImmutableList.of((Object)"timestamp", (Object)"product", (Object)"tags", (Object)"othertags"), false, 0), "UTF-8");
        for (String row : rows = new String[]{"2011-01-12T00:00:00.000Z,product_1,t1\tt2\tt3,u1\tu2", "2011-01-13T00:00:00.000Z,product_2,t3\tt4\tt5,u3\tu4", "2011-01-14T00:00:00.000Z,product_3,t5\tt6\tt7,u1\tu5", "2011-01-14T00:00:00.000Z,product_4,\"\",u2"}) {
            this.incrementalIndex.add(parser.parse(row));
        }
        this.persistedSegmentDir = FileUtils.createTempDir();
        TestHelper.getTestIndexMergerV9(this.segmentWriteOutMediumFactory).persist(this.incrementalIndex, this.persistedSegmentDir, IndexSpec.DEFAULT, null);
        this.queryableIndex = TestHelper.getTestIndexIO().loadIndex(this.persistedSegmentDir);
        StringInputRowParser parserNullSampler = new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"product", (Object)"tags", (Object)"othertags")))), "UTF-8");
        this.incrementalIndexNullSampler = new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setMaxRowCount(5000).build();
        for (String row : rowsNullSampler = new String[]{"{\"time\":\"2011-01-13T00:00:00.000Z\",\"product\":\"product_1\",\"tags\":[],\"othertags\":[\"u1\", \"u2\"]}", "{\"time\":\"2011-01-12T00:00:00.000Z\",\"product\":\"product_2\",\"othertags\":[\"u3\", \"u4\"]}", "{\"time\":\"2011-01-14T00:00:00.000Z\",\"product\":\"product_3\",\"tags\":[\"\"],\"othertags\":[\"u1\", \"u5\"]}", "{\"time\":\"2011-01-15T00:00:00.000Z\",\"product\":\"product_4\",\"tags\":[\"t1\", \"t2\", \"\"],\"othertags\":[\"u6\", \"u7\"]}", "{\"time\":\"2011-01-16T00:00:00.000Z\",\"product\":\"product_5\",\"tags\":[],\"othertags\":[]}", "{\"time\":\"2011-01-16T00:00:00.000Z\",\"product\":\"product_6\"}", "{\"time\":\"2011-01-16T00:00:00.000Z\",\"product\":\"product_7\",\"othertags\":[]}", "{\"time\":\"2011-01-16T00:00:00.000Z\",\"product\":\"product_8\",\"tags\":[\"\"],\"othertags\":[]}"}) {
            this.incrementalIndexNullSampler.add(parserNullSampler.parse(row));
        }
        this.persistedSegmentDirNullSampler = FileUtils.createTempDir();
        TestHelper.getTestIndexMergerV9(this.segmentWriteOutMediumFactory).persist(this.incrementalIndexNullSampler, this.persistedSegmentDirNullSampler, IndexSpec.DEFAULT, null);
        this.queryableIndexNullSampler = TestHelper.getTestIndexIO().loadIndex(this.persistedSegmentDirNullSampler);
    }

    @After
    public void teardown() throws IOException {
        this.helper.close();
    }

    @Test
    public void testGroupByNoFilter() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tags", "tags")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tags", NullHandling.replaceWithDefault() ? null : "", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tags", "t1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tags", "t2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tags", "t3", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tags", "t4", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tags", "t5", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tags", "t6", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tags", "t7", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "noFilter");
    }

    @Test
    public void testGroupByWithDimFilter() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tags", "tags")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setDimFilter((DimFilter)new SelectorDimFilter("tags", "t3", null)).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", "t1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", "t2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", "t3", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", "t4", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", "t5", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "dimFilter");
    }

    @Test
    public void testGroupByWithDimFilterEmptyResults() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tags", "tags")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setDimFilter((DimFilter)new InDimFilter("product", (Collection)ImmutableList.of((Object)"product_5"), null)).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndexNullSampler, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndexNullSampler, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", null, "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "filter-empty");
    }

    @Test
    public void testGroupByWithDimFilterNullishResults() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tags", "tags")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setDimFilter((DimFilter)new InDimFilter("product", (Collection)ImmutableList.of((Object)"product_5", (Object)"product_6", (Object)"product_8"), null)).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndexNullSampler, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndexNullSampler, SegmentId.dummy((String)"sid2"))), query);
        ImmutableList expectedResults = NullHandling.replaceWithDefault() ? Collections.singletonList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", null, "count", 6L)) : ImmutableList.of((Object)GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", null, "count", 4L), (Object)GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", "", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "filter-nullish");
    }

    @Test
    public void testGroupByWithDimFilterAndWithFilteredDimSpec() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("tags", "tags"), "t3")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setDimFilter((DimFilter)new SelectorDimFilter("tags", "t3", null)).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Collections.singletonList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", "t3", "count", 4L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "filteredDim");
    }

    @Test
    public void testGroupByExpression() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("texpr", "texpr")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "map(x -> concat(x, 'foo'), tags)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", NullHandling.sqlCompatible() ? "foo" : null, "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t3foo", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t4foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t5foo", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t6foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t7foo", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr");
    }

    @Test
    public void testGroupByExpressionMultiMulti() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("texpr", "texpr")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "cartesian_map((x,y) -> concat(x, y), tags, othertags)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setLimit(5).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = NullHandling.sqlCompatible() ? Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t3u1", "count", 2L)) : Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", null, "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u2", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-multi-multi");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupByExpressionMultiMultiBackwardsCompat0dot22andOlder() {
        try {
            ExpressionProcessing.initializeForHomogenizeNullMultiValueStrings();
            if (this.config.getDefaultStrategy().equals("v1")) {
                this.expectedException.expect(RuntimeException.class);
                this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
            }
            GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("texpr", "texpr")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "cartesian_map((x,y) -> concat(x, y), tags, othertags)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setLimit(5).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
            Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
            List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t3u1", "count", 2L));
            TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-multi-multi");
        }
        finally {
            ExpressionProcessing.initializeForTests();
        }
    }

    @Test
    public void testGroupByExpressionMultiMultiAuto() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("texpr", "texpr")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "map((x) -> concat(x, othertags), tags)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setLimit(5).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t3u1", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-multi-multi-auto");
    }

    @Test
    public void testGroupByExpressionMultiMultiAutoAuto() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("texpr", "texpr")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "concat(tags, othertags)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setLimit(5).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t3u1", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-multi-multi-auto-auto");
    }

    @Test
    public void testGroupByExpressionMultiMultiAutoAutoDupeIdentifier() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("texpr", "texpr")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "concat(tags, tags)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("count", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(5))).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t3t3", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t5t5", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", NullHandling.emptyToNullIfNeeded((String)""), "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1t1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2t2", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-multi-multi-auto-auto-self");
    }

    @Test
    public void testGroupByExpressionMultiMultiAutoAutoWithFilter() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("texpr", "texpr")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "concat(tags, othertags)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setDimFilter((DimFilter)new SelectorDimFilter("texpr", "t1u1", null)).setLimit(5).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t1u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t2u2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "texpr", "t3u1", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-multi-multi-auto-auto");
    }

    @Test
    public void testGroupByExpressionAuto() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tt", "tt")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("tt", "concat(tags, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "t1foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "t2foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "t3foo", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "t4foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "t5foo", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "t6foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "t7foo", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-auto");
    }

    @Test
    public void testGroupByExpressionArrayExpressionFilter() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tt", "tt", ColumnType.LONG)}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("tt", "array_offset_of(tags, 't2')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = NullHandling.replaceWithDefault() ? Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", -1L, "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", 0L, "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", 1L, "count", 2L)) : Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", null, "count", 6L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", 1L, "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-auto");
    }

    @Test
    public void testGroupByExpressionArrayFnArg() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tt", "tt")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("tt", "array_to_string(map(tags -> concat('foo', tags), tags), ', ')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", NullHandling.replaceWithDefault() ? null : "foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foot1, foot2, foot3", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foot3, foot4, foot5", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foot5, foot6, foot7", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-array-fn");
    }

    @Test
    public void testGroupByExpressionAutoArrayFnArg() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tt", "tt")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("tt", "array_to_string(concat('foo', tags), ', ')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foot1, foot2, foot3", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foot3, foot4, foot5", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foot5, foot6, foot7", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-arrayfn-auto");
    }

    @Test
    public void testGroupByExpressionFoldArrayToString() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tt", "tt")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("tt", "fold((tag, acc) -> concat(acc, tag), tags, '')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tt", NullHandling.replaceWithDefault() ? null : "", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "t1t2t3", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "t3t4t5", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "t5t6t7", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-arrayfn-auto");
    }

    @Test
    public void testGroupByExpressionFoldArrayToStringWithConcats() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tt", "tt")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("tt", "fold((tag, acc) -> concat(concat(acc, case_searched(acc == '', '', ', '), concat('foo', tag))), tags, '')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        Sequence result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query);
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", NullHandling.replaceWithDefault() ? null : "foo", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foot1, foot2, foot3", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foot3, foot4, foot5", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970", "tt", "foot5, foot6, foot7", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "expr-arrayfn-auto");
    }

    @Test
    public void testGroupByExpressionMultiConflicting() {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Invalid expression: (concat [(cartesian_map ([x, othertags] -> (concat [x, othertags])), [tags, othertags]), tags]); [tags] used as both scalar and array variables");
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("texpr", "texpr")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "concat(map((x) -> concat(x, othertags), tags), tags)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setLimit(5).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query).toList();
    }

    @Test
    public void testGroupByExpressionMultiConflictingAlso() {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Invalid expression: (array_concat [tags, (array_append [othertags, tags])]); [tags] used as both scalar and array variables");
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("texpr", "texpr")}).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "array_concat(tags, (array_append(othertags, tags)))", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).setLimit(5).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.context).build();
        this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), (Object)new IncrementalIndexSegment(this.incrementalIndex, SegmentId.dummy((String)"sid2"))), query).toList();
    }

    @Test
    public void testTopNWithDimFilterAndWithFilteredDimSpec() {
        TopNQuery query = new TopNQueryBuilder().dataSource("xx").granularity(Granularities.ALL).dimension((DimensionSpec)new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("tags", "tags"), (Set)ImmutableSet.of((Object)"t3"), null)).metric("count").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).threshold(5).filters((DimFilter)new SelectorDimFilter("tags", "t3", null)).build();
        try (CloseableStupidPool<ByteBuffer> pool = TestQueryRunners.createDefaultNonBlockingPool();){
            TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory(pool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), null);
            Sequence result = runner.run(QueryPlus.wrap((Query)query));
            List<Result> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.of((Object)"tags", (Object)"t3", (Object)"count", (Object)2L)))));
            TestHelper.assertExpectedObjects(expectedResults, result.toList(), "filteredDim");
        }
    }

    @Test
    public void testTopNExpression() {
        TopNQuery query = new TopNQueryBuilder().dataSource("xx").granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("texpr", "texpr")).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "map(x -> concat(x, 'foo'), tags)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).metric("count").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).threshold(15).build();
        try (CloseableStupidPool<ByteBuffer> pool = TestQueryRunners.createDefaultNonBlockingPool();){
            TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory(pool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), null);
            Sequence result = runner.run(QueryPlus.wrap((Query)query));
            ImmutableList expected = ImmutableList.builder().add((Object)ImmutableMap.of((Object)"texpr", (Object)"t3foo", (Object)"count", (Object)2L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t5foo", (Object)"count", (Object)2L)).add((Object)new HashMap<String, Object>(){
                {
                    this.put("texpr", NullHandling.sqlCompatible() ? "foo" : null);
                    this.put("count", 1L);
                }
            }).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t1foo", (Object)"count", (Object)1L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t2foo", (Object)"count", (Object)1L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t4foo", (Object)"count", (Object)1L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t6foo", (Object)"count", (Object)1L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t7foo", (Object)"count", (Object)1L)).build();
            List<Result> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue((List)expected)));
            TestHelper.assertExpectedObjects(expectedResults, result.toList(), "filteredDim");
        }
    }

    @Test
    public void testTopNExpressionAutoTransform() {
        TopNQuery query = new TopNQueryBuilder().dataSource("xx").granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("texpr", "texpr")).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("texpr", "concat(tags, 'foo')", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).metric("count").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).threshold(15).build();
        try (CloseableStupidPool<ByteBuffer> pool = TestQueryRunners.createDefaultNonBlockingPool();){
            TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory(pool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new QueryableIndexSegment(this.queryableIndex, SegmentId.dummy((String)"sid1")), null);
            Sequence result = runner.run(QueryPlus.wrap((Query)query));
            ImmutableList expected = ImmutableList.builder().add((Object)ImmutableMap.of((Object)"texpr", (Object)"t3foo", (Object)"count", (Object)2L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t5foo", (Object)"count", (Object)2L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"foo", (Object)"count", (Object)1L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t1foo", (Object)"count", (Object)1L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t2foo", (Object)"count", (Object)1L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t4foo", (Object)"count", (Object)1L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t6foo", (Object)"count", (Object)1L)).add((Object)ImmutableMap.of((Object)"texpr", (Object)"t7foo", (Object)"count", (Object)1L)).build();
            List<Result> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue((List)expected)));
            TestHelper.assertExpectedObjects(expectedResults, result.toList(), "filteredDim");
        }
    }

    @After
    public void cleanup() throws Exception {
        this.queryableIndex.close();
        this.incrementalIndex.close();
        FileUtils.deleteDirectory((File)this.persistedSegmentDir);
    }
}

