/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.SettableObjectBinding;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionPostAggregatorTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        ExpressionPostAggregator postAgg = new ExpressionPostAggregator("p0", "2 + 3", null, TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)postAgg, (Object)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)postAgg), ExpressionPostAggregator.class));
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(ExpressionPostAggregator.class).usingGetClass().withIgnoredFields(new String[]{"macroTable", "finalizers", "parsed", "dependentFields", "cacheKey", "partialTypeInformation"}).verify();
    }

    @Test
    public void testOutputTypeAndCompute() {
        ExpressionPostAggregator postAgg = new ExpressionPostAggregator("p0", "x + y", null, TestExprMacroTable.INSTANCE);
        RowSignature signature = RowSignature.builder().add("x", ColumnType.LONG).add("y", ColumnType.DOUBLE).build();
        SettableObjectBinding binding = new SettableObjectBinding().withBinding("x", (Object)2L).withBinding("y", (Object)3.0);
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)postAgg.getType((ColumnInspector)signature));
        Assert.assertEquals((Object)5.0, (Object)postAgg.compute(binding.asMap()));
    }

    @Test
    public void testNilOutputType() {
        ExpressionPostAggregator postAgg = new ExpressionPostAggregator("p0", "x + y", null, TestExprMacroTable.INSTANCE);
        RowSignature signature = RowSignature.builder().build();
        Assert.assertNull((Object)postAgg.getType((ColumnInspector)signature));
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new DoubleSumAggregatorFactory("double", "col1"), new FloatSumAggregatorFactory("float", "col2")}).postAggregators(new PostAggregator[]{new ExpressionPostAggregator("a", "double + float", null, TestExprMacroTable.INSTANCE), new ExpressionPostAggregator("b", "count + count", null, TestExprMacroTable.INSTANCE), new ExpressionPostAggregator("c", "count + double", null, TestExprMacroTable.INSTANCE), new ExpressionPostAggregator("d", "float + float", null, TestExprMacroTable.INSTANCE)}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ColumnType.LONG).add("double", ColumnType.DOUBLE).add("float", ColumnType.FLOAT).add("a", ColumnType.DOUBLE).add("b", ColumnType.LONG).add("c", ColumnType.DOUBLE).add("d", ColumnType.DOUBLE).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

