/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.jackson.AggregatorsModule;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregator;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FinalizingFieldAccessPostAggregatorTest
extends InitializedNullHandlingTest {
    @Rule
    public final TemporaryFolder tempFoler = new TemporaryFolder();

    @Test(expected=UnsupportedOperationException.class)
    public void testComputeWithoutFinalizing() {
        String aggName = "rows";
        CountAggregator agg = new CountAggregator();
        agg.aggregate();
        agg.aggregate();
        agg.aggregate();
        HashMap<String, Object> metricValues = new HashMap<String, Object>();
        metricValues.put(aggName, agg.get());
        FinalizingFieldAccessPostAggregator postAgg = new FinalizingFieldAccessPostAggregator("final_rows", aggName);
        Assert.assertEquals((Object)new Long(3L), (Object)postAgg.compute(metricValues));
    }

    @Test
    public void testComputedWithFinalizing() {
        String aggName = "biily";
        AggregatorFactory aggFactory = (AggregatorFactory)EasyMock.createMock(AggregatorFactory.class);
        EasyMock.expect((Object)aggFactory.getComparator()).andReturn((Object)Comparators.naturalNullsFirst()).once();
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test")).andReturn((Object)3L).once();
        EasyMock.expect((Object)aggFactory.getResultType()).andReturn((Object)ColumnType.LONG).once();
        EasyMock.replay((Object[])new Object[]{aggFactory});
        FinalizingFieldAccessPostAggregator postAgg = FinalizingFieldAccessPostAggregatorTest.buildDecorated("final_billy", aggName, (Map<String, AggregatorFactory>)ImmutableMap.of((Object)aggName, (Object)aggFactory));
        Assert.assertEquals(FinalizingFieldAccessPostAggregator.class, postAgg.getClass());
        HashMap<String, String> metricValues = new HashMap<String, String>();
        metricValues.put(aggName, "test");
        Assert.assertEquals((Object)new Long(3L), (Object)postAgg.compute(metricValues));
        EasyMock.verify((Object[])new Object[]{aggFactory});
    }

    @Test
    public void testComputedInArithmeticPostAggregator() {
        String aggName = "billy";
        AggregatorFactory aggFactory = (AggregatorFactory)EasyMock.createMock(AggregatorFactory.class);
        EasyMock.expect((Object)aggFactory.getComparator()).andReturn((Object)Comparators.naturalNullsFirst()).once();
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test")).andReturn((Object)3L).once();
        EasyMock.expect((Object)aggFactory.getResultType()).andReturn((Object)ColumnType.LONG).once();
        EasyMock.replay((Object[])new Object[]{aggFactory});
        FinalizingFieldAccessPostAggregator postAgg = FinalizingFieldAccessPostAggregatorTest.buildDecorated("final_billy", aggName, (Map<String, AggregatorFactory>)ImmutableMap.of((Object)aggName, (Object)aggFactory));
        HashMap<String, String> metricValues = new HashMap<String, String>();
        metricValues.put(aggName, "test");
        ArrayList postAggsList = Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("roku", (Number)6), postAgg});
        ArithmeticPostAggregator arithmeticPostAggregator = new ArithmeticPostAggregator("add", "+", (List)postAggsList);
        Assert.assertEquals((Object)new Double(9.0), (Object)arithmeticPostAggregator.compute(metricValues));
        EasyMock.verify((Object[])new Object[0]);
    }

    @Test
    public void testComparatorsWithFinalizing() {
        String aggName = "billy";
        AggregatorFactory aggFactory = (AggregatorFactory)EasyMock.createMock(AggregatorFactory.class);
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test_val1")).andReturn((Object)new Long(10L)).times(1);
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test_val2")).andReturn((Object)new Long(21L)).times(1);
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test_val3")).andReturn((Object)new Long(3L)).times(1);
        EasyMock.expect((Object)aggFactory.finalizeComputation((Object)"test_val4")).andReturn(null).times(1);
        EasyMock.expect((Object)aggFactory.getComparator()).andReturn((Object)Ordering.natural().nullsLast()).times(1);
        EasyMock.expect((Object)aggFactory.getResultType()).andReturn((Object)ColumnType.LONG).once();
        EasyMock.replay((Object[])new Object[]{aggFactory});
        FinalizingFieldAccessPostAggregator postAgg = FinalizingFieldAccessPostAggregatorTest.buildDecorated("final_billy", aggName, (Map<String, AggregatorFactory>)ImmutableMap.of((Object)aggName, (Object)aggFactory));
        ArrayList<Object> computedValues = new ArrayList<Object>();
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)aggName, (Object)"test_val1")));
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)aggName, (Object)"test_val2")));
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)aggName, (Object)"test_val3")));
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)aggName, (Object)"test_val4")));
        Collections.sort(computedValues, postAgg.getComparator());
        Assert.assertArrayEquals((Object[])new Object[]{3L, 10L, 21L, null}, (Object[])computedValues.toArray(new Object[0]));
        EasyMock.verify((Object[])new Object[0]);
    }

    @Test
    public void testComparatorsWithFinalizingAndComparatorNull() {
        String aggName = "billy";
        AggregatorFactory aggFactory = (AggregatorFactory)EasyMock.createMock(AggregatorFactory.class);
        EasyMock.expect((Object)aggFactory.getComparator()).andReturn(null).times(1);
        EasyMock.replay((Object[])new Object[]{aggFactory});
        FinalizingFieldAccessPostAggregator postAgg = FinalizingFieldAccessPostAggregatorTest.buildDecorated("final_billy", "joe", (Map<String, AggregatorFactory>)ImmutableMap.of((Object)aggName, (Object)aggFactory));
        ArrayList<Object> computedValues = new ArrayList<Object>();
        HashMap<String, Object> forNull = new HashMap<String, Object>();
        forNull.put("joe", null);
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)"joe", (Object)"test_val1")));
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)"joe", (Object)"test_val2")));
        computedValues.add(postAgg.compute(forNull));
        computedValues.add(postAgg.compute((Map)ImmutableMap.of((Object)"joe", (Object)"test_val4")));
        Collections.sort(computedValues, postAgg.getComparator());
        Assert.assertArrayEquals((Object[])new Object[]{null, "test_val1", "test_val2", "test_val4"}, (Object[])computedValues.toArray(new Object[0]));
        EasyMock.verify((Object[])new Object[0]);
    }

    @Test
    public void testIngestAndQueryWithArithmeticPostAggregator() throws Exception {
        try (AggregationTestHelper helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Collections.singletonList(new AggregatorsModule()), GroupByQueryRunnerTest.testConfigs().get(0), this.tempFoler);){
            String metricSpec = "[{\"type\": \"hyperUnique\", \"name\": \"hll_market\", \"fieldName\": \"market\"},{\"type\": \"hyperUnique\", \"name\": \"hll_quality\", \"fieldName\": \"quality\"}]";
            String parseSpec = "{\"type\" : \"string\",\"parseSpec\" : {    \"format\" : \"tsv\",    \"timestampSpec\" : {        \"column\" : \"timestamp\",        \"format\" : \"auto\"},    \"dimensionsSpec\" : {        \"dimensions\": [],        \"dimensionExclusions\" : [],        \"spatialDimensions\" : []    },    \"columns\": [\"timestamp\", \"market\", \"quality\", \"placement\", \"placementish\", \"index\"]  }}";
            String query = "{\"queryType\": \"groupBy\",\"dataSource\": \"test_datasource\",\"granularity\": \"ALL\",\"dimensions\": [],\"aggregations\": [  { \"type\": \"hyperUnique\", \"name\": \"hll_market\", \"fieldName\": \"hll_market\" },  { \"type\": \"hyperUnique\", \"name\": \"hll_quality\", \"fieldName\": \"hll_quality\" }],\"postAggregations\": [  { \"type\": \"arithmetic\", \"name\": \"uniq_add\", \"fn\": \"+\", \"fields\":[    { \"type\": \"finalizingFieldAccess\", \"name\": \"uniq_market\", \"fieldName\": \"hll_market\" },    { \"type\": \"finalizingFieldAccess\", \"name\": \"uniq_quality\", \"fieldName\": \"hll_quality\" }]  }],\"intervals\": [ \"1970/2050\" ]}";
            Sequence seq = helper.createIndexAndRunQueryOnSegment(new File(this.getClass().getClassLoader().getResource("druid.sample.tsv").getFile()), parseSpec, metricSpec, 0L, Granularities.NONE, 50000, query);
            ResultRow resultRow = (ResultRow)seq.toList().get(0);
            Assert.assertEquals((String)"hll_market", (double)3.0, (double)((Number)resultRow.get(0)).floatValue(), (double)0.1);
            Assert.assertEquals((String)"hll_quality", (double)9.0, (double)((Number)resultRow.get(1)).floatValue(), (double)0.1);
            Assert.assertEquals((String)"uniq_add", (double)12.0, (double)((Number)resultRow.get(2)).floatValue(), (double)0.1);
        }
    }

    @Test
    public void testSerde() throws IOException {
        FinalizingFieldAccessPostAggregator original = new FinalizingFieldAccessPostAggregator("foo", "bar");
        FinalizingFieldAccessPostAggregator decorated = original.decorate((Map)ImmutableMap.of((Object)"bar", (Object)new CountAggregatorFactory("bar")));
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Assert.assertEquals((Object)original, (Object)objectMapper.readValue(objectMapper.writeValueAsString((Object)decorated), PostAggregator.class));
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new StringFirstAggregatorFactory("stringo", "col", null, Integer.valueOf(1024))}).postAggregators(new PostAggregator[]{new FieldAccessPostAggregator("a", "stringo"), new FinalizingFieldAccessPostAggregator("b", "stringo")}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ColumnType.LONG).add("stringo", null).add("a", StringFirstAggregatorFactory.TYPE).add("b", ColumnType.STRING).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }

    private static FinalizingFieldAccessPostAggregator buildDecorated(String name, String fieldName, Map<String, AggregatorFactory> aggregators) {
        FinalizingFieldAccessPostAggregator ret = new FinalizingFieldAccessPostAggregator(name, fieldName);
        return ret.decorate(aggregators);
    }
}

