/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.ContainsExprMacro;
import org.apache.druid.query.expression.MacroTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ContainsExprMacroTest
extends MacroTestBase {
    public ContainsExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new ContainsExprMacro());
    }

    @Test
    public void testErrorZeroArguments() {
        this.expectException(IllegalArgumentException.class, "Function[contains_string] requires 2 arguments");
        this.eval("contains_string()", InputBindings.nilBindings());
    }

    @Test
    public void testErrorThreeArguments() {
        this.expectException(IllegalArgumentException.class, "Function[contains_string] requires 2 arguments");
        this.eval("contains_string('a', 'b', 'c')", InputBindings.nilBindings());
    }

    @Test
    public void testMatch() {
        ExprEval<?> result = this.eval("contains_string(a, 'oba')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foobar"));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testNoMatch() {
        ExprEval<?> result = this.eval("contains_string(a, 'bar')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)false).value(), (Object)result.value());
    }

    @Test
    public void testNullSearch() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[contains_string] substring must be a string literal");
        }
        ExprEval<?> result = this.eval("contains_string(a, null)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testEmptyStringSearch() {
        ExprEval<?> result = this.eval("contains_string(a, '')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testNullSearchOnEmptyString() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[contains_string] substring must be a string literal");
        }
        ExprEval<?> result = this.eval("contains_string(a, null)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> ""));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testEmptyStringSearchOnEmptyString() {
        ExprEval<?> result = this.eval("contains_string(a, '')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> ""));
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testNullSearchOnNull() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[contains_string] substring must be a string literal");
        }
        ExprEval<?> result = this.eval("contains_string(a, null)", InputBindings.nilBindings());
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((boolean)true).value(), (Object)result.value());
    }

    @Test
    public void testEmptyStringSearchOnNull() {
        ExprEval<?> result = this.eval("contains_string(a, '')", InputBindings.nilBindings());
        Assert.assertEquals((Object)ExprEval.ofLongBoolean((!NullHandling.sqlCompatible() ? 1 : 0) != 0).value(), (Object)result.value());
    }
}

