/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.MacroTestBase;
import org.apache.druid.query.expression.RegexpExtractExprMacro;
import org.junit.Assert;
import org.junit.Test;

public class RegexpExtractExprMacroTest
extends MacroTestBase {
    public RegexpExtractExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new RegexpExtractExprMacro());
    }

    @Test
    public void testErrorZeroArguments() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_extract] requires 2 or 3 arguments");
        this.eval("regexp_extract()", InputBindings.nilBindings());
    }

    @Test
    public void testErrorFourArguments() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_extract] requires 2 or 3 arguments");
        this.eval("regexp_extract('a', 'b', 'c', 'd')", InputBindings.nilBindings());
    }

    @Test
    public void testMatch() {
        ExprEval<?> result = this.eval("regexp_extract(a, 'f(.o)')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)"foo", (Object)result.value());
    }

    @Test
    public void testMatchGroup0() {
        ExprEval<?> result = this.eval("regexp_extract(a, 'f(.o)', 0)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)"foo", (Object)result.value());
    }

    @Test
    public void testMatchGroup1() {
        ExprEval<?> result = this.eval("regexp_extract(a, 'f(.o)', 1)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)"oo", (Object)result.value());
    }

    @Test
    public void testMatchGroup2() {
        Throwable t = Assert.assertThrows(IndexOutOfBoundsException.class, () -> this.eval("regexp_extract(a, 'f(.o)', 2)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo")));
        Assert.assertEquals((Object)"No group 2", (Object)t.getMessage());
    }

    @Test
    public void testNoMatch() {
        ExprEval<?> result = this.eval("regexp_extract(a, 'f(.x)')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testMatchInMiddle() {
        ExprEval<?> result = this.eval("regexp_extract(a, '.o$')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)"oo", (Object)result.value());
    }

    @Test
    public void testNullPattern() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[regexp_extract] pattern must be a string literal");
        }
        ExprEval<?> result = this.eval("regexp_extract(a, null)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testEmptyStringPattern() {
        ExprEval<?> result = this.eval("regexp_extract(a, '')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)NullHandling.emptyToNullIfNeeded((String)""), (Object)result.value());
    }

    @Test
    public void testNumericPattern() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_extract] pattern must be a string literal");
        this.eval("regexp_extract(a, 1)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
    }

    @Test
    public void testNonLiteralPattern() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_extract] pattern must be a string literal");
        this.eval("regexp_extract(a, a)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
    }

    @Test
    public void testNullPatternOnNull() {
        if (NullHandling.sqlCompatible()) {
            this.expectException(IllegalArgumentException.class, "Function[regexp_extract] pattern must be a string literal");
        }
        ExprEval<?> result = this.eval("regexp_extract(a, null)", InputBindings.nilBindings());
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testEmptyStringPatternOnNull() {
        ExprEval<?> result = this.eval("regexp_extract(a, '')", InputBindings.nilBindings());
        Assert.assertNull((Object)result.value());
    }
}

