/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.VectorExprSanityTest;
import org.apache.druid.query.expression.TimestampShiftExprMacro;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class VectorExpressionsSanityTest
extends InitializedNullHandlingTest {
    private static final Logger log = new Logger(VectorExpressionsSanityTest.class);
    private static final int NUM_ITERATIONS = 10;
    private static final int VECTOR_SIZE = 512;
    private static final TimestampShiftExprMacro TIMESTAMP_SHIFT_EXPR_MACRO = new TimestampShiftExprMacro();
    private static final DateTime DATE_TIME = DateTimes.of((String)"2020-11-05T04:05:06");
    final Map<String, ExpressionType> types = ImmutableMap.builder().put((Object)"l1", (Object)ExpressionType.LONG).put((Object)"l2", (Object)ExpressionType.LONG).put((Object)"d1", (Object)ExpressionType.DOUBLE).put((Object)"d2", (Object)ExpressionType.DOUBLE).put((Object)"s1", (Object)ExpressionType.STRING).put((Object)"s2", (Object)ExpressionType.STRING).put((Object)"boolString1", (Object)ExpressionType.STRING).put((Object)"boolString2", (Object)ExpressionType.STRING).build();

    @BeforeClass
    public static void setupTests() {
        ExpressionProcessing.initializeForStrictBooleansTests((boolean)true);
    }

    @AfterClass
    public static void teardownTests() {
        ExpressionProcessing.initializeForTests();
    }

    static void testExpression(String expr, Expr parsed, Map<String, ExpressionType> types) {
        NonnullPair<Expr.ObjectBinding[], Expr.VectorInputBinding> bindings;
        log.debug("[%s]", new Object[]{expr});
        for (int iterations = 0; iterations < 10; ++iterations) {
            bindings = VectorExprSanityTest.makeRandomizedBindings(512, types);
            VectorExprSanityTest.testExpressionWithBindings(expr, parsed, bindings);
        }
        bindings = VectorExprSanityTest.makeSequentialBinding(512, types);
        VectorExprSanityTest.testExpressionWithBindings(expr, parsed, bindings);
    }

    @Test
    public void testTimeShiftFn() {
        int step = 1;
        Expr parsed = TIMESTAMP_SHIFT_EXPR_MACRO.apply((List)ImmutableList.of((Object)ExprEval.of((long)DATE_TIME.getMillis()).toExpr(), (Object)ExprEval.of((String)"P1M").toExpr(), (Object)ExprEval.of((long)step).toExpr()));
        VectorExpressionsSanityTest.testExpression("time_shift(l1, 'P1M', 1)", parsed, this.types);
    }
}

