/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.collect.Sets;
import java.util.Arrays;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.druid.segment.filter.JavaScriptFilter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JavaScriptDimFilterTest {
    private static final String FN1 = "function(x) { return x }";
    private static final String FN2 = "function(x) { return x + x }";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testGetCacheKey() {
        JavaScriptDimFilter javaScriptDimFilter = new JavaScriptDimFilter("dim", FN1, null, JavaScriptConfig.getEnabledInstance());
        JavaScriptDimFilter javaScriptDimFilter2 = new JavaScriptDimFilter("di", FN2, null, JavaScriptConfig.getEnabledInstance());
        Assert.assertFalse((boolean)Arrays.equals(javaScriptDimFilter.getCacheKey(), javaScriptDimFilter2.getCacheKey()));
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        JavaScriptDimFilter javaScriptDimFilter3 = new JavaScriptDimFilter("dim", FN1, (ExtractionFn)regexFn, JavaScriptConfig.getEnabledInstance());
        Assert.assertFalse((boolean)Arrays.equals(javaScriptDimFilter.getCacheKey(), javaScriptDimFilter3.getCacheKey()));
    }

    @Test
    public void testEquals() {
        JavaScriptDimFilter javaScriptDimFilter = new JavaScriptDimFilter("dim", FN1, null, JavaScriptConfig.getEnabledInstance());
        JavaScriptDimFilter javaScriptDimFilter2 = new JavaScriptDimFilter("di", FN2, null, JavaScriptConfig.getEnabledInstance());
        JavaScriptDimFilter javaScriptDimFilter3 = new JavaScriptDimFilter("di", FN2, null, JavaScriptConfig.getEnabledInstance());
        Assert.assertNotEquals((Object)javaScriptDimFilter, (Object)javaScriptDimFilter2);
        Assert.assertEquals((Object)javaScriptDimFilter2, (Object)javaScriptDimFilter3);
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        JavaScriptDimFilter javaScriptDimFilter4 = new JavaScriptDimFilter("dim", FN1, (ExtractionFn)regexFn, JavaScriptConfig.getEnabledInstance());
        JavaScriptDimFilter javaScriptDimFilter5 = new JavaScriptDimFilter("dim", FN1, (ExtractionFn)regexFn, JavaScriptConfig.getEnabledInstance());
        Assert.assertNotEquals((Object)javaScriptDimFilter, (Object)javaScriptDimFilter3);
        Assert.assertEquals((Object)javaScriptDimFilter4, (Object)javaScriptDimFilter5);
    }

    @Test
    public void testHashcode() {
        JavaScriptDimFilter javaScriptDimFilter = new JavaScriptDimFilter("dim", FN1, null, JavaScriptConfig.getEnabledInstance());
        JavaScriptDimFilter javaScriptDimFilter2 = new JavaScriptDimFilter("di", FN2, null, JavaScriptConfig.getEnabledInstance());
        JavaScriptDimFilter javaScriptDimFilter3 = new JavaScriptDimFilter("di", FN2, null, JavaScriptConfig.getEnabledInstance());
        Assert.assertNotEquals((long)javaScriptDimFilter.hashCode(), (long)javaScriptDimFilter2.hashCode());
        Assert.assertEquals((long)javaScriptDimFilter2.hashCode(), (long)javaScriptDimFilter3.hashCode());
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        JavaScriptDimFilter javaScriptDimFilter4 = new JavaScriptDimFilter("dim", FN1, (ExtractionFn)regexFn, JavaScriptConfig.getEnabledInstance());
        JavaScriptDimFilter javaScriptDimFilter5 = new JavaScriptDimFilter("dim", FN1, (ExtractionFn)regexFn, JavaScriptConfig.getEnabledInstance());
        Assert.assertNotEquals((long)javaScriptDimFilter.hashCode(), (long)javaScriptDimFilter3.hashCode());
        Assert.assertEquals((long)javaScriptDimFilter4.hashCode(), (long)javaScriptDimFilter5.hashCode());
    }

    @Test
    public void testToFilter() {
        JavaScriptDimFilter javaScriptDimFilter = new JavaScriptDimFilter("dim", "function(x) { return true; }", null, JavaScriptConfig.getEnabledInstance());
        Filter filter = javaScriptDimFilter.toFilter();
        Assert.assertThat((Object)filter, (Matcher)CoreMatchers.instanceOf(JavaScriptFilter.class));
    }

    @Test
    public void testToFilterNotAllowed() {
        JavaScriptDimFilter javaScriptDimFilter = new JavaScriptDimFilter("dim", FN1, null, new JavaScriptConfig(false));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("JavaScript is disabled");
        javaScriptDimFilter.toFilter();
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testGetRequiredColumns() {
        JavaScriptDimFilter javaScriptDimFilter = new JavaScriptDimFilter("dim", FN1, null, new JavaScriptConfig(false));
        Assert.assertEquals((Object)javaScriptDimFilter.getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim"}));
    }

    @Test
    public void testPredicateFactoryApplyObject() {
        JavaScriptDimFilter javaScriptDimFilter = new JavaScriptDimFilter("dim", "function(id) { return ['123', '456'].includes(id); }", null, JavaScriptConfig.getEnabledInstance());
        Assert.assertTrue((boolean)javaScriptDimFilter.getPredicateFactory().applyObject((Object)"123"));
        Assert.assertTrue((boolean)javaScriptDimFilter.getPredicateFactory().applyObject((Object)"456"));
        Assert.assertFalse((boolean)javaScriptDimFilter.getPredicateFactory().applyObject((Object)"789"));
        JavaScriptDimFilter javaScriptDimFilter1 = new JavaScriptDimFilter("dim", "function(id) { return ['123', '456'].includes(id) == true; }", null, JavaScriptConfig.getEnabledInstance());
        Assert.assertTrue((boolean)javaScriptDimFilter1.getPredicateFactory().applyObject((Object)"123"));
        Assert.assertTrue((boolean)javaScriptDimFilter1.getPredicateFactory().applyObject((Object)"456"));
        Assert.assertFalse((boolean)javaScriptDimFilter1.getPredicateFactory().applyObject((Object)"789"));
        JavaScriptDimFilter javaScriptDimFilter2 = new JavaScriptDimFilter("dim", "function(id) { return 'word'; }", null, JavaScriptConfig.getEnabledInstance());
        Assert.assertTrue((boolean)javaScriptDimFilter2.getPredicateFactory().applyObject((Object)"123"));
        JavaScriptDimFilter javaScriptDimFilter3 = new JavaScriptDimFilter("dim", "function(id) { return null; }", null, JavaScriptConfig.getEnabledInstance());
        Assert.assertFalse((boolean)javaScriptDimFilter3.getPredicateFactory().applyObject((Object)"123"));
    }
}

