/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.DoubleVectorValueMatcher;
import org.apache.druid.query.filter.vector.FloatVectorValueMatcher;
import org.apache.druid.query.filter.vector.LongVectorValueMatcher;
import org.apache.druid.query.filter.vector.MultiValueStringVectorValueMatcher;
import org.apache.druid.query.filter.vector.SingleValueStringVectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VectorValueMatcherColumnProcessorFactoryTest
extends InitializedNullHandlingTest {
    private static final int VECTOR_SIZE = 128;
    private static final int CURRENT_SIZE = 24;
    private VectorValueSelector vectorValueSelector;

    @Before
    public void setup() {
        this.vectorValueSelector = (VectorValueSelector)EasyMock.createMock(VectorValueSelector.class);
        EasyMock.expect((Object)this.vectorValueSelector.getCurrentVectorSize()).andReturn((Object)24).anyTimes();
        EasyMock.expect((Object)this.vectorValueSelector.getMaxVectorSize()).andReturn((Object)128).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.vectorValueSelector});
    }

    @Test
    public void testFloat() {
        VectorValueMatcherFactory matcherFactory = VectorValueMatcherColumnProcessorFactory.instance().makeFloatProcessor((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.FLOAT), this.vectorValueSelector);
        Assert.assertTrue((boolean)(matcherFactory instanceof FloatVectorValueMatcher));
        VectorValueMatcher matcher = matcherFactory.makeMatcher("2.0");
        Assert.assertFalse((boolean)(matcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)matcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)matcher.getCurrentVectorSize());
        VectorValueMatcher booleanMatcher = matcherFactory.makeMatcher((String)null);
        Assert.assertFalse((boolean)(booleanMatcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)booleanMatcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)booleanMatcher.getCurrentVectorSize());
        EasyMock.verify((Object[])new Object[]{this.vectorValueSelector});
    }

    @Test
    public void testDouble() {
        VectorValueMatcherFactory matcherFactory = VectorValueMatcherColumnProcessorFactory.instance().makeDoubleProcessor((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE), this.vectorValueSelector);
        Assert.assertTrue((boolean)(matcherFactory instanceof DoubleVectorValueMatcher));
        VectorValueMatcher matcher = matcherFactory.makeMatcher("1.0");
        Assert.assertFalse((boolean)(matcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)matcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)matcher.getCurrentVectorSize());
        VectorValueMatcher booleanMatcher = matcherFactory.makeMatcher((String)null);
        Assert.assertFalse((boolean)(booleanMatcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)booleanMatcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)booleanMatcher.getCurrentVectorSize());
        EasyMock.verify((Object[])new Object[]{this.vectorValueSelector});
    }

    @Test
    public void testLong() {
        VectorValueMatcherFactory matcherFactory = VectorValueMatcherColumnProcessorFactory.instance().makeLongProcessor((ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG), this.vectorValueSelector);
        Assert.assertTrue((boolean)(matcherFactory instanceof LongVectorValueMatcher));
        VectorValueMatcher matcher = matcherFactory.makeMatcher("1");
        Assert.assertFalse((boolean)(matcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)matcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)matcher.getCurrentVectorSize());
        VectorValueMatcher booleanMatcher = matcherFactory.makeMatcher((String)null);
        Assert.assertFalse((boolean)(booleanMatcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)booleanMatcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)booleanMatcher.getCurrentVectorSize());
        EasyMock.verify((Object[])new Object[]{this.vectorValueSelector});
    }

    @Test
    public void testSingleValueString() {
        IdLookup lookup = (IdLookup)EasyMock.createMock(IdLookup.class);
        SingleValueDimensionVectorSelector selector = (SingleValueDimensionVectorSelector)EasyMock.createMock(SingleValueDimensionVectorSelector.class);
        EasyMock.expect((Object)selector.getCurrentVectorSize()).andReturn((Object)24).anyTimes();
        EasyMock.expect((Object)selector.getMaxVectorSize()).andReturn((Object)128).anyTimes();
        EasyMock.expect((Object)selector.getValueCardinality()).andReturn((Object)1024).anyTimes();
        EasyMock.expect((Object)selector.nameLookupPossibleInAdvance()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)selector.idLookup()).andReturn((Object)lookup).anyTimes();
        EasyMock.expect((Object)lookup.lookupId("any value")).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)lookup.lookupId("another value")).andReturn((Object)-1).anyTimes();
        EasyMock.replay((Object[])new Object[]{selector, lookup});
        VectorValueMatcherFactory matcherFactory = VectorValueMatcherColumnProcessorFactory.instance().makeSingleValueDimensionProcessor((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasMultipleValues(false).setHasBitmapIndexes(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setDictionaryEncoded(true), selector);
        Assert.assertTrue((boolean)(matcherFactory instanceof SingleValueStringVectorValueMatcher));
        VectorValueMatcher matcher = matcherFactory.makeMatcher("any value");
        Assert.assertFalse((boolean)(matcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)matcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)matcher.getCurrentVectorSize());
        VectorValueMatcher booleanMatcher = matcherFactory.makeMatcher("another value");
        Assert.assertTrue((boolean)(booleanMatcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)booleanMatcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)booleanMatcher.getCurrentVectorSize());
        EasyMock.verify((Object[])new Object[]{selector, lookup});
    }

    @Test
    public void testSingleValueStringZeroCardinalityAlwaysBooleanMatcher() {
        SingleValueDimensionVectorSelector selector = (SingleValueDimensionVectorSelector)EasyMock.createMock(SingleValueDimensionVectorSelector.class);
        EasyMock.expect((Object)selector.getCurrentVectorSize()).andReturn((Object)24).anyTimes();
        EasyMock.expect((Object)selector.getMaxVectorSize()).andReturn((Object)128).anyTimes();
        EasyMock.expect((Object)selector.getValueCardinality()).andReturn((Object)0).anyTimes();
        EasyMock.replay((Object[])new Object[]{selector});
        VectorValueMatcherFactory matcherFactory = VectorValueMatcherColumnProcessorFactory.instance().makeSingleValueDimensionProcessor((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasMultipleValues(false).setHasBitmapIndexes(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setDictionaryEncoded(true), selector);
        Assert.assertTrue((boolean)(matcherFactory instanceof SingleValueStringVectorValueMatcher));
        VectorValueMatcher matcher = matcherFactory.makeMatcher("any value");
        Assert.assertTrue((boolean)(matcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)matcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)matcher.getCurrentVectorSize());
        VectorValueMatcher anotherMatcher = matcherFactory.makeMatcher((String)null);
        Assert.assertTrue((boolean)(anotherMatcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)anotherMatcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)anotherMatcher.getCurrentVectorSize());
        EasyMock.verify((Object[])new Object[]{selector});
    }

    @Test
    public void testSingleValueStringOneCardinalityBooleanMatcherIfNullAndNameLookupPossible() {
        SingleValueDimensionVectorSelector selector = (SingleValueDimensionVectorSelector)EasyMock.createMock(SingleValueDimensionVectorSelector.class);
        EasyMock.expect((Object)selector.getCurrentVectorSize()).andReturn((Object)24).anyTimes();
        EasyMock.expect((Object)selector.getMaxVectorSize()).andReturn((Object)128).anyTimes();
        EasyMock.expect((Object)selector.getValueCardinality()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)selector.nameLookupPossibleInAdvance()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)selector.lookupName(0)).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{selector});
        VectorValueMatcherFactory matcherFactory = VectorValueMatcherColumnProcessorFactory.instance().makeSingleValueDimensionProcessor((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasMultipleValues(false).setHasBitmapIndexes(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setDictionaryEncoded(true), selector);
        Assert.assertTrue((boolean)(matcherFactory instanceof SingleValueStringVectorValueMatcher));
        VectorValueMatcher booleanMatcher = matcherFactory.makeMatcher("any value");
        Assert.assertTrue((boolean)(booleanMatcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)booleanMatcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)booleanMatcher.getCurrentVectorSize());
        VectorValueMatcher anotherBooleanMatcher = matcherFactory.makeMatcher((String)null);
        Assert.assertTrue((boolean)(anotherBooleanMatcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)anotherBooleanMatcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)anotherBooleanMatcher.getCurrentVectorSize());
        EasyMock.verify((Object[])new Object[]{selector});
    }

    @Test
    public void testSingleValueStringOneCardinalityBooleanMatcherIfNullAndNameLookupNotPossible() {
        IdLookup lookup = (IdLookup)EasyMock.createMock(IdLookup.class);
        SingleValueDimensionVectorSelector selector = (SingleValueDimensionVectorSelector)EasyMock.createMock(SingleValueDimensionVectorSelector.class);
        EasyMock.expect((Object)selector.getCurrentVectorSize()).andReturn((Object)24).anyTimes();
        EasyMock.expect((Object)selector.getMaxVectorSize()).andReturn((Object)128).anyTimes();
        EasyMock.expect((Object)selector.getValueCardinality()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)selector.nameLookupPossibleInAdvance()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)selector.idLookup()).andReturn((Object)lookup).anyTimes();
        EasyMock.expect((Object)lookup.lookupId("any value")).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)lookup.lookupId(null)).andReturn((Object)0).anyTimes();
        EasyMock.replay((Object[])new Object[]{selector, lookup});
        VectorValueMatcherFactory matcherFactory = VectorValueMatcherColumnProcessorFactory.instance().makeSingleValueDimensionProcessor((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasMultipleValues(false).setHasBitmapIndexes(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setDictionaryEncoded(true), selector);
        Assert.assertTrue((boolean)(matcherFactory instanceof SingleValueStringVectorValueMatcher));
        VectorValueMatcher matcher = matcherFactory.makeMatcher("any value");
        Assert.assertFalse((boolean)(matcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)matcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)matcher.getCurrentVectorSize());
        EasyMock.verify((Object[])new Object[]{selector, lookup});
    }

    @Test
    public void testMultiValueString() {
        IdLookup lookup = (IdLookup)EasyMock.createMock(IdLookup.class);
        MultiValueDimensionVectorSelector selector = (MultiValueDimensionVectorSelector)EasyMock.createMock(MultiValueDimensionVectorSelector.class);
        EasyMock.expect((Object)selector.getCurrentVectorSize()).andReturn((Object)24).anyTimes();
        EasyMock.expect((Object)selector.getMaxVectorSize()).andReturn((Object)128).anyTimes();
        EasyMock.expect((Object)selector.getValueCardinality()).andReturn((Object)11).anyTimes();
        EasyMock.expect((Object)selector.nameLookupPossibleInAdvance()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)selector.idLookup()).andReturn((Object)lookup).anyTimes();
        EasyMock.expect((Object)lookup.lookupId("any value")).andReturn((Object)-1).anyTimes();
        EasyMock.expect((Object)lookup.lookupId(null)).andReturn((Object)0).anyTimes();
        EasyMock.replay((Object[])new Object[]{selector, lookup});
        VectorValueMatcherFactory matcherFactory = VectorValueMatcherColumnProcessorFactory.instance().makeMultiValueDimensionProcessor((ColumnCapabilities)new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasMultipleValues(false).setHasBitmapIndexes(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setDictionaryEncoded(true), selector);
        Assert.assertTrue((boolean)(matcherFactory instanceof MultiValueStringVectorValueMatcher));
        VectorValueMatcher valueNotExistMatcher = matcherFactory.makeMatcher("any value");
        Assert.assertTrue((boolean)(valueNotExistMatcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)valueNotExistMatcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)valueNotExistMatcher.getCurrentVectorSize());
        VectorValueMatcher valueExistMatcher = matcherFactory.makeMatcher((String)null);
        Assert.assertFalse((boolean)(valueExistMatcher instanceof BooleanVectorValueMatcher));
        Assert.assertEquals((long)128L, (long)valueExistMatcher.getMaxVectorSize());
        Assert.assertEquals((long)24L, (long)valueExistMatcher.getCurrentVectorSize());
        EasyMock.verify((Object[])new Object[]{selector, lookup});
    }
}

