/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.NestedDataGroupByQueryTest;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.GroupByQueryEngineV2;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ComparableList;
import org.apache.druid.segment.data.ComparableStringArray;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NestedGroupByArrayQueryTest {
    private static final Logger LOG = new Logger(NestedDataGroupByQueryTest.class);
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final Closer closer;
    private final GroupByQueryConfig config;
    private final QueryContexts.Vectorize vectorize;
    private final AggregationTestHelper helper;
    private final BiFunction<TemporaryFolder, Closer, List<Segment>> segmentsGenerator;
    private final String segmentsName;

    public NestedGroupByArrayQueryTest(GroupByQueryConfig config, BiFunction<TemporaryFolder, Closer, List<Segment>> segmentGenerator, String vectorize) {
        NestedDataModule.registerHandlersAndSerde();
        this.config = config;
        this.vectorize = QueryContexts.Vectorize.fromString((String)vectorize);
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(NestedDataModule.getJacksonModulesList(), config, this.tempFolder);
        this.segmentsGenerator = segmentGenerator;
        this.segmentsName = segmentGenerator.toString();
        this.closer = Closer.create();
    }

    public Map<String, Object> getContext() {
        return ImmutableMap.of((Object)"vectorize", (Object)this.vectorize.toString(), (Object)"vectorizeVirtualColumns", (Object)this.vectorize.toString());
    }

    @Parameterized.Parameters(name="config = {0}, segments = {1}, vectorize = {2}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        List<BiFunction<TemporaryFolder, Closer, List<Segment>>> segmentsGenerators = NestedDataTestUtils.getSegmentGenerators("nested-array-test-data.json");
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            if ("v1".equals(config.getDefaultStrategy())) continue;
            for (BiFunction<TemporaryFolder, Closer, List<Segment>> generatorFn : segmentsGenerators) {
                for (String vectorize : new String[]{"false", "true"}) {
                    constructors.add(new Object[]{config, generatorFn, vectorize});
                }
            }
        }
        return constructors;
    }

    @Before
    public void setup() {
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testGroupByRootArrayString() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"arrayString", (ColumnType)ColumnType.STRING_ARRAY)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 8L}, (Object)new Object[]{ComparableStringArray.of((String[])new String[]{"a", "b"}), 8L}, (Object)new Object[]{ComparableStringArray.of((String[])new String[]{"a", "b", "c"}), 4L}, (Object)new Object[]{ComparableStringArray.of((String[])new String[]{"b", "c"}), 4L}, (Object)new Object[]{ComparableStringArray.of((String[])new String[]{"d", "e"}), 4L}));
    }

    @Test
    public void testGroupByRootArrayLong() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"arrayLong", (ColumnType)ColumnType.LONG_ARRAY)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 8L}, (Object)new Object[]{NestedGroupByArrayQueryTest.asComparableList((Comparable[])new Long[]{1L, 2L, 3L}), 8L}, (Object)new Object[]{NestedGroupByArrayQueryTest.asComparableList((Comparable[])new Long[]{1L, 2L, 3L, 4L}), 4L}, (Object)new Object[]{NestedGroupByArrayQueryTest.asComparableList((Comparable[])new Long[]{1L, 4L}), 4L}, (Object)new Object[]{NestedGroupByArrayQueryTest.asComparableList((Comparable[])new Long[]{2L, 3L}), 4L}));
    }

    @Test
    public void testGroupByRootArrayDouble() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"arrayDouble", (ColumnType)ColumnType.DOUBLE_ARRAY)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 8L}, (Object)new Object[]{NestedGroupByArrayQueryTest.asComparableList((Comparable[])new Double[]{1.1, 2.2, 3.3}), 8L}, (Object)new Object[]{NestedGroupByArrayQueryTest.asComparableList((Comparable[])new Double[]{1.1, 3.3}), 4L}, (Object)new Object[]{NestedGroupByArrayQueryTest.asComparableList((Comparable[])new Double[]{2.2, 3.3, 4.0}), 4L}, (Object)new Object[]{NestedGroupByArrayQueryTest.asComparableList((Comparable[])new Double[]{3.3, 4.4, 5.5}), 4L}));
    }

    @Test
    public void testGroupByRootArrayStringElement() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.STRING)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayString", "$[2]", "v0", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 24L}, (Object)new Object[]{"c", 4L}));
    }

    @Test
    public void testGroupByRootArrayStringElementDouble() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.DOUBLE)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayString", "$[2]", "v0", ColumnType.DOUBLE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultDoubleValue(), 28L}));
    }

    @Test
    public void testGroupByRootArrayStringElementLong() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.LONG)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayString", "$[2]", "v0", ColumnType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultLongValue(), 28L}));
    }

    @Test
    public void testGroupByRootArrayStringElementFloat() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.FLOAT)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayString", "$[2]", "v0", ColumnType.FLOAT)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultFloatValue(), 28L}));
    }

    @Test
    public void testGroupByRootArrayLongElement() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.LONG)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayLong", "$[2]", "v0", ColumnType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultLongValue(), 16L}, (Object)new Object[]{3L, 12L}));
    }

    @Test
    public void testGroupByRootArrayLongElementDouble() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.DOUBLE)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayLong", "$[2]", "v0", ColumnType.DOUBLE)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultDoubleValue(), 16L}, (Object)new Object[]{3.0, 12L}));
    }

    @Test
    public void testGroupByRootArrayLongElementFloat() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.FLOAT)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayLong", "$[2]", "v0", ColumnType.FLOAT)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultFloatValue(), 16L}, (Object)new Object[]{Float.valueOf(3.0f), 12L}));
    }

    @Test
    public void testGroupByRootArrayLongElementString() {
        GroupByQuery groupQuery = GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0", (ColumnType)ColumnType.STRING)}).setVirtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayLong", "$[2]", "v0", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setContext(this.getContext()).build();
        this.runResults(groupQuery, (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 16L}, (Object)new Object[]{"3", 12L}));
    }

    private void runResults(GroupByQuery groupQuery, List<Object[]> expectedResults) {
        Supplier<List> runner = () -> this.helper.runQueryOnSegmentsObjs(this.segmentsGenerator.apply(this.tempFolder, this.closer), groupQuery).toList();
        List results = runner.get();
        NestedGroupByArrayQueryTest.verifyResults(groupQuery, results, expectedResults);
    }

    private static void verifyResults(GroupByQuery query, List<ResultRow> results, List<Object[]> expected) {
        RowSignature rowSignature = query.getResultRowSignature();
        List serdeAndBack = results.stream().peek(row -> GroupByQueryEngineV2.convertRowTypesToOutputTypes((List)query.getDimensions(), (ResultRow)row, (int)query.getResultRowDimensionStart())).collect(Collectors.toList());
        LOG.info("results:\n%s", new Object[]{serdeAndBack.stream().map(ResultRow::toString).collect(Collectors.joining("\n"))});
        Assert.assertEquals((long)expected.size(), (long)serdeAndBack.size());
        for (int i = 0; i < expected.size(); ++i) {
            Object[] resultRow = ((ResultRow)serdeAndBack.get(i)).getArray();
            Assert.assertEquals((long)expected.get(i).length, (long)resultRow.length);
            for (int j = 0; j < resultRow.length; ++j) {
                if (expected.get(i)[j] == null) {
                    Assert.assertNull((Object)resultRow[j]);
                    continue;
                }
                if (rowSignature.getColumnType(j).map(t -> t.is((TypeDescriptor)ValueType.DOUBLE)).orElse(false).booleanValue()) {
                    Assert.assertEquals((double)((Double)expected.get(i)[j]), (double)((Double)resultRow[j]), (double)0.01);
                    continue;
                }
                if (rowSignature.getColumnType(j).map(t -> t.is((TypeDescriptor)ValueType.FLOAT)).orElse(false).booleanValue()) {
                    Assert.assertEquals((double)((Float)expected.get(i)[j]).floatValue(), (double)((Float)resultRow[j]).floatValue(), (double)0.01);
                    continue;
                }
                Assert.assertEquals((Object)expected.get(i)[j], (Object)resultRow[j]);
            }
        }
    }

    public static <T extends Comparable> ComparableList<T> asComparableList(T ... objects) {
        return new ComparableList(Arrays.asList(objects));
    }
}

