/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.BufferArrayGrouper;
import org.apache.druid.query.groupby.epinephelinae.GroupByTestColumnSelectorFactory;
import org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.druid.query.groupby.epinephelinae.IntKey;
import org.apache.druid.query.groupby.epinephelinae.ReusableEntry;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BufferArrayGrouperTest {
    @BeforeClass
    public static void setUpStatic() {
        NullHandling.initializeForTests();
    }

    @Test
    public void testAggregate() {
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferArrayGrouper grouper = this.newGrouper(columnSelectorFactory, 32768);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        grouper.aggregate(12);
        grouper.aggregate(6);
        grouper.aggregate(10);
        grouper.aggregate(6);
        grouper.aggregate(12);
        grouper.aggregate(6);
        ImmutableList expected = ImmutableList.of((Object)new ReusableEntry((Object)new IntKey(6), new Object[]{30L, 3L}), (Object)new ReusableEntry((Object)new IntKey(10), new Object[]{10L, 1L}), (Object)new ReusableEntry((Object)new IntKey(12), new Object[]{20L, 2L}));
        GrouperTestUtil.assertEntriesEquals(expected.iterator(), grouper.iterator(false));
    }

    private BufferArrayGrouper newGrouper(GroupByTestColumnSelectorFactory columnSelectorFactory, int bufferSize) {
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        BufferArrayGrouper grouper = new BufferArrayGrouper(Suppliers.ofInstance((Object)buffer), AggregatorAdapters.factorizeBuffered((ColumnSelectorFactory)columnSelectorFactory, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("valueSum", "value"), (Object)new CountAggregatorFactory("count"))), 1000);
        grouper.init();
        return grouper;
    }

    @Test
    public void testRequiredBufferCapacity() {
        int[] cardinalityArray = new int[]{1, 10, 0x7FFFFFFE, Integer.MAX_VALUE};
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "sum")};
        long[] requiredSizes = NullHandling.sqlCompatible() ? new long[]{19L, 101L, 19595788279L, -1L} : new long[]{17L, 90L, 17448304632L, -1L};
        for (int i = 0; i < cardinalityArray.length; ++i) {
            Assert.assertEquals((String)StringUtils.format((String)"cardinality[%d]", (Object[])new Object[]{cardinalityArray[i]}), (long)requiredSizes[i], (long)BufferArrayGrouper.requiredBufferCapacity((int)cardinalityArray[i], (AggregatorFactory[])aggregatorFactories));
        }
    }
}

