/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.BufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.GroupByTestColumnSelectorFactory;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.druid.query.groupby.epinephelinae.IntKey;
import org.apache.druid.query.groupby.epinephelinae.ReusableEntry;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BufferHashGrouperTest
extends InitializedNullHandlingTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public CloserRule closerRule = new CloserRule(true);

    @Test
    public void testSimple() {
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferHashGrouper grouper = new BufferHashGrouper(Suppliers.ofInstance((Object)ByteBuffer.allocate(1000)), GrouperTestUtil.intKeySerde(), AggregatorAdapters.factorizeBuffered((ColumnSelectorFactory)columnSelectorFactory, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("valueSum", "value"), (Object)new CountAggregatorFactory("count"))), Integer.MAX_VALUE, 0.0f, 0, true);
        grouper.init();
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        grouper.aggregate((Object)new IntKey(12));
        grouper.aggregate((Object)new IntKey(6));
        grouper.aggregate((Object)new IntKey(10));
        grouper.aggregate((Object)new IntKey(6));
        grouper.aggregate((Object)new IntKey(12));
        grouper.aggregate((Object)new IntKey(12));
        ImmutableList expected = ImmutableList.of((Object)new ReusableEntry((Object)new IntKey(6), new Object[]{20L, 2L}), (Object)new ReusableEntry((Object)new IntKey(10), new Object[]{10L, 1L}), (Object)new ReusableEntry((Object)new IntKey(12), new Object[]{30L, 3L}));
        GrouperTestUtil.assertEntriesEquals(expected.iterator(), grouper.iterator(true));
        GrouperTestUtil.assertEntriesEquals(expected.iterator(), GrouperTestUtil.sortedEntries(grouper.iterator(false), k -> new IntKey(k.intValue()), Comparator.comparing(IntKey::intValue)).iterator());
    }

    @Test
    public void testGrowing() {
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        try (ResourceHolder<Grouper<IntKey>> grouperHolder = this.makeGrouper(columnSelectorFactory, 10000, 2, 0.75f);){
            int i;
            Grouper grouper = (Grouper)grouperHolder.get();
            int expectedMaxSize = NullHandling.replaceWithDefault() ? 219 : 210;
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
            for (i = 0; i < expectedMaxSize; ++i) {
                Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)new IntKey(i)).isOk());
            }
            Assert.assertFalse((boolean)grouper.aggregate((Object)new IntKey(expectedMaxSize)).isOk());
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
            for (i = 0; i < expectedMaxSize; ++i) {
                Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)new IntKey(i)).isOk());
            }
            Assert.assertFalse((boolean)grouper.aggregate((Object)new IntKey(expectedMaxSize)).isOk());
            ArrayList<ReusableEntry> expected = new ArrayList<ReusableEntry>();
            for (int i2 = 0; i2 < expectedMaxSize; ++i2) {
                expected.add(new ReusableEntry((Object)new IntKey(i2), new Object[]{21L, 2L}));
            }
            GrouperTestUtil.assertEntriesEquals(expected.iterator(), grouper.iterator(true));
        }
    }

    @Test
    public void testGrowingOverflowingInteger() {
        if (NullHandling.replaceWithDefault()) {
            GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
            try (ResourceHolder<Grouper<IntKey>> holder = this.makeGrouper(columnSelectorFactory, 1900000000, 2, 0.3f);){
                Grouper grouper = (Grouper)holder.get();
                int expectedMaxSize = 15323979;
                columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
                for (int i = 0; i < 15323979; ++i) {
                    Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)new IntKey(i)).isOk());
                }
                Assert.assertFalse((boolean)grouper.aggregate((Object)new IntKey(15323979)).isOk());
            }
        }
    }

    @Test
    public void testNoGrowing() {
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        try (ResourceHolder<Grouper<IntKey>> grouperHolder = this.makeGrouper(columnSelectorFactory, 10000, Integer.MAX_VALUE, 0.75f);){
            int i;
            Grouper grouper = (Grouper)grouperHolder.get();
            int expectedMaxSize = NullHandling.replaceWithDefault() ? 267 : 258;
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
            for (i = 0; i < expectedMaxSize; ++i) {
                Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)new IntKey(i)).isOk());
            }
            Assert.assertFalse((boolean)grouper.aggregate((Object)new IntKey(expectedMaxSize)).isOk());
            columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
            for (i = 0; i < expectedMaxSize; ++i) {
                Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)new IntKey(i)).isOk());
            }
            Assert.assertFalse((boolean)grouper.aggregate((Object)new IntKey(expectedMaxSize)).isOk());
            ArrayList<ReusableEntry> expected = new ArrayList<ReusableEntry>();
            for (int i2 = 0; i2 < expectedMaxSize; ++i2) {
                expected.add(new ReusableEntry((Object)new IntKey(i2), new Object[]{21L, 2L}));
            }
            GrouperTestUtil.assertEntriesEquals(expected.iterator(), grouper.iterator(true));
        }
    }

    private ResourceHolder<Grouper<IntKey>> makeGrouper(GroupByTestColumnSelectorFactory columnSelectorFactory, int bufferSize, int initialBuckets, float maxLoadFactor) {
        final ResourceHolder bufferHolder = ByteBufferUtils.allocateDirect((int)bufferSize);
        final BufferHashGrouper grouper = new BufferHashGrouper(() -> ((ResourceHolder)bufferHolder).get(), GrouperTestUtil.intKeySerde(), AggregatorAdapters.factorizeBuffered((ColumnSelectorFactory)columnSelectorFactory, (List)ImmutableList.of((Object)new LongSumAggregatorFactory("valueSum", "value"), (Object)new CountAggregatorFactory("count"))), Integer.MAX_VALUE, maxLoadFactor, initialBuckets, true);
        grouper.init();
        return new ResourceHolder<Grouper<IntKey>>(){

            public BufferHashGrouper<IntKey> get() {
                return grouper;
            }

            public void close() {
                grouper.close();
                bufferHolder.close();
            }
        };
    }
}

