/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.GroupByTestColumnSelectorFactory;
import org.apache.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.druid.query.groupby.epinephelinae.IntKey;
import org.apache.druid.query.groupby.epinephelinae.ReusableEntry;
import org.apache.druid.query.groupby.epinephelinae.StreamingMergeSortedGrouper;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StreamingMergeSortedGrouperTest
extends InitializedNullHandlingTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testAggregate() {
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        StreamingMergeSortedGrouper<IntKey> grouper = this.newGrouper(columnSelectorFactory, 1024);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        grouper.aggregate((Object)new IntKey(6));
        grouper.aggregate((Object)new IntKey(6));
        grouper.aggregate((Object)new IntKey(6));
        grouper.aggregate((Object)new IntKey(10));
        grouper.aggregate((Object)new IntKey(12));
        grouper.aggregate((Object)new IntKey(12));
        grouper.finish();
        ImmutableList expected = ImmutableList.of((Object)new ReusableEntry((Object)new IntKey(6), new Object[]{30L, 3L}), (Object)new ReusableEntry((Object)new IntKey(10), new Object[]{10L, 1L}), (Object)new ReusableEntry((Object)new IntKey(12), new Object[]{20L, 2L}));
        GrouperTestUtil.assertEntriesEquals(expected.iterator(), grouper.iterator(true));
    }

    @Test(timeout=60000L)
    public void testEmptyIterator() {
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        StreamingMergeSortedGrouper<IntKey> grouper = this.newGrouper(columnSelectorFactory, 1024);
        grouper.finish();
        Assert.assertTrue((!grouper.iterator(true).hasNext() ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testStreamingAggregateWithLargeBuffer() throws ExecutionException, InterruptedException {
        this.testStreamingAggregate(1024);
    }

    @Test(timeout=60000L)
    public void testStreamingAggregateWithMinimumBuffer() throws ExecutionException, InterruptedException {
        this.testStreamingAggregate(83);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStreamingAggregate(int bufferSize) throws ExecutionException, InterruptedException {
        ExecutorService exec = Execs.multiThreaded((int)2, (String)"merge-sorted-grouper-test-%d");
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        StreamingMergeSortedGrouper<IntKey> grouper = this.newGrouper(columnSelectorFactory, bufferSize);
        ArrayList<ReusableEntry> expected = new ArrayList<ReusableEntry>(1024);
        for (int i = 0; i < 1024; ++i) {
            expected.add(new ReusableEntry((Object)new IntKey(i), new Object[]{100L, 10L}));
        }
        try {
            Future<?> future = exec.submit(() -> {
                columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
                for (int i = 0; i < 1024; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        grouper.aggregate((Object)new IntKey(i));
                    }
                }
                grouper.finish();
            });
            CloseableIterator grouperIterator = grouper.iterator();
            GrouperTestUtil.assertEntriesEquals(expected.iterator(), GrouperTestUtil.sortedEntries(grouperIterator, k -> new IntKey(k.intValue()), Comparator.comparing(IntKey::intValue)).iterator());
            future.get();
        }
        finally {
            exec.shutdownNow();
        }
    }

    @Test
    public void testNotEnoughBuffer() {
        this.expectedException.expect(IllegalStateException.class);
        if (NullHandling.replaceWithDefault()) {
            this.expectedException.expectMessage("Buffer[50] should be large enough to store at least three records[20]");
        } else {
            this.expectedException.expectMessage("Buffer[50] should be large enough to store at least three records[21]");
        }
        this.newGrouper(GrouperTestUtil.newColumnSelectorFactory(), 50);
    }

    @Test
    public void testTimeout() {
        this.expectedException.expect(QueryTimeoutException.class);
        GroupByTestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        StreamingMergeSortedGrouper<IntKey> grouper = this.newGrouper(columnSelectorFactory, 100);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        grouper.aggregate((Object)new IntKey(6));
        grouper.iterator();
    }

    private StreamingMergeSortedGrouper<IntKey> newGrouper(GroupByTestColumnSelectorFactory columnSelectorFactory, int bufferSize) {
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        StreamingMergeSortedGrouper grouper = new StreamingMergeSortedGrouper(Suppliers.ofInstance((Object)buffer), GrouperTestUtil.intKeySerde(), (ColumnSelectorFactory)columnSelectorFactory, new AggregatorFactory[]{new LongSumAggregatorFactory("valueSum", "value"), new CountAggregatorFactory("count")}, System.currentTimeMillis() + 1000L);
        grouper.init();
        return grouper;
    }
}

