/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.query.operator.InlineScanOperator;
import org.apache.druid.query.operator.OperatorSequence;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.junit.Assert;
import org.junit.Test;

public class OperatorSequenceTest {
    @Test
    public void testAccumulateAndYielderJustOne() {
        OperatorSequence seq = new OperatorSequence(() -> InlineScanOperator.make(new RowsAndColumns[]{MapOfColumnsRowsAndColumns.of((String)"hi", (Column)new IntArrayColumn(new int[]{1}))}));
        final RowsAndColumnsHelper helper = new RowsAndColumnsHelper().expectColumn("hi", new int[]{1}).allColumnsRegistered();
        Assert.assertEquals((long)1L, (long)((Integer)seq.accumulate((Object)0, (accumulated, in) -> {
            helper.validate((RowsAndColumns)in);
            return accumulated + 1;
        })).intValue());
        Yielder yielder = seq.toYielder((Object)0, (YieldingAccumulator)new YieldingAccumulator<Integer, RowsAndColumns>(){

            public Integer accumulate(Integer accumulated, RowsAndColumns in) {
                this.yield();
                helper.validate(in);
                return accumulated + 1;
            }
        });
        Assert.assertFalse((boolean)yielder.isDone());
        Assert.assertEquals((long)1L, (long)((Integer)yielder.get()).intValue());
        yielder = yielder.next((Object)0);
        Assert.assertTrue((boolean)yielder.isDone());
    }

    @Test
    public void testAccumulateAndYielderMultiple() {
        int[] expectedTotals;
        OperatorSequence seq = new OperatorSequence(() -> InlineScanOperator.make(new RowsAndColumns[]{MapOfColumnsRowsAndColumns.of((String)"hi", (Column)new IntArrayColumn(new int[]{1})), MapOfColumnsRowsAndColumns.of((String)"hi", (Column)new IntArrayColumn(new int[]{2})), MapOfColumnsRowsAndColumns.of((String)"hi", (Column)new IntArrayColumn(new int[]{3, 4})), MapOfColumnsRowsAndColumns.of((String)"hi", (Column)new IntArrayColumn(new int[]{5, 6, 7, 8})), MapOfColumnsRowsAndColumns.of((String)"hi", (Column)new IntArrayColumn(new int[]{9, 10, 11})), MapOfColumnsRowsAndColumns.of((String)"hi", (Column)new IntArrayColumn(new int[]{12, 13, 14, 15}))}));
        Assert.assertEquals((long)120L, (long)((Integer)seq.accumulate((Object)0, (accumulated, in) -> {
            ColumnAccessor col = in.findColumn("hi").toAccessor();
            for (int i = 0; i < col.numRows(); ++i) {
                accumulated = accumulated + col.getInt(i);
            }
            return accumulated;
        })).intValue());
        Yielder yielder = seq.toYielder((Object)0, (YieldingAccumulator)new YieldingAccumulator<Integer, RowsAndColumns>(){

            public Integer accumulate(Integer accumulated, RowsAndColumns in) {
                ColumnAccessor col = in.findColumn("hi").toAccessor();
                for (int i = 0; i < col.numRows(); ++i) {
                    accumulated = accumulated + col.getInt(i);
                }
                return accumulated;
            }
        });
        Assert.assertEquals((long)120L, (long)((Integer)yielder.get()).intValue());
        Assert.assertTrue((boolean)yielder.isDone());
        yielder = seq.toYielder((Object)0, (YieldingAccumulator)new YieldingAccumulator<Integer, RowsAndColumns>(){

            public Integer accumulate(Integer accumulated, RowsAndColumns in) {
                ColumnAccessor col = in.findColumn("hi").toAccessor();
                for (int i = 0; i < col.numRows(); ++i) {
                    accumulated = accumulated + col.getInt(i);
                }
                if (accumulated == 120) {
                    this.yield();
                }
                return accumulated;
            }
        });
        Assert.assertEquals((long)120L, (long)((Integer)yielder.get()).intValue());
        Assert.assertFalse((boolean)yielder.isDone());
        yielder = yielder.next((Object)0);
        Assert.assertTrue((boolean)yielder.isDone());
        yielder = seq.toYielder((Object)0, (YieldingAccumulator)new YieldingAccumulator<Integer, RowsAndColumns>(){

            public Integer accumulate(Integer accumulated, RowsAndColumns in) {
                this.yield();
                ColumnAccessor col = in.findColumn("hi").toAccessor();
                for (int i = 0; i < col.numRows(); ++i) {
                    accumulated = accumulated + col.getInt(i);
                }
                return accumulated;
            }
        });
        for (int expectedTotal : expectedTotals = new int[]{1, 2, 7, 26, 30, 54}) {
            Assert.assertEquals((long)expectedTotal, (long)((Integer)yielder.get()).intValue());
            Assert.assertFalse((boolean)yielder.isDone());
            yielder = yielder.next((Object)0);
        }
        Assert.assertTrue((boolean)yielder.isDone());
    }
}

