/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.junit.Assert;

public class OperatorTestHelper {
    private Supplier<TestReceiver> receiverSupply;
    private Consumer<TestReceiver> finalValidation;

    public OperatorTestHelper expectRowsAndColumns(final RowsAndColumnsHelper ... helpers) {
        return this.withPushFn(new JustPushMe(){
            int index = 0;

            @Override
            public Operator.Signal push(RowsAndColumns rac) {
                helpers[this.index++].validate(rac);
                return Operator.Signal.GO;
            }
        }).withFinalValidation(testReceiver -> Assert.assertEquals((long)helpers.length, (long)testReceiver.getNumPushed()));
    }

    public OperatorTestHelper expectAndStopAfter(final RowsAndColumnsHelper ... helpers) {
        return this.withPushFn(new JustPushMe(){
            int index = 0;

            @Override
            public Operator.Signal push(RowsAndColumns rac) {
                helpers[this.index++].validate(rac);
                return this.index < helpers.length ? Operator.Signal.GO : Operator.Signal.STOP;
            }
        }).withFinalValidation(testReceiver -> Assert.assertEquals((long)helpers.length, (long)testReceiver.getNumPushed()));
    }

    public OperatorTestHelper withReceiver(Supplier<TestReceiver> receiver) {
        if (this.receiverSupply != null) {
            throw new ISE("Receiver[%s] already set, cannot set it again[%s].", new Object[]{this.receiverSupply, receiver});
        }
        this.receiverSupply = receiver;
        return this;
    }

    public OperatorTestHelper withFinalValidation(Consumer<TestReceiver> validator) {
        if (this.finalValidation == null) {
            this.finalValidation = validator;
        } else {
            Consumer<TestReceiver> subValidator = this.finalValidation;
            this.finalValidation = receiver -> {
                subValidator.accept((TestReceiver)receiver);
                validator.accept((TestReceiver)receiver);
            };
        }
        return this;
    }

    public OperatorTestHelper withPushFn(JustPushMe fn) {
        return this.withReceiver(() -> new TestReceiver(fn));
    }

    public OperatorTestHelper runToCompletion(Operator op) {
        TestReceiver receiver = this.receiverSupply.get();
        Operator.go((Operator)op, (Operator.Receiver)receiver);
        Assert.assertTrue((boolean)receiver.isCompleted());
        if (this.finalValidation != null) {
            this.finalValidation.accept(receiver);
        }
        return this;
    }

    public static class TestReceiver
    implements Operator.Receiver {
        private final JustPushMe pushFn;
        private AtomicLong numPushed = new AtomicLong();
        private AtomicBoolean completed = new AtomicBoolean(false);

        public TestReceiver(JustPushMe pushFn) {
            this.pushFn = pushFn;
        }

        public Operator.Signal push(RowsAndColumns rac) {
            this.numPushed.incrementAndGet();
            return this.pushFn.push(rac);
        }

        public boolean isCompleted() {
            return this.completed.get();
        }

        public void completed() {
            if (!this.completed.compareAndSet(false, true)) {
                throw new ISE("complete called more than once!?  Why.", new Object[0]);
            }
        }

        public long getNumPushed() {
            return this.numPushed.get();
        }
    }

    public static interface JustPushMe {
        public Operator.Signal push(RowsAndColumns var1);
    }
}

